/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFileAttributeException;

public final class ExceptionTableEntry {
    int startPC;
    int endPC;
    int handlerPC;
    CPClassInfo catchType;

    static ExceptionTableEntry[] loadExceptionTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        ExceptionTableEntry[] exceptionTableEntryArray = new ExceptionTableEntry[n];
        for (int i = 0; i < n; ++i) {
            exceptionTableEntryArray[i] = new ExceptionTableEntry(dataInputStream, constantPool);
        }
        return exceptionTableEntryArray;
    }

    ExceptionTableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.loadExceptionEntry(dataInputStream, constantPool);
    }

    private void loadExceptionEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.startPC = dataInputStream.readUnsignedShort();
        this.endPC = dataInputStream.readUnsignedShort();
        this.handlerPC = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        if (n != 0) {
            try {
                this.catchType = constantPool.getClass(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidClassFileAttributeException("invalid catchType (" + n + ") in exception table entry", indexOutOfBoundsException);
            }
        }
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final int getEndPC() {
        return this.endPC;
    }

    public final int getHandlerPC() {
        return this.handlerPC;
    }

    public final CPClassInfo getCatchType() {
        return this.catchType;
    }
}

