/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import org.netbeans.insane.impl.InsaneEngine;
import org.netbeans.insane.impl.ObjectFoundException;
import org.netbeans.insane.impl.Root;
import org.netbeans.insane.impl.Utils;
import org.netbeans.insane.live.Path;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class LiveEngine
implements ObjectMap,
Visitor {
    private IdentityHashMap objects = new IdentityHashMap();
    private Map rest = new IdentityHashMap();
    private BoundedRangeModel progress;
    private int objCount;
    private int objExpected;
    private int objStep;

    public LiveEngine() {
    }

    public LiveEngine(BoundedRangeModel boundedRangeModel) {
        this.progress = boundedRangeModel;
    }

    public boolean isKnown(Object object) {
        return this.objects.containsKey(object);
    }

    public String getID(Object object) {
        this.objects.put(object, null);
        return null;
    }

    public void visitClass(Class clazz) {
    }

    public void visitObject(ObjectMap objectMap, Object object) {
        if (this.progress != null) {
            ++this.objCount;
            if (this.objCount % this.objStep == 0 && this.objCount < this.objExpected) {
                this.progress.setValue(this.objCount);
            }
        }
    }

    public void visitArrayReference(ObjectMap objectMap, Object object, Object object2, int n) {
        this.visitRef(object, object2, null);
    }

    public void visitObjectReference(ObjectMap objectMap, Object object, Object object2, Field field) {
        this.visitRef(object, object2, field);
    }

    public void visitStaticReference(ObjectMap objectMap, Object object, Field field) {
        this.visitRef(null, object, field);
    }

    private void visitRef(Object object, Object object2, Field field) {
        this.addIncommingRef(object2, object, field);
        if (this.rest.containsKey(object2)) {
            this.rest.remove(object2);
            if (this.rest.size() == 0) {
                throw new ObjectFoundException();
            }
        }
    }

    private void addIncommingRef(Object object, Object object2, Field field) {
        Object object3 = object2 != null ? object2 : Root.createStatic(field, object);
        Object object4 = this.objects.get(object);
        if (object4 == null) {
            object4 = object3 instanceof Object[] ? new Object[]{object3} : object3;
        } else if (!(object4 instanceof Object[])) {
            object4 = new Object[]{object4, object3};
        } else {
            int n = ((Object[])object4).length;
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(object4, 0, objectArray, 0, n);
            objectArray[n] = object3;
            object4 = objectArray;
        }
        this.objects.put(object, object4);
    }

    private Iterator getIncomingRefs(Object object) {
        Object v = this.objects.get(object);
        if (v instanceof Object[]) {
            return Arrays.asList((Object[])v).iterator();
        }
        return Collections.singleton(v).iterator();
    }

    public Map trace(Collection collection, Set set) {
        Object object;
        if (this.progress != null) {
            long l = Utils.getUsedMemory();
            this.objExpected = (int)(l / 50L);
            this.objStep = this.objExpected / 200;
            this.progress.setRangeProperties(0, 0, 0, 10 * this.objExpected / 9, false);
        }
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            this.rest.put(object2.next(), "");
        }
        object2 = new HashSet(ScannerUtils.interestingRoots());
        if (set != null) {
            object2.addAll(set);
        }
        try {
            object = new InsaneEngine(this, ScannerUtils.skipNonStrongReferencesFilter(), this, true);
            ((InsaneEngine)object).traverse((Collection)object2);
        }
        catch (ObjectFoundException objectFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.progress != null) {
            this.progress.setValue(this.objExpected);
        }
        object = new IdentityHashMap();
        int n = collection.size() - this.rest.size();
        int n2 = this.objExpected;
        int n3 = n > 0 ? this.objExpected / 9 / n : 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.rest.containsKey(e)) continue;
            Path path = this.findRoots(e, (Set)object2);
            if (path != null) {
                object.put(e, path);
            }
            if (this.progress == null) continue;
            this.progress.setValue(n2 += n3);
        }
        return object;
    }

    private Path findRoots(Object object, Set set) {
        HashSet<Path> hashSet = new HashSet<Path>();
        Path path = Utils.createPath(object, null);
        LinkedList<Path> linkedList = new LinkedList<Path>();
        linkedList.add(path);
        hashSet.add(path);
        while (!linkedList.isEmpty()) {
            Path path2 = (Path)linkedList.remove(0);
            Object object2 = path2.getObject();
            if (set.contains(object2)) {
                return path2;
            }
            Iterator iterator = this.getIncomingRefs(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Path path3 = Utils.createPath(e, path2);
                if (e instanceof Root) {
                    return path3;
                }
                if (hashSet.contains(path3)) continue;
                hashSet.add(path3);
                linkedList.add(path3);
            }
        }
        return null;
    }
}

