/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaCompletionItem
implements CompletionItem {
    protected static int SMART_TYPE = 1000;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;
    private static final int PUBLIC_LEVEL = 3;
    private static final int PROTECTED_LEVEL = 2;
    private static final int PACKAGE_LEVEL = 1;
    private static final int PRIVATE_LEVEL = 0;

    public static final JavaCompletionItem createKeywordItem(String string, String string2, int n, boolean bl) {
        return new KeywordItem(string, 0, string2, n, bl);
    }

    public static final JavaCompletionItem createPackageItem(String string, int n, boolean bl) {
        return new PackageItem(string, n, bl);
    }

    public static final JavaCompletionItem createTypeItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl, boolean bl2, boolean bl3) {
        switch (typeElement.getKind()) {
            case CLASS: {
                return new ClassItem(typeElement, declaredType, 0, n, bl, bl2, bl3);
            }
            case INTERFACE: {
                return new InterfaceItem(typeElement, declaredType, 0, n, bl, bl2, bl3);
            }
            case ENUM: {
                return new EnumItem(typeElement, declaredType, 0, n, bl, bl2, bl3);
            }
            case ANNOTATION_TYPE: {
                return new AnnotationTypeItem(typeElement, declaredType, 0, n, bl, bl2, bl3);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)typeElement.getKind()));
    }

    public static final JavaCompletionItem createArrayItem(ArrayType arrayType, int n, Elements elements) {
        int n2 = 0;
        TypeMirror typeMirror = arrayType;
        while (typeMirror.getKind() == TypeKind.ARRAY) {
            typeMirror = typeMirror.getComponentType();
            ++n2;
        }
        if (typeMirror.getKind().isPrimitive()) {
            return new KeywordItem(((Object)typeMirror).toString(), n2, null, n, true);
        }
        if (typeMirror.getKind() == TypeKind.DECLARED || typeMirror.getKind() == TypeKind.ERROR) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            switch (typeElement.getKind()) {
                case CLASS: {
                    return new ClassItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), true);
                }
                case INTERFACE: {
                    return new InterfaceItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), true);
                }
                case ENUM: {
                    return new EnumItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), true);
                }
                case ANNOTATION_TYPE: {
                    return new AnnotationTypeItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), true);
                }
            }
        }
        throw new IllegalArgumentException("array element kind=" + (Object)((Object)typeMirror.getKind()));
    }

    public static final JavaCompletionItem createTypeParameterItem(TypeParameterElement typeParameterElement, int n) {
        return new TypeParameterItem(typeParameterElement, n);
    }

    public static final JavaCompletionItem createVariableItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl, boolean bl2, boolean bl3) {
        switch (variableElement.getKind()) {
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return new VariableItem(typeMirror, variableElement.getSimpleName().toString(), n, bl3);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return new FieldItem(variableElement, typeMirror, n, bl, bl2, bl3);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)variableElement.getKind()));
    }

    public static final JavaCompletionItem createVariableItem(String string, int n, boolean bl) {
        return new VariableItem(null, string, n, bl);
    }

    public static final JavaCompletionItem createExecutableItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        switch (executableElement.getKind()) {
            case METHOD: {
                return new MethodItem(executableElement, executableType, n, bl, bl2, bl3, bl4);
            }
            case CONSTRUCTOR: {
                return new ConstructorItem(executableElement, executableType, n, bl2);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)executableElement.getKind()));
    }

    public static final JavaCompletionItem createOverrideMethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
        switch (executableElement.getKind()) {
            case METHOD: {
                return new OverrideMethodItem(executableElement, executableType, n, bl);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)executableElement.getKind()));
    }

    public static final JavaCompletionItem createDefaultConstructorItem(TypeElement typeElement, int n) {
        return new DefaultConstructorItem(typeElement, n);
    }

    public static final JavaCompletionItem createAnnotationItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl) {
        return new AnnotationItem(typeElement, declaredType, n, bl, true);
    }

    public static final JavaCompletionItem createAttributeItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
        return new AttributeItem(executableElement, executableType, n, bl);
    }

    public static final JavaCompletionItem createStaticMemberItem(DeclaredType declaredType, Element element, TypeMirror typeMirror, int n, boolean bl) {
        switch (element.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case METHOD: {
                return new StaticMemberItem(declaredType, element, typeMirror, n, bl);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)element.getKind()));
    }

    public static final JavaCompletionItem createInitializeAllConstructorItem(Iterable<? extends VariableElement> iterable, TypeElement typeElement, int n) {
        return new InitializeAllConstructorItem(iterable, typeElement, n);
    }

    JavaCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            switch (keyEvent.getKeyChar()) {
                case '(': 
                case ',': 
                case ';': {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }
                case '.': {
                    JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                    int n = jTextComponent.getSelectionEnd();
                    this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
                    if (keyEvent.getKeyChar() == '.') {
                        Completion.get().showCompletion();
                    }
                    keyEvent.consume();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string2 = ((Object)this.getInsertPrefix()).toString();
        if (string2 != null) {
            TokenSequence<JavaTokenId> tokenSequence;
            if (string != null && !string.equals("\n")) {
                tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    string2 = string2 + string;
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string3 = ((Object)tokenSequence.token().text()).toString();
                    if (string3.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        string2 = string2 + string;
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string3)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        string2 = string2 + string.substring(0, string3.length());
                        string = string.substring(string3.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        string2 = string2 + string;
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        string2 = string2 + string;
                    }
                    string = null;
                }
            }
            baseDocument.atomicLock();
            try {
                tokenSequence = baseDocument.getText(n, n2);
                if (string2.equals(tokenSequence)) {
                    return;
                }
                Position position = baseDocument.createPosition(n);
                baseDocument.remove(n, n2);
                baseDocument.insertString(position.getOffset(), string2, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    private static int getProtectionLevel(Set<Modifier> set) {
        if (set.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (set.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (set.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        return 1;
    }

    private static String escape(String string) {
        if (string != null) {
            try {
                return XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static class AnnotationItem
    extends AnnotationTypeItem {
        private AnnotationItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl, boolean bl2) {
            super(typeElement, declaredType, 0, n, true, bl, bl2);
        }

        public CharSequence getInsertPrefix() {
            return "@" + super.getInsertPrefix();
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            if (string != null && !string.equals("\n")) {
                TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string2 = ((Object)tokenSequence.token().text()).toString();
                    if (string2.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string2)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string2.length()));
                        string = string.substring(string2.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n3 = n2;
            JavaSource javaSource = JavaSource.forDocument((Document)baseDocument);
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws IOException {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement typeElement = (TypeElement)AnnotationItem.this.elementHandle.resolve((CompilationInfo)compilationController);
                        baseDocument.atomicLock();
                        try {
                            TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                            stringBuilder.insert(0, "@" + AutoImport.resolveImport((CompilationInfo)compilationController, treePath, compilationController.getTypes().getDeclaredType(typeElement, new TypeMirror[0])));
                            String string = baseDocument.getText(n, n3);
                            if (string.contentEquals(stringBuilder)) {
                                return;
                            }
                            baseDocument.remove(n, n3);
                            baseDocument.insertString(n, stringBuilder.toString(), null);
                        }
                        catch (BadLocationException badLocationException) {
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class AnnotationTypeItem
    extends ClassItem {
        private static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
        private static ImageIcon icon;

        private AnnotationTypeItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ANNOTATION));
            }
            return icon;
        }
    }

    private static class AttributeItem
    extends JavaCompletionItem {
        private static final String ATTRIBUTE = "org/netbeans/modules/java/editor/resources/attribute_16.png";
        private static final String ATTRIBUTE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private String typeName;
        private String defaultValue;
        private String leftText;
        private String rightText;

        private AttributeItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl;
            this.simpleName = executableElement.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(executableType.getReturnType(), false)).toString();
            AnnotationValue annotationValue = executableElement.getDefaultValue();
            this.defaultValue = annotationValue != null ? ((Object)annotationValue).toString() : null;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName + "=";
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ATTRIBUTE));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(ATTRIBUTE_COLOR);
                if (this.defaultValue == null) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.defaultValue == null) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                } else {
                    stringBuilder.append(" = ");
                    stringBuilder.append(this.defaultValue);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class ClassItem
    extends JavaCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static ImageIcon icon;
        protected ElementHandle<TypeElement> elementHandle;
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private int dim;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private String typeName;
        private String enclName;
        private CharSequence sortText;
        private String leftText;

        private ClassItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            super(n2);
            this.elementHandle = ElementHandle.create((Element)typeElement);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)declaredType);
            this.dim = n;
            this.isDeprecated = bl2;
            this.smartType = bl3;
            this.simpleName = typeElement.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(declaredType, false)).toString();
            if (bl) {
                this.enclName = ((Object)Utilities.getElementName(typeElement.getEnclosingElement(), true)).toString();
                this.sortText = new ClassSortText(this.simpleName, this.enclName);
            } else {
                this.enclName = null;
                this.sortText = this.simpleName;
            }
        }

        public int getSortPriority() {
            return this.smartType ? 800 - SMART_TYPE : 800;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CLASS));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getColor());
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(JavaCompletionItem.escape(this.typeName));
                for (int i = 0; i < this.dim; ++i) {
                    stringBuilder.append("[]");
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.enclName != null && this.enclName.length() > 0) {
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    stringBuilder.append(PKG_COLOR);
                    stringBuilder.append(" (");
                    stringBuilder.append(this.enclName);
                    stringBuilder.append(")");
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String string) {
            if (this.enclName == null) {
                super.substituteText(jTextComponent, n, n2, string);
                return;
            }
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            if (string != null && !string.equals("\n")) {
                TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string2 = ((Object)tokenSequence.token().text()).toString();
                    if (string2.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string2)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string2.length()));
                        string = string.substring(string2.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n3 = n2;
            JavaSource javaSource = JavaSource.forDocument((Document)baseDocument);
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws IOException {
                        Object object;
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement typeElement = (TypeElement)ClassItem.this.elementHandle.resolve((CompilationInfo)compilationController);
                        DeclaredType declaredType = (DeclaredType)ClassItem.this.typeHandle.resolve((CompilationInfo)compilationController);
                        boolean bl = false;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        int n2 = 1;
                        stringBuilder2.append("${PAR");
                        stringBuilder2.append(n2++);
                        if (declaredType.getKind() != TypeKind.ERROR) {
                            stringBuilder2.append(" type=\"");
                            stringBuilder2.append(typeElement.getQualifiedName());
                        } else {
                            stringBuilder2.append(" default=\"");
                            stringBuilder2.append(typeElement.getQualifiedName());
                        }
                        stringBuilder2.append("\" editable=false}");
                        Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            stringBuilder2.append('<');
                            while (iterator.hasNext()) {
                                TypeMirror typeMirror = iterator.next();
                                stringBuilder2.append("${PAR");
                                stringBuilder2.append(n2++);
                                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                                    object = (TypeVariable)typeMirror;
                                    if (typeElement == object.asElement().getEnclosingElement()) {
                                        stringBuilder2.append(" type=\"");
                                        typeMirror = object.getUpperBound();
                                    } else {
                                        stringBuilder2.append(" editable=false default=\"");
                                        bl = true;
                                    }
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, true));
                                    stringBuilder2.append("\"}");
                                } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
                                    stringBuilder2.append(" type=\"");
                                    object = ((WildcardType)typeMirror).getExtendsBound();
                                    if (object == null) {
                                        object = ((WildcardType)typeMirror).getSuperBound();
                                    }
                                    stringBuilder2.append(object != null ? Utilities.getTypeName((TypeMirror)object, true) : "java.lang.Object");
                                    stringBuilder2.append("\"}");
                                    bl = true;
                                } else if (typeMirror.getKind() == TypeKind.ERROR) {
                                    stringBuilder2.append(" default=\"\"}");
                                    bl = true;
                                } else {
                                    stringBuilder2.append(" type=\"");
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, true));
                                    stringBuilder2.append("\" editable=false}");
                                    bl = true;
                                }
                                if (!iterator.hasNext()) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append('>');
                        }
                        for (int i = 0; i < ClassItem.this.dim; ++i) {
                            stringBuilder2.append("[${PAR");
                            stringBuilder2.append(n2++);
                            stringBuilder2.append(" instanceof=\"int\" default=\"\"}]");
                            bl = true;
                        }
                        if (bl) {
                            CodeTemplateManager codeTemplateManager;
                            if (n3 > 0) {
                                baseDocument.atomicLock();
                                try {
                                    baseDocument.remove(n, n3);
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                finally {
                                    baseDocument.atomicUnlock();
                                }
                            }
                            if ((codeTemplateManager = CodeTemplateManager.get((Document)baseDocument)) != null) {
                                codeTemplateManager.createTemporary(stringBuilder2.append((CharSequence)stringBuilder).toString()).insert(jTextComponent);
                            }
                        } else {
                            baseDocument.atomicLock();
                            try {
                                TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                                stringBuilder.insert(0, AutoImport.resolveImport((CompilationInfo)compilationController, treePath, compilationController.getTypes().getDeclaredType(typeElement, new TypeMirror[0])));
                                object = baseDocument.getText(n, n3);
                                if (((String)object).contentEquals(stringBuilder)) {
                                    return;
                                }
                                baseDocument.remove(n, n3);
                                baseDocument.insertString(n, stringBuilder.toString(), null);
                            }
                            catch (BadLocationException badLocationException) {
                            }
                            finally {
                                baseDocument.atomicUnlock();
                            }
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class ClassSortText
    implements CharSequence {
        private String name;
        private String pkgName;
        private String text;

        public ClassSortText(String string, String string2) {
            this.name = string + "#";
            this.pkgName = string2;
        }

        public int length() {
            return this.name.length() + this.pkgName.length() + 3;
        }

        public char charAt(int n) {
            return n < this.name.length() ? this.name.charAt(n) : this.getText().charAt(n);
        }

        public CharSequence subSequence(int n, int n2) {
            return this.getText().subSequence(n, n2);
        }

        private String getText() {
            if (this.text == null) {
                this.text = this.name + Utilities.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
            }
            return this.text;
        }
    }

    private static class ConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
        private static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
        private static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
        private static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[] icon = new ImageIcon[4];
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private ConstructorItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl;
            this.simpleName = executableElement.getEnclosingElement().getSimpleName().toString();
            this.modifiers = executableElement.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                TypeMirror typeMirror = iterator2.next();
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)Utilities.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            this.isAbstract = executableElement.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public int getSortPriority() {
            return 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(CONSTRUCTOR_COLOR);
                stringBuilder.append(JavaCompletionItem.BOLD);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append(JavaCompletionItem.BOLD_END);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon;
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            ImageIcon imageIcon2 = icon[n];
            if (imageIcon2 != null) {
                return imageIcon2;
            }
            String string = CONSTRUCTOR_PUBLIC;
            switch (n) {
                case 0: {
                    string = CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    string = CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    string = CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    string = CONSTRUCTOR_PUBLIC;
                }
            }
            ConstructorItem.icon[n] = imageIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)string));
            return imageIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            JavaSource javaSource;
            Object object;
            String string2;
            n += n2;
            n2 = 0;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n);
            if (tokenSequence != null) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JavaTokenId.THIS || tokenSequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (string == null) {
                        string = ";";
                    }
                }
                tokenSequence.moveNext();
            }
            String string3 = string2 = this.isAbstract ? "() {}" : "()";
            if (string != null && !string2.startsWith(string)) {
                string2 = string2 + string;
            }
            String string4 = "";
            if (tokenSequence == null) {
                string4 = string4 + string2;
                string2 = null;
            }
            boolean bl = false;
            while (string2 != null && string2.length() > 0) {
                object = ((Object)tokenSequence.token().text()).toString();
                if (((String)object).startsWith(string2)) {
                    n2 = tokenSequence.offset() - n + string2.length();
                    string4 = string4 + string2;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith((String)object)) {
                    tokenSequence.moveNext();
                    n2 = tokenSequence.offset() - n;
                    string4 = string4 + string2.substring(0, ((String)object).length());
                    string2 = string2.substring(((String)object).length());
                    bl = true;
                    continue;
                }
                if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                    if (tokenSequence.moveNext()) continue;
                    string4 = string4 + string2;
                    string2 = null;
                    continue;
                }
                if (!bl) {
                    string4 = string4 + string2;
                }
                string2 = null;
            }
            baseDocument.atomicLock();
            try {
                object = baseDocument.createPosition(n);
                baseDocument.remove(n, n2);
                baseDocument.insertString(object.getOffset(), string4, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
            object = null;
            if (this.isAbstract && string4.length() > 3) {
                try {
                    javaSource = JavaSource.forDocument((Document)baseDocument);
                    final int n3 = n + 4;
                    javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath treePath = workingCopy.getTreeUtilities().pathFor(n3);
                            while (treePath.getLeaf() != treePath.getCompilationUnit()) {
                                Tree tree = treePath.getLeaf();
                                Tree tree2 = treePath.getParentPath().getLeaf();
                                if (tree2.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(workingCopy, treePath);
                                    break;
                                }
                                treePath = treePath.getParentPath();
                            }
                        }
                    }).commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.params.isEmpty() && string4.length() > 1 && (javaSource = CodeTemplateManager.get((Document)baseDocument)) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append("${");
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(" named instanceof=");
                    stringBuilder.append(paramDesc.fullTypeName);
                    stringBuilder.append("}");
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                if (object != null) {
                    n = object.getOffset();
                }
                jTextComponent.setCaretPosition(n + 1);
                javaSource.createTemporary(stringBuilder.toString()).insert(jTextComponent);
                Completion.get().showToolTip();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<Object> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (ParamDesc)iterator.next();
                stringBuilder.append(((ParamDesc)object).typeName);
                stringBuilder.append(' ');
                stringBuilder.append(((ParamDesc)object).name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class DefaultConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static ImageIcon icon;
        private String simpleName;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private DefaultConstructorItem(TypeElement typeElement, int n) {
            super(n);
            this.simpleName = typeElement.getSimpleName().toString();
            this.isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public int getSortPriority() {
            return 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                this.sortText = this.simpleName + "#0#";
            }
            return this.sortText;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = CONSTRUCTOR_COLOR + this.simpleName + "()" + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CONSTRUCTOR));
            }
            return icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            Object object;
            String string2;
            n += n2;
            n2 = 0;
            TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n);
            if (tokenSequence != null) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JavaTokenId.THIS || tokenSequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (string == null) {
                        string = ";";
                    }
                }
                tokenSequence.moveNext();
            }
            String string3 = string2 = this.isAbstract ? "() {}" : "()";
            if (string != null && !string2.startsWith(string)) {
                string2 = string2 + string;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string4 = "";
            if (tokenSequence == null) {
                string4 = string4 + string2;
                string2 = null;
            }
            boolean bl = false;
            while (string2 != null && string2.length() > 0) {
                object = ((Object)tokenSequence.token().text()).toString();
                if (((String)object).startsWith(string2)) {
                    n2 = tokenSequence.offset() - n + string2.length();
                    string4 = string4 + string2;
                    string2 = null;
                    continue;
                }
                if (string2.startsWith((String)object)) {
                    tokenSequence.moveNext();
                    n2 = tokenSequence.offset() - n;
                    string4 = string4 + string2.substring(0, ((String)object).length());
                    string2 = string2.substring(((String)object).length());
                    bl = true;
                    continue;
                }
                if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                    if (tokenSequence.moveNext()) continue;
                    string4 = string4 + string2;
                    string2 = null;
                    continue;
                }
                if (!bl) {
                    string4 = string4 + string2;
                }
                string2 = null;
            }
            baseDocument.atomicLock();
            try {
                object = baseDocument.createPosition(n);
                baseDocument.remove(n, n2);
                baseDocument.insertString(object.getOffset(), string4, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
            if (this.isAbstract && string4.length() > 3) {
                try {
                    object = JavaSource.forDocument((Document)jTextComponent.getDocument());
                    final int n3 = jTextComponent.getSelectionEnd() - string4.length() + 4;
                    object.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath treePath = workingCopy.getTreeUtilities().pathFor(n3);
                            while (treePath.getLeaf() != treePath.getCompilationUnit()) {
                                Tree tree = treePath.getLeaf();
                                Tree tree2 = treePath.getParentPath().getLeaf();
                                if (tree2.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(workingCopy, treePath);
                                    break;
                                }
                                treePath = treePath.getParentPath();
                            }
                        }
                    }).commit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.simpleName + "()";
        }
    }

    private static class EnumItem
    extends ClassItem {
        private static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
        private static ImageIcon icon;

        private EnumItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ENUM));
            }
            return icon;
        }
    }

    private static class FieldItem
    extends JavaCompletionItem {
        private static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
        private static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
        private static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private ElementHandle<VariableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private Set<Modifier> modifiers;
        private String typeName;
        private String leftText;
        private String rightText;

        private FieldItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl, boolean bl2, boolean bl3) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)variableElement);
            this.isInherited = bl;
            this.isDeprecated = bl2;
            this.smartType = bl3;
            this.simpleName = variableElement.getSimpleName().toString();
            this.modifiers = variableElement.getModifiers();
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
        }

        public int getSortPriority() {
            return this.smartType ? 300 - SMART_TYPE : 300;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(FIELD_COLOR);
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon imageIcon = icon[bl ? 1 : 0][n];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = FIELD_PUBLIC;
            if (bl) {
                switch (n) {
                    case 0: {
                        string = FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon2 = new ImageIcon(org.openide.util.Utilities.loadImage((String)string));
            FieldItem.icon[bl ? 1 : 0][n] = imageIcon2;
            return imageIcon2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Modifier modifier : this.modifiers) {
                stringBuilder.append(modifier.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.simpleName);
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitializeAllConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon icon;
        private List<ElementHandle<VariableElement>> fieldHandles = new ArrayList<ElementHandle<VariableElement>>();
        private String simpleName;
        private List<ParamDesc> params = new ArrayList<ParamDesc>();
        private String sortText;
        private String leftText;

        private InitializeAllConstructorItem(Iterable<? extends VariableElement> iterable, TypeElement typeElement, int n) {
            super(n);
            for (VariableElement variableElement : iterable) {
                this.fieldHandles.add((ElementHandle<VariableElement>)ElementHandle.create((Element)variableElement));
                this.params.add(new ParamDesc(null, ((Object)Utilities.getTypeName(variableElement.asType(), false)).toString(), variableElement.getSimpleName().toString()));
            }
            this.simpleName = typeElement.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 400;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(CONSTRUCTOR_COLOR);
                stringBuilder.append(this.simpleName);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                stringBuilder.append(" - generate");
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CONSTRUCTOR_PUBLIC));
            }
            return icon;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (n2 > 0) {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, n2);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            try {
                JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.PARSED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                            for (Object object : InitializeAllConstructorItem.this.fieldHandles) {
                                arrayList.add((VariableElement)object.resolve((CompilationInfo)workingCopy));
                            }
                            int n2 = 0;
                            for (Tree tree : ((ClassTree)treePath.getLeaf()).getMembers()) {
                                if (workingCopy.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), tree) >= (long)n) break;
                                ++n2;
                            }
                            GeneratorUtils.generateConstructor(workingCopy, treePath, arrayList, null, n2);
                        }
                    }
                }).commit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("public ");
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<ParamDesc> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                ParamDesc paramDesc = iterator.next();
                stringBuilder.append(paramDesc.typeName);
                stringBuilder.append(' ');
                stringBuilder.append(paramDesc.name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            stringBuilder.append(" - generate");
            return stringBuilder.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    private static class InterfaceItem
    extends ClassItem {
        private static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;

        private InterfaceItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)INTERFACE));
            }
            return icon;
        }

        protected String getColor() {
            return INTERFACE_COLOR;
        }
    }

    private static class KeywordItem
    extends JavaCompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/java/editor/resources/javakw_16.png";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static ImageIcon icon;
        private String kwd;
        private int dim;
        private String postfix;
        private boolean smartType;
        private String leftText;

        private KeywordItem(String string, int n, String string2, int n2, boolean bl) {
            super(n2);
            this.kwd = string;
            this.dim = n;
            this.postfix = string2;
            this.smartType = bl;
        }

        public int getSortPriority() {
            return this.smartType ? 600 - SMART_TYPE : 600;
        }

        public CharSequence getSortText() {
            return this.kwd;
        }

        public CharSequence getInsertPrefix() {
            return this.kwd;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)JAVA_KEYWORD));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(KEYWORD_COLOR);
                stringBuilder.append(JavaCompletionItem.BOLD);
                stringBuilder.append(this.kwd);
                for (int i = 0; i < this.dim; ++i) {
                    stringBuilder.append("[]");
                }
                stringBuilder.append(JavaCompletionItem.BOLD_END);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            CodeTemplateManager codeTemplateManager;
            int n3;
            TokenSequence<JavaTokenId> tokenSequence;
            if (this.dim == 0) {
                super.substituteText(jTextComponent, n, n2, string != null ? string : this.postfix);
                return;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null && !string.equals("\n")) {
                tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    stringBuilder.append(string);
                    string = null;
                }
                n3 = 0;
                while (string != null && string.length() > 0) {
                    String string2 = ((Object)tokenSequence.token().text()).toString();
                    if (string2.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string2)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string2.length()));
                        string = string.substring(string2.length());
                        n3 = 1;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (n3 == 0) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            tokenSequence = new TokenSequence<JavaTokenId>();
            n3 = 1;
            tokenSequence.append(this.kwd);
            for (int i = 0; i < this.dim; ++i) {
                tokenSequence.append("[${PAR");
                tokenSequence.append(n3++);
                tokenSequence.append(" instanceof=\"int\" default=\"\"}]");
            }
            if (n2 > 0) {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, n2);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            if ((codeTemplateManager = CodeTemplateManager.get((Document)baseDocument)) != null) {
                codeTemplateManager.createTemporary(tokenSequence.append((CharSequence)stringBuilder).toString()).insert(jTextComponent);
            }
        }

        public String toString() {
            return this.kwd;
        }
    }

    private static class MethodItem
    extends JavaCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        protected ElementHandle<ExecutableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean inImport;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String typeName;
        private boolean isPrimitive;
        private String sortText;
        private String leftText;
        private String rightText;

        private MethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(n);
            TypeMirror typeMirror;
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isInherited = bl;
            this.isDeprecated = bl2;
            this.inImport = bl3;
            this.smartType = bl4;
            this.simpleName = executableElement.getSimpleName().toString();
            this.modifiers = executableElement.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                typeMirror = iterator2.next();
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)Utilities.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            typeMirror = executableType.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
            this.isPrimitive = typeMirror.getKind().isPrimitive() || typeMirror.getKind() == TypeKind.VOID;
        }

        public int getSortPriority() {
            return this.smartType ? 500 - SMART_TYPE : 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(METHOD_COLOR);
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon imageIcon = icon[bl ? 1 : 0][n];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = METHOD_PUBLIC;
            if (bl) {
                switch (n) {
                    case 0: {
                        string = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon2 = new ImageIcon(org.openide.util.Utilities.loadImage((String)string));
            MethodItem.icon[bl ? 1 : 0][n] = imageIcon2;
            return imageIcon2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(final JTextComponent jTextComponent, int n, int n2, String string) {
            JavaSource javaSource;
            Object object;
            if (string == null && this.isPrimitive) {
                try {
                    object = new String[1];
                    javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
                    javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>((String[])object){
                        final /* synthetic */ String[] val$ret;
                        {
                            this.val$ret = stringArray;
                        }

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.PARSED);
                            TreePath treePath = compilationController.getTreeUtilities().pathFor(jTextComponent.getSelectionEnd());
                            Tree tree = treePath.getLeaf();
                            if (tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                                treePath = treePath.getParentPath();
                            }
                            if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && ((MethodInvocationTree)treePath.getLeaf()).getMethodSelect() == tree) {
                                treePath = treePath.getParentPath();
                            }
                            if (treePath.getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT || treePath.getLeaf().getKind() == Tree.Kind.BLOCK) {
                                this.val$ret[0] = ";";
                            }
                        }
                    }, true);
                    string = object[0];
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object2 = object = this.inImport ? ";" : "()";
            if (string != null && !((String)object).startsWith(string)) {
                object = (String)object + string;
            }
            if (this.inImport || this.params.isEmpty()) {
                super.substituteText(jTextComponent, n, n2, (String)object);
            } else {
                Object object3;
                javaSource = (BaseDocument)jTextComponent.getDocument();
                String string2 = "";
                TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    string2 = string2 + (String)object;
                    object = null;
                }
                boolean bl = false;
                while (object != null && ((String)object).length() > 0) {
                    object3 = ((Object)tokenSequence.token().text()).toString();
                    if (((String)object3).startsWith((String)object)) {
                        n2 = tokenSequence.offset() - n + ((String)object).length();
                        string2 = string2 + (String)object;
                        object = null;
                        continue;
                    }
                    if (((String)object).startsWith((String)object3)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        string2 = string2 + ((String)object).substring(0, ((String)object3).length());
                        object = ((String)object).substring(((String)object3).length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        string2 = string2 + (String)object;
                        object = null;
                        continue;
                    }
                    if (!bl) {
                        string2 = string2 + (String)object;
                    }
                    object = null;
                }
                if (n2 > 0) {
                    javaSource.atomicLock();
                    try {
                        javaSource.remove(n, n2);
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        javaSource.atomicUnlock();
                    }
                }
                if ((object3 = CodeTemplateManager.get((Document)javaSource)) != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.getInsertPrefix());
                    stringBuilder.append("(");
                    if (string2.length() > 1) {
                        Iterator<ParamDesc> iterator = this.params.iterator();
                        while (iterator.hasNext()) {
                            ParamDesc paramDesc = iterator.next();
                            stringBuilder.append("${");
                            stringBuilder.append(paramDesc.name);
                            stringBuilder.append(" named instanceof=");
                            stringBuilder.append(paramDesc.fullTypeName);
                            stringBuilder.append("}");
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(")");
                        if (string2.length() > 2) {
                            stringBuilder.append(string2.substring(2));
                        }
                    }
                    object3.createTemporary(stringBuilder.toString()).insert(jTextComponent);
                    Completion.get().showToolTip();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<Object> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (ParamDesc)iterator.next();
                stringBuilder.append(((ParamDesc)object).typeName);
                stringBuilder.append(' ');
                stringBuilder.append(((ParamDesc)object).name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class OverrideMethodItem
    extends MethodItem {
        private static final String IMPL_BADGE_PATH = "org/netbeans/modules/java/editor/resources/implement_badge.png";
        private static final String OVRD_BADGE_PATH = "org/netbeans/modules/java/editor/resources/override_badge.png";
        private static ImageIcon implementBadge = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/editor/resources/implement_badge.png"));
        private static ImageIcon overrideBadge = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/editor/resources/override_badge.png"));
        private static ImageIcon[][] merged_icon = new ImageIcon[2][4];
        private boolean implement;
        private String leftText;

        private OverrideMethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
            super(executableElement, executableType, n, false, false, false, false);
            this.implement = bl;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = super.getLeftHtmlText() + (this.implement ? " - implement" : " - override");
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            int n;
            ImageIcon imageIcon = merged_icon[this.implement ? 0 : 1][n = JavaCompletionItem.getProtectionLevel(this.modifiers)];
            if (imageIcon != null) {
                return imageIcon;
            }
            ImageIcon imageIcon2 = super.getIcon();
            imageIcon = new ImageIcon(org.openide.util.Utilities.mergeImages((Image)imageIcon2.getImage(), (Image)(this.implement ? implementBadge.getImage() : overrideBadge.getImage()), (int)8, (int)8));
            OverrideMethodItem.merged_icon[this.implement ? 0 : 1][n] = imageIcon;
            return imageIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (n2 > 0) {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, n2);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            try {
                JavaSource javaSource = JavaSource.forDocument((Document)baseDocument);
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ExecutableElement executableElement = (ExecutableElement)OverrideMethodItem.this.elementHandle.resolve((CompilationInfo)workingCopy);
                        if (executableElement == null) {
                            return;
                        }
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            if (Utilities.isInMethod(treePath)) {
                                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int n2 = 0;
                            for (Tree tree : ((ClassTree)treePath.getLeaf()).getMembers()) {
                                if (workingCopy.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), tree) >= (long)n) break;
                                ++n2;
                            }
                            if (OverrideMethodItem.this.implement) {
                                GeneratorUtils.generateAbstractMethodImplementation(workingCopy, treePath, executableElement, n2);
                            } else {
                                GeneratorUtils.generateMethodOverride(workingCopy, treePath, executableElement, n2);
                            }
                        }
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append(" - ");
            stringBuilder.append(this.implement ? "implement" : "override");
            return stringBuilder.toString();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    private static class PackageItem
    extends JavaCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean isDeprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        private PackageItem(String string, int n, boolean bl) {
            super(n);
            this.isDeprecated = bl;
            int n2 = string.lastIndexOf(46);
            this.simpleName = n2 < 0 ? string : string.substring(n2 + 1);
            this.sortText = this.simpleName + "#" + string;
        }

        public int getSortPriority() {
            return 900;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)PACKAGE));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PACKAGE_COLOR);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class ParamDesc {
        private String fullTypeName;
        private String typeName;
        private String name;

        public ParamDesc(String string, String string2, String string3) {
            this.fullTypeName = string;
            this.typeName = string2;
            this.name = string3;
        }
    }

    private static class StaticMemberItem
    extends JavaCompletionItem {
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_COLOR = "<font color=#0000b2>";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#7c0000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon[][] icon = new ImageIcon[2][3];
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private ElementHandle<Element> memberElementHandle;
        private boolean isDeprecated;
        private String typeName;
        private String memberName;
        private String memberTypeName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;
        private String rightText;

        private StaticMemberItem(DeclaredType declaredType, Element element, TypeMirror typeMirror, int n, boolean bl) {
            super(n);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)declaredType);
            this.memberElementHandle = ElementHandle.create((Element)element);
            this.isDeprecated = bl;
            this.typeName = ((Object)Utilities.getTypeName(declaredType, false)).toString();
            this.memberName = element.getSimpleName().toString();
            this.memberTypeName = ((Object)Utilities.getTypeName(element.getKind().isField() ? typeMirror : ((ExecutableType)typeMirror).getReturnType(), false)).toString();
            this.modifiers = element.getModifiers();
            if (!element.getKind().isField()) {
                this.params = new ArrayList<ParamDesc>();
                Iterator<? extends VariableElement> iterator = ((ExecutableElement)element).getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = ((ExecutableType)typeMirror).getParameterTypes().iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    TypeMirror typeMirror2 = iterator2.next();
                    this.params.add(new ParamDesc(((Object)typeMirror2).toString(), ((Object)Utilities.getTypeName(typeMirror2, false, ((ExecutableElement)element).isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
                }
            }
        }

        public int getSortPriority() {
            return (this.params == null ? 700 : 750) - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                if (this.params == null) {
                    this.sortText = this.memberName + "#" + this.typeName;
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('(');
                    int n = 0;
                    Iterator<ParamDesc> iterator = this.params.iterator();
                    while (iterator.hasNext()) {
                        ParamDesc paramDesc = iterator.next();
                        stringBuilder.append(paramDesc.typeName);
                        if (iterator.hasNext()) {
                            stringBuilder.append(',');
                        }
                        ++n;
                    }
                    stringBuilder.append(')');
                    this.sortText = this.memberName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString() + "#" + this.typeName;
                }
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.typeName + "." + this.memberName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.memberElementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.memberElementHandle.getKind().isField() ? FIELD_COLOR : METHOD_COLOR);
                stringBuilder.append(JavaCompletionItem.escape(this.typeName));
                stringBuilder.append('.');
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.memberName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                if (this.params != null) {
                    stringBuilder.append('(');
                    Iterator<ParamDesc> iterator = this.params.iterator();
                    while (iterator.hasNext()) {
                        ParamDesc paramDesc = iterator.next();
                        stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                        stringBuilder.append(' ');
                        stringBuilder.append(PARAMETER_NAME_COLOR);
                        stringBuilder.append(paramDesc.name);
                        stringBuilder.append(JavaCompletionItem.COLOR_END);
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(')');
                }
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.memberTypeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.memberElementHandle.getKind().isField();
            ImageIcon imageIcon = icon[bl ? 0 : 1][n - 1];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = null;
            if (bl) {
                switch (n) {
                    case 1: {
                        string = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        string = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_ST_PUBLIC;
                    }
                }
            }
            if (string == null) {
                return null;
            }
            ImageIcon imageIcon2 = new ImageIcon(org.openide.util.Utilities.loadImage((String)string));
            StaticMemberItem.icon[bl ? 0 : 1][n - 1] = imageIcon2;
            return imageIcon2;
        }

        protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String string) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            if (string != null && !string.equals("\n")) {
                TokenSequence<JavaTokenId> tokenSequence = Utilities.getJavaTokenSequence(jTextComponent, n + n2);
                if (tokenSequence == null) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string2 = ((Object)tokenSequence.token().text()).toString();
                    if (string2.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string2)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string2.length()));
                        string = string.substring(string2.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n3 = n2;
            JavaSource javaSource = JavaSource.forDocument((Document)baseDocument);
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws IOException {
                        Object object;
                        Object object2;
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        DeclaredType declaredType = (DeclaredType)StaticMemberItem.this.typeHandle.resolve((CompilationInfo)compilationController);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        int n2 = 1;
                        stringBuilder2.append("${PAR#");
                        stringBuilder2.append(n2++);
                        stringBuilder2.append(" type=\"");
                        stringBuilder2.append(((TypeElement)declaredType.asElement()).getQualifiedName());
                        stringBuilder2.append("\" editable=false}");
                        Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            stringBuilder2.append('<');
                            while (iterator.hasNext()) {
                                object2 = iterator.next();
                                stringBuilder2.append("${PAR#");
                                stringBuilder2.append(n2++);
                                if (object2.getKind() == TypeKind.TYPEVAR) {
                                    stringBuilder2.append(" type=\"");
                                    object2 = ((TypeVariable)object2).getUpperBound();
                                    stringBuilder2.append(Utilities.getTypeName((TypeMirror)object2, true));
                                    stringBuilder2.append("\"}");
                                } else if (object2.getKind() == TypeKind.WILDCARD) {
                                    stringBuilder2.append(" type=\"");
                                    object = ((WildcardType)object2).getExtendsBound();
                                    if (object == null) {
                                        object = ((WildcardType)object2).getSuperBound();
                                    }
                                    stringBuilder2.append(object != null ? Utilities.getTypeName((TypeMirror)object, true) : "java.lang.Object");
                                    stringBuilder2.append("\"}");
                                } else if (object2.getKind() == TypeKind.ERROR) {
                                    stringBuilder2.append(" default=\"\"}");
                                } else {
                                    stringBuilder2.append(" type=\"");
                                    stringBuilder2.append(Utilities.getTypeName((TypeMirror)object2, true));
                                    stringBuilder2.append("\" editable=false}");
                                }
                                if (!iterator.hasNext()) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append('>');
                        }
                        stringBuilder2.append('.');
                        stringBuilder2.append(StaticMemberItem.this.memberName);
                        if (StaticMemberItem.this.params != null) {
                            stringBuilder2.append("(");
                            object2 = StaticMemberItem.this.params.iterator();
                            while (object2.hasNext()) {
                                object = (ParamDesc)object2.next();
                                stringBuilder2.append("${");
                                stringBuilder2.append(((ParamDesc)object).name);
                                stringBuilder2.append(" named instanceof=");
                                stringBuilder2.append(((ParamDesc)object).fullTypeName);
                                stringBuilder2.append("}");
                                if (!object2.hasNext()) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append(")");
                        }
                        stringBuilder2.append((CharSequence)stringBuilder);
                        if (n3 > 0) {
                            baseDocument.atomicLock();
                            try {
                                baseDocument.remove(n, n3);
                            }
                            catch (BadLocationException badLocationException) {
                            }
                            finally {
                                baseDocument.atomicUnlock();
                            }
                        }
                        if ((object2 = CodeTemplateManager.get((Document)baseDocument)) != null) {
                            object2.createTemporary(stringBuilder2.toString()).insert(jTextComponent);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.memberTypeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.typeName);
            stringBuilder.append('.');
            stringBuilder.append(this.memberName);
            if (this.params != null) {
                stringBuilder.append('(');
                Iterator<Object> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    object = (ParamDesc)iterator.next();
                    stringBuilder.append(((ParamDesc)object).typeName);
                    stringBuilder.append(' ');
                    stringBuilder.append(((ParamDesc)object).name);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
    }

    private static class TypeParameterItem
    extends JavaCompletionItem {
        private static final String TYPE_PARAMETER_COLOR = "<font color=#000000>";
        private String simpleName;
        private String leftText;

        private TypeParameterItem(TypeParameterElement typeParameterElement, int n) {
            super(n);
            this.simpleName = typeParameterElement.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 700;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = TYPE_PARAMETER_COLOR + this.simpleName + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class VariableItem
    extends JavaCompletionItem {
        private static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
        private static final String PARAMETER_COLOR = "<font color=#00007c>";
        private static ImageIcon icon;
        private String varName;
        private boolean smartType;
        private String typeName;
        private String leftText;
        private String rightText;

        private VariableItem(TypeMirror typeMirror, String string, int n, boolean bl) {
            super(n);
            this.varName = string;
            this.smartType = bl;
            this.typeName = typeMirror != null ? ((Object)Utilities.getTypeName(typeMirror, false)).toString() : null;
        }

        public int getSortPriority() {
            return this.smartType ? 200 - SMART_TYPE : 200;
        }

        public CharSequence getSortText() {
            return this.varName;
        }

        public CharSequence getInsertPrefix() {
            return this.varName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = "<font color=#00007c><b>" + this.varName + JavaCompletionItem.BOLD_END + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)LOCAL_VARIABLE));
            }
            return icon;
        }

        public String toString() {
            return (this.typeName != null ? this.typeName + " " : "") + this.varName;
        }
    }
}

