/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorGenerator
implements CodeGenerator {
    private ElementHandle<? extends Element> constructorHandle;
    private ElementNode.Description constructorDescription;
    private ElementNode.Description fieldsDescription;

    private ConstructorGenerator(ElementHandle<? extends Element> elementHandle, ElementNode.Description description, ElementNode.Description description2) {
        this.constructorHandle = elementHandle;
        this.constructorDescription = description;
        this.fieldsDescription = description2;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_constructor");
    }

    @Override
    public void invoke(JTextComponent jTextComponent) {
        List<ElementHandle<? extends Element>> list;
        ConstructorPanel constructorPanel;
        if (this.constructorDescription != null || this.fieldsDescription != null) {
            constructorPanel = new ConstructorPanel(this.constructorDescription, this.fieldsDescription);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)constructorPanel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_constructor"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            if (this.constructorHandle == null) {
                this.constructorHandle = constructorPanel.getInheritedConstructor();
            }
            list = constructorPanel.getVariablesToInitialize();
        } else {
            list = null;
        }
        constructorPanel = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (constructorPanel != null) {
            try {
                final int n = jTextComponent.getCaretPosition();
                constructorPanel.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = 0;
                        SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
                        for (Tree object : ((ClassTree)treePath.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(treePath.getCompilationUnit(), object) >= (long)n) break;
                            ++n2;
                        }
                        ArrayList arrayList = new ArrayList();
                        if (list != null) {
                            for (ElementHandle elementHandle : list) {
                                arrayList.add((VariableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                            }
                        }
                        GeneratorUtils.generateConstructor(workingCopy, treePath, arrayList, ConstructorGenerator.this.constructorHandle != null ? (ExecutableElement)ConstructorGenerator.this.constructorHandle.resolve((CompilationInfo)workingCopy) : null, n2);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController compilationController, TreePath treePath) throws IOException {
            void var10_13;
            Object object;
            if ((treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath)) == null) {
                return Collections.emptySet();
            }
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (!typeElement.getKind().isClass()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VariableElement> linkedHashSet = new LinkedHashSet<VariableElement>();
            LinkedHashSet<VariableElement> linkedHashSet2 = new LinkedHashSet<VariableElement>();
            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
            ArrayList<ExecutableElement> arrayList2 = new ArrayList<ExecutableElement>();
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement();
            for (ExecutableElement object22 : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
                arrayList2.add(object22);
            }
            GeneratorUtils.scanForFieldsAndConstructors((CompilationInfo)compilationController, treePath, linkedHashSet, linkedHashSet2, arrayList);
            ElementHandle elementHandle = null;
            Object var10_11 = null;
            if (typeElement.getKind() != ElementKind.ENUM && arrayList2.size() == 1) {
                elementHandle = ElementHandle.create((Element)((Element)arrayList2.get(0)));
            } else if (arrayList2.size() > 1) {
                object = new ArrayList<ElementNode.Description>();
                for (ExecutableElement executableElement : arrayList2) {
                    object.add((ElementNode.Description)ElementNode.Description.create(executableElement, null, true, false));
                }
                ElementNode.Description description = ElementNode.Description.create(typeElement2, object, false, false);
            }
            object = null;
            if (!linkedHashSet2.isEmpty()) {
                ArrayList arrayList3 = new ArrayList();
                for (VariableElement variableElement : linkedHashSet2) {
                    arrayList3.add(ElementNode.Description.create(variableElement, null, true, false));
                }
                object = ElementNode.Description.create(typeElement, arrayList3, false, false);
            }
            if (elementHandle == null && var10_13 == null && object == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(new ConstructorGenerator(elementHandle, (ElementNode.Description)var10_13, (ElementNode.Description)object));
        }
    }
}

