/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.EqualsHashCodePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHashCodeGenerator
implements CodeGenerator {
    ElementNode.Description description;

    private EqualsHashCodeGenerator(ElementNode.Description description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EqualsHashCodeGenerator.class, (String)"LBL_equals_and_hashcode");
    }

    @Override
    public void invoke(JTextComponent jTextComponent) {
        JavaSource javaSource;
        final EqualsHashCodePanel equalsHashCodePanel = new EqualsHashCodePanel(this.description);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)equalsHashCodePanel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_equals_and_hashcode"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument())) != null) {
            try {
                final int n = jTextComponent.getCaretPosition();
                javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = 0;
                        SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
                        for (Tree arrayList2 : ((ClassTree)treePath.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(treePath.getCompilationUnit(), arrayList2) >= (long)n) break;
                            ++n2;
                        }
                        ArrayList arrayList3 = new ArrayList();
                        for (ElementHandle<? extends Element> elementHandle : equalsHashCodePanel.getEqualsVariables()) {
                            arrayList3.add((VariableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                        }
                        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                        for (ElementHandle<? extends Element> elementHandle : equalsHashCodePanel.getHashCodeVariables()) {
                            arrayList.add((VariableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                        }
                        EqualsHashCodeGenerator.generateEqualsAndHashCode(workingCopy, treePath, arrayList3, arrayList, n2);
                    }
                }).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static void generateEqualsAndHashCode(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, Iterable<? extends VariableElement> iterable2, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            classTree = treeMaker.insertClassMember(classTree, n, (Tree)EqualsHashCodeGenerator.createHashCodeMethod(workingCopy, iterable2, (DeclaredType)typeElement.asType()));
            classTree = treeMaker.insertClassMember(classTree, n, (Tree)EqualsHashCodeGenerator.createEqualsMethod(workingCopy, iterable, (DeclaredType)typeElement.asType()));
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    private static MethodTree createEqualsMethod(WorkingCopy workingCopy, Iterable<? extends VariableElement> iterable, DeclaredType declaredType) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        List<VariableTree> list = Collections.singletonList(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"obj", treeMaker.Type(workingCopy.getElements().getTypeElement("java.lang.Object").asType()), null));
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
        arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)treeMaker.Identifier((CharSequence)"obj"), (ExpressionTree)treeMaker.Identifier((CharSequence)"null")), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"getClass"), Collections.emptyList()), (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"obj"), (CharSequence)"getClass"), Collections.emptyList())), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"other", treeMaker.Type((TypeMirror)declaredType), (ExpressionTree)treeMaker.TypeCast(treeMaker.Type((TypeMirror)declaredType), (ExpressionTree)treeMaker.Identifier((CharSequence)"obj"))));
        for (VariableElement variableElement : iterable) {
            if (variableElement.asType().getKind().isPrimitive()) {
                arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName())), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
                continue;
            }
            BinaryTree binaryTree = treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName()));
            BinaryTree binaryTree2 = treeMaker.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Identifier((CharSequence)"null"));
            UnaryTree unaryTree = treeMaker.Unary(Tree.Kind.LOGICAL_COMPLEMENT, (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (CharSequence)"equals"), Collections.singletonList(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName()))));
            arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)binaryTree, (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.CONDITIONAL_OR, (ExpressionTree)binaryTree2, (ExpressionTree)unaryTree))), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        }
        arrayList.add(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"true")));
        BlockTree blockTree = treeMaker.Block(arrayList, false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)"equals", (Tree)treeMaker.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), list, Collections.emptyList(), blockTree, null);
    }

    private static MethodTree createHashCodeMethod(WorkingCopy workingCopy, Iterable<? extends VariableElement> iterable, DeclaredType declaredType) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        int n = EqualsHashCodeGenerator.generatePrimeNumber(2, 10);
        int n2 = EqualsHashCodeGenerator.generatePrimeNumber(10, 100);
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
        arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"hash", (Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Literal((Object)n)));
        for (VariableElement variableElement : iterable) {
            ExpressionTree expressionTree;
            switch (variableElement.asType().getKind()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: {
                    expressionTree = treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName());
                    break;
                }
                case LONG: {
                    expressionTree = treeMaker.TypeCast((Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.XOR, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Literal((Object)32))))));
                    break;
                }
                case FLOAT: {
                    expressionTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"Float"), (CharSequence)"floatToIntBits"), Collections.singletonList(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName())));
                    break;
                }
                case DOUBLE: {
                    MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"Double"), (CharSequence)"doubleToLongBits"), Collections.singletonList(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName())));
                    expressionTree = treeMaker.TypeCast((Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.XOR, (ExpressionTree)methodInvocationTree, (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)methodInvocationTree, (ExpressionTree)treeMaker.Literal((Object)32))))));
                    break;
                }
                case BOOLEAN: {
                    expressionTree = treeMaker.ConditionalExpression((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Literal((Object)1), (ExpressionTree)treeMaker.Literal((Object)0));
                    break;
                }
                default: {
                    expressionTree = treeMaker.ConditionalExpression((ExpressionTree)treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Identifier((CharSequence)"null")), (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (CharSequence)"hashCode"), Collections.emptyList()), (ExpressionTree)treeMaker.Literal((Object)0));
                }
            }
            arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"hash"), (ExpressionTree)treeMaker.Binary(Tree.Kind.PLUS, (ExpressionTree)treeMaker.Binary(Tree.Kind.MULTIPLY, (ExpressionTree)treeMaker.Literal((Object)n2), (ExpressionTree)treeMaker.Identifier((CharSequence)"hash")), expressionTree))));
        }
        arrayList.add(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"hash")));
        BlockTree blockTree = treeMaker.Block(arrayList, false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)"hashCode", (Tree)treeMaker.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    private static boolean isPrimeNumber(int n) {
        int n2 = (int)Math.sqrt(n) + 1;
        if (n % 2 == 0) {
            return false;
        }
        for (int i = 3; i < n2; ++i) {
            if (n % i != 0) continue;
            return false;
        }
        return true;
    }

    private static int generatePrimeNumber(int n, int n2) {
        Random random = new Random(System.currentTimeMillis());
        int n3 = random.nextInt(n2 - n) + n;
        while (!EqualsHashCodeGenerator.isPrimeNumber(n3)) {
            ++n3;
        }
        if (n3 > n2) {
            --n3;
            while (!EqualsHashCodeGenerator.isPrimeNumber(n3)) {
                --n3;
            }
        }
        return n3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController compilationController, TreePath treePath) throws IOException {
            if ((treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath)) == null) {
                return Collections.emptySet();
            }
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (typeElement.getKind() != ElementKind.CLASS) {
                return Collections.emptySet();
            }
            ArrayList<ElementNode.Description> arrayList = new ArrayList<ElementNode.Description>();
            for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                arrayList.add(ElementNode.Description.create(variableElement, null, true, false));
            }
            if (arrayList.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new EqualsHashCodeGenerator(ElementNode.Description.create(typeElement, arrayList, false, false)));
        }
    }
}

