/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;
    private static final Set<String> SUPPORTS_OVERRIDE_SOURCE_LEVELS = new HashSet<String>();
    private static final Set<Modifier> NOT_OVERRIDABLE;

    private GeneratorUtils() {
    }

    public static ClassTree insertClassMember(WorkingCopy workingCopy, ClassTree classTree, Tree tree) {
        int n = 0;
        for (Tree tree2 : classTree.getMembers()) {
            if (ClassMemberComparator.compare(tree, tree2) < 0) break;
            ++n;
        }
        return workingCopy.getTreeMaker().insertClassMember(classTree, n, tree);
    }

    public static List<? extends ExecutableElement> findUndefs(CompilationInfo compilationInfo, TypeElement typeElement) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "findUndefs(" + compilationInfo + ", " + typeElement + ")");
        }
        List<? extends ExecutableElement> list = GeneratorUtils.findUndefs(compilationInfo, typeElement, typeElement);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "undef=" + list);
        }
        return list;
    }

    public static List<? extends ExecutableElement> findOverridable(CompilationInfo compilationInfo, TypeElement typeElement) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        List<TypeElement> list = GeneratorUtils.getAllClasses(typeElement);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "classes=" + list);
        }
        for (TypeElement typeElement2 : list.subList(1, list.size())) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                EnumSet<Modifier> enumSet = EnumSet.copyOf(NOT_OVERRIDABLE);
                enumSet.removeAll(executableElement.getModifiers());
                if (enumSet.size() != NOT_OVERRIDABLE.size()) continue;
                int n = list.indexOf(typeElement2);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "ee=" + executableElement);
                    ERR.log(1, "thisElement = " + n);
                    ERR.log(1, "classes.subList(0, thisElement + 1)=" + list.subList(0, n + 1));
                    ERR.log(1, "isOverriden(info, ee, classes.subList(0, thisElement + 1))=" + GeneratorUtils.isOverriden(compilationInfo, executableElement, list.subList(0, n + 1)));
                }
                if (GeneratorUtils.isOverriden(compilationInfo, executableElement, list.subList(0, n + 1))) continue;
                arrayList.add(executableElement);
            }
        }
        return arrayList;
    }

    public static Map<? extends TypeElement, ? extends List<? extends VariableElement>> findAllAccessibleFields(CompilationInfo compilationInfo, TypeElement typeElement) {
        HashMap<TypeElement, List<? extends VariableElement>> hashMap = new HashMap<TypeElement, List<? extends VariableElement>>();
        hashMap.put(typeElement, GeneratorUtils.findAllAccessibleFields(compilationInfo, typeElement, typeElement));
        for (TypeElement typeElement2 : GeneratorUtils.getAllParents(typeElement)) {
            hashMap.put(typeElement2, GeneratorUtils.findAllAccessibleFields(compilationInfo, typeElement, typeElement2));
        }
        return hashMap;
    }

    public static void scanForFieldsAndConstructors(CompilationInfo compilationInfo, TreePath treePath, final Set<VariableElement> set, final Set<VariableElement> set2, final List<ExecutableElement> list) {
        final Trees trees = compilationInfo.getTrees();
        new TreePathScanner<Void, Boolean>(){

            @Override
            public Void visitVariable(VariableTree variableTree, Boolean bl) {
                Element element = trees.getElement(this.getCurrentPath());
                if (element != null && element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && variableTree.getInitializer() == null && !set.remove(element)) {
                    set2.add((VariableElement)element);
                }
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, Boolean bl) {
                Element element = trees.getElement(new TreePath(this.getCurrentPath(), assignmentTree.getVariable()));
                if (element != null && element.getKind() == ElementKind.FIELD && !set2.remove(element)) {
                    set.add((VariableElement)element);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree classTree, Boolean bl) {
                return bl != false ? (Void)super.visitClass(classTree, false) : null;
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Boolean bl) {
                Element element = trees.getElement(this.getCurrentPath());
                if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
                    list.add((ExecutableElement)element);
                }
                return null;
            }
        }.scan(treePath, Boolean.TRUE);
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy workingCopy, TreePath treePath) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs((CompilationInfo)workingCopy, typeElement, typeElement)) {
                arrayList.add(GeneratorUtils.createMethodImplementation(workingCopy, executableElement, (DeclaredType)typeElement.asType()));
            }
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy workingCopy, TreePath treePath, List<? extends ExecutableElement> list, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            ArrayList<MethodTree> arrayList2 = new ArrayList<MethodTree>();
            for (ExecutableElement executableElement : list) {
                arrayList2.add(GeneratorUtils.createMethodImplementation(workingCopy, executableElement, (DeclaredType)typeElement.asType()));
            }
            arrayList.addAll(n, arrayList2);
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy workingCopy, TreePath treePath, ExecutableElement executableElement, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            ClassTree classTree = workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n, (Tree)GeneratorUtils.createMethodImplementation(workingCopy, executableElement, (DeclaredType)typeElement.asType()));
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    public static void generateMethodOverrides(WorkingCopy workingCopy, TreePath treePath, List<? extends ExecutableElement> list, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            ArrayList<MethodTree> arrayList2 = new ArrayList<MethodTree>();
            for (ExecutableElement executableElement : list) {
                arrayList2.add(GeneratorUtils.createMethodImplementation(workingCopy, executableElement, (DeclaredType)typeElement.asType()));
            }
            arrayList.addAll(n, arrayList2);
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateMethodOverride(WorkingCopy workingCopy, TreePath treePath, ExecutableElement executableElement, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            ClassTree classTree = workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n, (Tree)GeneratorUtils.createMethodImplementation(workingCopy, executableElement, (DeclaredType)typeElement.asType()));
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    public static void generateConstructor(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, ExecutableElement executableElement, int n) {
        Object object2;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> arrayList2 = new ArrayList<ExpressionStatementTree>();
        ModifiersTree modifiersTree = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        if (executableElement != null && !executableElement.getParameters().isEmpty()) {
            object2 = new ArrayList();
            for (VariableElement variableElement : executableElement.getParameters()) {
                arrayList.add(treeMaker.Variable(modifiersTree, (CharSequence)variableElement.getSimpleName(), treeMaker.Type(variableElement.asType()), null));
                object2.add(treeMaker.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            arrayList2.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"super"), (List)object2)));
        }
        for (VariableElement variableElement : iterable) {
            arrayList.add(treeMaker.Variable(modifiersTree, (CharSequence)variableElement.getSimpleName(), treeMaker.Type(variableElement.asType()), null));
            arrayList2.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Identifier((CharSequence)variableElement.getSimpleName()))));
        }
        object2 = treeMaker.Block(arrayList2, false);
        ClassTree classTree2 = treeMaker.insertClassMember(classTree, n, (Tree)treeMaker.Method(treeMaker.Modifiers(EnumSet.of(workingCopy.getTreeUtilities().isEnum(classTree) ? Modifier.PRIVATE : Modifier.PUBLIC)), (CharSequence)"<init>", null, Collections.emptyList(), arrayList, Collections.emptyList(), (BlockTree)object2, null));
        workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree2);
    }

    public static void generateGettersAndSetters(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, int n, int n2) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            ArrayList<MethodTree> arrayList2 = new ArrayList<MethodTree>();
            for (VariableElement variableElement : iterable) {
                if (n != 2) {
                    arrayList2.add(GeneratorUtils.createGetterMethod(workingCopy, variableElement, (DeclaredType)typeElement.asType()));
                }
                if (n == 1) continue;
                arrayList2.add(GeneratorUtils.createSetterMethod(workingCopy, variableElement, (DeclaredType)typeElement.asType()));
            }
            arrayList.addAll(n2, arrayList2);
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static boolean hasGetter(CompilationInfo compilationInfo, VariableElement variableElement, Map<String, List<ExecutableElement>> map) {
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = variableElement.asType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(typeMirror.getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = compilationInfo.getTypes();
        List<ExecutableElement> list = map.get(stringBuilder.toString());
        if (list != null) {
            for (ExecutableElement executableElement : list) {
                if (!executableElement.getParameters().isEmpty() || !types.isSameType(executableElement.getReturnType(), typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSetter(CompilationInfo compilationInfo, VariableElement variableElement, Map<String, List<ExecutableElement>> map) {
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = variableElement.asType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = compilationInfo.getTypes();
        List<ExecutableElement> list = map.get(stringBuilder.toString());
        if (list != null) {
            for (ExecutableElement executableElement : list) {
                if (executableElement.getReturnType().getKind() != TypeKind.VOID || executableElement.getParameters().size() != 1 || !types.isSameType(executableElement.getParameters().get(0).asType(), typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    private static MethodTree createMethodImplementation(WorkingCopy workingCopy, ExecutableElement executableElement, DeclaredType declaredType) {
        Object object;
        Object object2;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        Set<Modifier> set = executableElement.getModifiers();
        EnumSet<Modifier> enumSet = set.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(set);
        boolean bl = enumSet.remove((Object)Modifier.ABSTRACT);
        enumSet.remove((Object)Modifier.NATIVE);
        ExecutableType executableType = (ExecutableType)workingCopy.getTypes().asMemberOf(declaredType, executableElement);
        ArrayList<TypeParameterTree> arrayList = new ArrayList<TypeParameterTree>();
        for (TypeParameterElement object52 : executableElement.getTypeParameters()) {
            ArrayList<ExpressionTree> bl2 = new ArrayList<ExpressionTree>();
            for (TypeMirror typeMirror : object52.getBounds()) {
                if (typeMirror.getKind() == TypeKind.NULL || typeMirror.getKind() == TypeKind.DECLARED && "java.lang.Object".contentEquals(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName())) continue;
                bl2.add((ExpressionTree)treeMaker.Type(typeMirror));
            }
            arrayList.add(treeMaker.TypeParameter((CharSequence)object52.getSimpleName(), bl2));
        }
        Tree tree = treeMaker.Type(executableType.getReturnType());
        ArrayList<VariableTree> arrayList2 = new ArrayList<VariableTree>();
        boolean bl2 = executableElement.isVarArgs();
        Iterator<AnnotatedConstruct> iterator = executableElement.getParameters().iterator();
        Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
        ModifiersTree modifiersTree = treeMaker.Modifiers(EnumSet.noneOf(Modifier.class));
        while (iterator.hasNext() && iterator2.hasNext()) {
            object2 = (VariableElement)iterator.next();
            object = iterator2.next();
            if (bl2 && !iterator.hasNext()) {
                modifiersTree = treeMaker.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList2.add(treeMaker.Variable(modifiersTree, (CharSequence)object2.getSimpleName(), treeMaker.Type((TypeMirror)object), null));
        }
        object2 = new ArrayList();
        for (TypeMirror typeMirror : executableType.getThrownTypes()) {
            object2.add((ExpressionTree)treeMaker.Type(typeMirror));
        }
        ArrayList<AnnotationTree> arrayList3 = new ArrayList<AnnotationTree>();
        if (bl) {
            ArrayList<ThrowTree> arrayList4 = new ArrayList<ThrowTree>();
            TypeElement typeElement = workingCopy.getElements().getTypeElement("java.lang.UnsupportedOperationException");
            if (typeElement != null) {
                NewClassTree newClassTree = treeMaker.NewClass(null, Collections.emptyList(), treeMaker.QualIdent((Element)typeElement), Collections.singletonList(treeMaker.Literal((Object)"Not supported yet.")), null);
                arrayList4.add(treeMaker.Throw((ExpressionTree)newClassTree));
            }
            object = treeMaker.Block(arrayList4, false);
        } else {
            ArrayList<IdentifierTree> arrayList5 = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : executableElement.getParameters()) {
                arrayList5.add(treeMaker.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"super"), (CharSequence)executableElement.getSimpleName()), arrayList5);
            StatementTree statementTree = workingCopy.getTypes().getNoType(TypeKind.VOID) == executableElement.getReturnType() ? treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree) : treeMaker.Return((ExpressionTree)methodInvocationTree);
            object = treeMaker.Block(Collections.singletonList(statementTree), false);
            if (GeneratorUtils.supportsOverride(workingCopy.getFileObject())) {
                arrayList3.add(treeMaker.Annotation((Tree)treeMaker.Identifier((CharSequence)"Override"), Collections.emptyList()));
            }
        }
        return treeMaker.Method(treeMaker.Modifiers(enumSet, arrayList3), (CharSequence)executableElement.getSimpleName(), tree, arrayList, arrayList2, (List)object2, (BlockTree)object, null);
    }

    private static MethodTree createGetterMethod(WorkingCopy workingCopy, VariableElement variableElement, DeclaredType declaredType) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(variableElement.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)variableElement.getSimpleName()))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, treeMaker.Type(variableElement.asType()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    private static MethodTree createSetterMethod(WorkingCopy workingCopy, VariableElement variableElement, DeclaredType declaredType) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        boolean bl = variableElement.getModifiers().contains((Object)Modifier.STATIC);
        if (bl) {
            enumSet.add(Modifier.STATIC);
        }
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        List<VariableTree> list = Collections.singletonList(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)variableElement.getSimpleName(), treeMaker.Type(variableElement.asType()), null));
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)(bl ? treeMaker.Identifier((CharSequence)variableElement.getEnclosingElement().getSimpleName()) : treeMaker.Identifier((CharSequence)"this")), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)treeMaker.Identifier((CharSequence)variableElement.getSimpleName())))), false);
        return treeMaker.Method(treeMaker.Modifiers(enumSet), (CharSequence)stringBuilder, treeMaker.Type((TypeMirror)workingCopy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), list, Collections.emptyList(), blockTree, null);
    }

    private static List<? extends ExecutableElement> findUndefs(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        if (typeElement2.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element annotatedConstruct2 : typeElement2.getEnclosedElements()) {
                Object object;
                Element element;
                if (annotatedConstruct2.getKind() != ElementKind.METHOD || !annotatedConstruct2.getModifiers().contains((Object)Modifier.ABSTRACT) || (element = elementUtilities.getImplementationOf((ExecutableElement)(object = (ExecutableElement)annotatedConstruct2), typeElement)) != null && element != object) continue;
                arrayList.add(object);
            }
        }
        Types types = compilationInfo.getTypes();
        DeclaredType declaredType = (DeclaredType)typeElement.asType();
        for (TypeMirror typeMirror : types.directSupertypes(typeElement2.asType())) {
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs(compilationInfo, typeElement, (TypeElement)((DeclaredType)typeMirror).asElement())) {
                boolean bl = false;
                TypeMirror typeMirror2 = types.asMemberOf(declaredType, executableElement);
                for (ExecutableElement executableElement2 : arrayList) {
                    TypeMirror typeMirror3;
                    if (!executableElement2.getSimpleName().contentEquals(executableElement.getSimpleName()) || !types.isSameType(typeMirror2, typeMirror3 = types.asMemberOf(declaredType, executableElement2))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(executableElement);
            }
        }
        return arrayList;
    }

    private static List<? extends VariableElement> findAllAccessibleFields(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2) {
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement2.getEnclosedElements())) {
            if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                arrayList.add(variableElement);
                continue;
            }
            if (variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (typeElement != typeElement2) continue;
                arrayList.add(variableElement);
                continue;
            }
            if (!variableElement.getModifiers().contains((Object)Modifier.PROTECTED) || !GeneratorUtils.getAllParents(typeElement).contains(typeElement2)) continue;
            arrayList.add(variableElement);
        }
        return arrayList;
    }

    public static Collection<TypeElement> getAllParents(TypeElement typeElement) {
        TypeElement typeElement2;
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror2).asElement();
            if (typeElement3 != null) {
                hashSet.add(typeElement3);
                hashSet.addAll(GeneratorUtils.getAllParents(typeElement3));
                continue;
            }
            if (!ERR.isLoggable(1)) continue;
            ERR.log(1, "te=null, t=" + typeMirror2);
        }
        TypeMirror typeMirror3 = typeElement.getSuperclass();
        TypeElement typeElement4 = typeElement2 = typeMirror3.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)typeMirror3).asElement() : null;
        if (typeElement2 != null) {
            hashSet.add(typeElement2);
            hashSet.addAll(GeneratorUtils.getAllParents(typeElement2));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + typeElement);
        }
        return hashSet;
    }

    public static boolean supportsOverride(FileObject fileObject) {
        return SUPPORTS_OVERRIDE_SOURCE_LEVELS.contains(SourceLevelQuery.getSourceLevel((FileObject)fileObject));
    }

    private static List<TypeElement> getAllClasses(TypeElement typeElement) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        TypeMirror typeMirror = typeElement.getSuperclass();
        TypeElement typeElement2 = typeMirror.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)typeMirror).asElement() : null;
        arrayList.add(typeElement);
        if (typeElement2 != null) {
            arrayList.addAll(GeneratorUtils.getAllClasses(typeElement2));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + typeElement);
        }
        return arrayList;
    }

    private static boolean isOverriden(CompilationInfo compilationInfo, ExecutableElement executableElement, List<TypeElement> list) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "isOverriden(" + compilationInfo + ", " + executableElement + ", " + list + ")");
        }
        for (TypeElement typeElement : list) {
            for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (ERR.isLoggable(1) && compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) {
                    ERR.log(1, "overrides:");
                    ERR.log(1, "impl=" + typeElement);
                    ERR.log(1, "methodImpl=" + executableElement2);
                }
                if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) continue;
                return true;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "no overriding methods overrides:");
        }
        return false;
    }

    public static boolean isAccessible(TypeElement typeElement, Element element) {
        TypeElement typeElement2;
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        TypeElement typeElement3 = SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement);
        if (typeElement3.equals(typeElement2 = SourceUtils.getOutermostEnclosingTypeElement((Element)element))) {
            return true;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PROTECTED) && GeneratorUtils.getAllClasses(typeElement3).contains(SourceUtils.getEnclosingTypeElement((Element)element))) {
            return true;
        }
        return ((PackageElement)typeElement3.getEnclosingElement()).getQualifiedName().toString().contentEquals(((PackageElement)typeElement2.getEnclosingElement()).getQualifiedName());
    }

    static {
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.5");
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.6");
        NOT_OVERRIDABLE = EnumSet.of(Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL);
    }

    private static class ClassMemberComparator {
        private ClassMemberComparator() {
        }

        public static int compare(Tree tree, Tree tree2) {
            if (tree == tree2) {
                return 0;
            }
            int n = ClassMemberComparator.getSortPriority(tree) - ClassMemberComparator.getSortPriority(tree2);
            if (n != 0) {
                return n;
            }
            int n2 = ClassMemberComparator.getSortText(tree).compareTo(ClassMemberComparator.getSortText(tree2));
            if (n2 != 0) {
                return n2;
            }
            return -1;
        }

        private static int getSortPriority(Tree tree) {
            int n = 0;
            ModifiersTree modifiersTree = null;
            switch (tree.getKind()) {
                case CLASS: {
                    n = 400;
                    modifiersTree = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    n = methodTree.getName().contentEquals("<init>") ? 200 : 300;
                    modifiersTree = methodTree.getModifiers();
                    break;
                }
                case VARIABLE: {
                    n = 100;
                    modifiersTree = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiersTree != null) {
                if (!modifiersTree.getFlags().contains((Object)Modifier.STATIC)) {
                    n += 1000;
                }
                n = modifiersTree.getFlags().contains((Object)Modifier.PUBLIC) ? (n += 10) : (modifiersTree.getFlags().contains((Object)Modifier.PROTECTED) ? (n += 20) : (modifiersTree.getFlags().contains((Object)Modifier.PRIVATE) ? (n += 40) : (n += 30)));
            }
            return n;
        }

        private static String getSortText(Tree tree) {
            switch (tree.getKind()) {
                case CLASS: {
                    return ((ClassTree)tree).getSimpleName().toString();
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('(');
                    int n = 0;
                    Iterator<? extends VariableTree> iterator = methodTree.getParameters().iterator();
                    while (iterator.hasNext()) {
                        VariableTree variableTree = iterator.next();
                        if (variableTree.getType().getKind() == Tree.Kind.IDENTIFIER) {
                            stringBuilder.append(((IdentifierTree)variableTree.getType()).getName().toString());
                        } else if (variableTree.getType().getKind() == Tree.Kind.MEMBER_SELECT) {
                            stringBuilder.append(((MemberSelectTree)variableTree.getType()).getIdentifier().toString());
                        }
                        if (iterator.hasNext()) {
                            stringBuilder.append(',');
                        }
                        ++n;
                    }
                    stringBuilder.append(')');
                    return methodTree.getName().toString() + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
                }
                case VARIABLE: {
                    return ((VariableTree)tree).getName().toString();
                }
            }
            return "";
        }
    }
}

