/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.ImportClassPanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class FastImportAction
extends BaseAction {
    public static final String NAME = "fast-import";

    public FastImportAction() {
        super(NAME);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            final Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
            final Font font = jTextComponent.getFont();
            final Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            final String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)jTextComponent.getCaretPosition());
            FileObject fileObject = this.getFile(jTextComponent.getDocument());
            if (string == null || fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    final JavaSource javaSource = compilationController.getJavaSource();
                    ComputeImports.Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> pair = new ComputeImports().computeCandidates((CompilationInfo)compilationController, Collections.singleton(string));
                    final List list = (List)((Map)pair.a).get(string);
                    if (list == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final ArrayList arrayList = new ArrayList((Collection)((Map)pair.b).get(string));
                    arrayList.removeAll(list);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ImportClassPanel importClassPanel = new ImportClassPanel(list, arrayList, font, javaSource);
                            PopupUtil.showPopup(importClassPanel, "", point.x, point.y, true, rectangle.height);
                        }
                    });
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private FileObject getFile(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

