/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.java.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.java.editor.semantic.MethodExitDetector;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;
    private MethodExitDetector exitDetector;
    private FindLocalUsagesQuery localUsages;

    MarkOccurencesHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(MarkOccurencesHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), iOException);
            return null;
        }
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.getLogger(MarkOccurencesHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long l = System.currentTimeMillis();
        int n = MarkOccurrencesHighlighterFactory.getLastPosition((FileObject)this.file);
        if (this.isCancelled()) {
            return;
        }
        Set<Highlight> set = this.processImpl(compilationInfo, document, n);
        if (this.isCancelled()) {
            return;
        }
        TimesCollector.getDefault().reportTime(((DataObject)document.getProperty("stream")).getPrimaryFile(), "occurrences", "Occurrences", System.currentTimeMillis() - l);
        Highlighter.getDefault().setHighlights(this.file, "occurrences", set);
        OccurrencesMarkProvider.get(document).setOccurrences(set);
    }

    private boolean isIn(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Tree tree, int n) {
        return sourcePositions.getStartPosition(compilationUnitTree, tree) <= (long)n && (long)n <= sourcePositions.getEndPosition(compilationUnitTree, tree);
    }

    private boolean isIn(int n, int[] nArray) {
        return nArray[0] <= n && n <= nArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Highlight> processImpl(CompilationInfo compilationInfo, Document document, int n) {
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        Tree tree = null;
        Set<Highlight> set = null;
        for (TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n); treePath != null; treePath = treePath.getParentPath()) {
            Object object;
            Object object2;
            if (this.isCancelled()) {
                return Collections.emptySet();
            }
            Tree tree2 = treePath.getLeaf();
            if (tree2 instanceof MethodTree && (tree instanceof IdentifierTree || tree instanceof PrimitiveTypeTree || tree instanceof MemberSelectTree)) {
                object2 = (MethodTree)tree2;
                object = object2.getReturnType();
                if (this.isIn(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), (Tree)object, n)) {
                    MethodExitDetector methodExitDetector = new MethodExitDetector();
                    this.setExitDetector(methodExitDetector);
                    try {
                        Set<Highlight> set2 = methodExitDetector.process(compilationInfo, document, (MethodTree)object2, null);
                        return set2;
                    }
                    finally {
                        this.setExitDetector(null);
                    }
                }
                for (ExpressionTree object3 : object2.getThrows()) {
                    if (!this.isIn(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), object3, n)) continue;
                    MethodExitDetector methodExitDetector = new MethodExitDetector();
                    this.setExitDetector(methodExitDetector);
                    try {
                        Set<Highlight> set3 = methodExitDetector.process(compilationInfo, document, (MethodTree)object2, Collections.singletonList(object3));
                        return set3;
                    }
                    finally {
                        this.setExitDetector(null);
                    }
                }
            }
            if (set != null) {
                return set;
            }
            object2 = compilationInfo.getTrees().getElement(treePath);
            if (!(object2 == null || tree2 instanceof ClassTree && !this.isIn(n, Utilities.findIdentifierSpan(treePath, compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document)) || Utilities.isKeyword(tree2) || tree2 instanceof MethodTree && tree != null)) {
                object = new FindLocalUsagesQuery();
                this.setLocalUsages((FindLocalUsagesQuery)((Object)object));
                try {
                    set = ((FindLocalUsagesQuery)((Object)object)).findUsages((Element)object2, compilationInfo, document);
                }
                finally {
                    this.setLocalUsages(null);
                }
            }
            tree = tree2;
        }
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    private final synchronized void setExitDetector(MethodExitDetector methodExitDetector) {
        this.exitDetector = methodExitDetector;
    }

    private final synchronized void setLocalUsages(FindLocalUsagesQuery findLocalUsagesQuery) {
        this.localUsages = findLocalUsagesQuery;
    }

    public final synchronized void cancel() {
        this.canceled = true;
        if (this.exitDetector != null) {
            this.exitDetector.cancel();
        }
        if (this.localUsages != null) {
            this.localUsages.cancel();
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }
}

