/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUnusedImportFix
implements Fix {
    private FileObject file;
    private List<TreePathHandle> importsToRemove;
    private String bundleKey;

    public static RemoveUnusedImportFix create(FileObject fileObject, TreePathHandle treePathHandle) {
        return new RemoveUnusedImportFix(fileObject, Collections.singletonList(treePathHandle), "FIX_Remove_Unused_Import");
    }

    public static RemoveUnusedImportFix create(FileObject fileObject, List<TreePathHandle> list) {
        return new RemoveUnusedImportFix(fileObject, list, "FIX_All_Remove_Unused_Import");
    }

    private RemoveUnusedImportFix(FileObject fileObject, List<TreePathHandle> list, String string) {
        this.file = fileObject;
        this.importsToRemove = list;
        this.bundleKey = string;
    }

    public String getText() {
        return NbBundle.getMessage(RemoveUnusedImportFix.class, (String)this.bundleKey);
    }

    public ChangeInfo implement() {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        try {
            javaSource.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.PARSED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    for (TreePathHandle treePathHandle : RemoveUnusedImportFix.this.importsToRemove) {
                        TreePath treePath = treePathHandle.resolve((CompilationInfo)workingCopy);
                        if (treePath == null) {
                            Logger.getLogger(RemoveUnusedImportFix.class.getName()).info("Cannot resolve import to remove.");
                            return;
                        }
                        compilationUnitTree = workingCopy.getTreeMaker().removeCompUnitImport(compilationUnitTree, (ImportTree)treePath.getLeaf());
                    }
                    workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree);
                }
            }).commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

