/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.HighlightImpl;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    @Deprecated
    private static final boolean DEBUG = false;
    private static final int[] NO_SPAN = new int[]{-1, -1};
    private static final Map<Class, List<Tree.Kind>> class2Kind = new HashMap<Class, List<Tree.Kind>>();
    private static final Set<String> keywords;

    private static int[] findIdentifierSpanImpl(Tree tree, Tree tree2, String string, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        return Utilities.findIdentifierSpanImpl(tree, tree2, Collections.emptyList(), string, compilationUnitTree, sourcePositions, document);
    }

    private static int[] findIdentifierSpanImpl(Tree tree, Tree tree2, List<? extends Tree> list, String string, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n;
        int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n3 = n = tree2 != null ? (int)sourcePositions.getEndPosition(compilationUnitTree, tree2) : n2;
        if (n == -1 && (n = n2) == -1) {
            return NO_SPAN;
        }
        try {
            int n4 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
            for (Tree tree3 : list) {
                int n5;
                if (tree3 == null || (n5 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree3)) == -1 || n5 >= n4) continue;
                n4 = n5;
            }
            if (n4 == -1) {
                return NO_SPAN;
            }
            if (n > n4) {
                n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            }
            if (n > document.getLength() || n4 > document.getLength()) {
                return NO_SPAN;
            }
            String string2 = document.getText(n, n4 - n);
            int n6 = string2.lastIndexOf(string.toString());
            if (n6 != -1) {
                return new int[]{n + n6, n + n6 + string.length()};
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
        }
        return NO_SPAN;
    }

    private static int[] findIdentifierSpanImpl(MemberSelectTree memberSelectTree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, memberSelectTree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, memberSelectTree);
        if (n == -1 || n2 == -1) {
            return NO_SPAN;
        }
        try {
            String string = memberSelectTree.getIdentifier().toString();
            int n3 = n2 - n;
            if (n > document.getLength() || n3 > document.getLength()) {
                return NO_SPAN;
            }
            String string2 = document.getText(n, n3);
            int n4 = string2.lastIndexOf(string);
            if (n4 != -1) {
                return new int[]{n + n4, n + n4 + string.length()};
            }
        }
        catch (BadLocationException badLocationException) {
            BadLocationException badLocationException2 = (BadLocationException)Exceptions.attachMessage((Throwable)badLocationException, (String)("start=" + n + ", endPosition=" + n2));
            LOG.log(Level.INFO, null, badLocationException2);
        }
        return NO_SPAN;
    }

    private static int[] findIdentifierSpanImpl(TreePath treePath, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        if (document == null) {
            throw new NullPointerException();
        }
        Tree tree = treePath.getLeaf();
        if (class2Kind.get(MethodTree.class).contains((Object)tree.getKind())) {
            if (sourcePositions.getStartPosition(compilationUnitTree, tree) == -1L || sourcePositions.getEndPosition(compilationUnitTree, tree) == -1L) {
                return NO_SPAN;
            }
            MethodTree methodTree = (MethodTree)tree;
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            arrayList.addAll(methodTree.getParameters());
            arrayList.addAll(methodTree.getThrows());
            arrayList.add(methodTree.getBody());
            Name name = methodTree.getName();
            if (methodTree.getReturnType() == null) {
                name = ((ClassTree)treePath.getParentPath().getLeaf()).getSimpleName();
            }
            return Utilities.findIdentifierSpanImpl(tree, methodTree.getReturnType(), arrayList, name.toString(), compilationUnitTree, sourcePositions, document);
        }
        if (class2Kind.get(VariableTree.class).contains((Object)tree.getKind())) {
            VariableTree variableTree = (VariableTree)tree;
            return Utilities.findIdentifierSpanImpl(tree, variableTree.getType(), Collections.singletonList(variableTree.getInitializer()), variableTree.getName().toString(), compilationUnitTree, sourcePositions, document);
        }
        if (class2Kind.get(MemberSelectTree.class).contains((Object)tree.getKind())) {
            return Utilities.findIdentifierSpanImpl((MemberSelectTree)tree, compilationUnitTree, sourcePositions, document);
        }
        if (class2Kind.get(ClassTree.class).contains((Object)tree.getKind())) {
            int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
            if (n == -1 || n2 == -1) {
                return NO_SPAN;
            }
            if (n > document.getLength() || n2 > document.getLength()) {
                return NO_SPAN;
            }
            String string = ((ClassTree)tree).getSimpleName().toString();
            if (string.length() == 0) {
                return NO_SPAN;
            }
            try {
                String string2 = document.getText(n, n2 - n);
                int n3 = string2.indexOf(string);
                if (n3 == -1) {
                    return NO_SPAN;
                }
                n += n3;
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.INFO, null, badLocationException);
            }
            int n4 = n + string.length();
            return new int[]{n, n4};
        }
        throw new IllegalArgumentException("Only MethodDecl, VariableDecl and ClassDecl are accepted by this method.");
    }

    public static int[] findIdentifierSpan(final TreePath treePath, final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document) {
        final int[][] nArrayArray = new int[1][];
        document.render(new Runnable(){

            public void run() {
                nArrayArray[0] = Utilities.findIdentifierSpanImpl(treePath, compilationUnitTree, sourcePositions, document);
            }
        });
        return nArrayArray[0];
    }

    private static int findBodyStartImpl(Tree tree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        if (n > document.getLength() || n2 > document.getLength()) {
            return -1;
        }
        try {
            String string = document.getText(n, n2 - n);
            int n3 = string.indexOf(123);
            if (n3 == -1) {
                return -1;
            }
            return n + n3;
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
            return -1;
        }
    }

    public static int findBodyStart(final Tree tree, final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document) {
        Tree.Kind kind = tree.getKind();
        if (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD) {
            throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)kind));
        }
        final int[] nArray = new int[1];
        document.render(new Runnable(){

            public void run() {
                nArray[0] = Utilities.findBodyStartImpl(tree, compilationUnitTree, sourcePositions, document);
            }
        });
        return nArray[0];
    }

    private static int findLastBracketImpl(MethodTree methodTree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, methodTree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, methodTree);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        if (n > document.getLength() || n2 > document.getLength()) {
            return -1;
        }
        try {
            String string = document.getText(n2 - 1, 1);
            if (string.charAt(0) == '}') {
                return n2 - 1;
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
        }
        return -1;
    }

    public static int findLastBracket(final MethodTree methodTree, final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document) {
        final int[] nArray = new int[1];
        document.render(new Runnable(){

            public void run() {
                nArray[0] = Utilities.findLastBracketImpl(methodTree, compilationUnitTree, sourcePositions, document);
            }
        });
        return nArray[0];
    }

    private static Highlight createHighlightImpl(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document, int n, int n2, Collection<ColoringAttributes> collection, Color color) {
        try {
            if (n > document.getLength() || n2 > document.getLength()) {
                return null;
            }
            return new HighlightImpl(document, n, n2, collection, color);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    private static Highlight createHighlightImpl(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document, TreePath treePath, Collection<ColoringAttributes> collection, Color color) {
        Tree tree = treePath.getLeaf();
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
        if (tree instanceof MethodTree || tree instanceof VariableTree || tree instanceof ClassTree || tree instanceof MemberSelectTree) {
            int[] nArray = Utilities.findIdentifierSpan(treePath, compilationUnitTree, sourcePositions, document);
            n = nArray[0];
            n2 = nArray[1];
        }
        if (n == -1 || n2 == -1) {
            return null;
        }
        return Utilities.createHighlightImpl(compilationUnitTree, sourcePositions, document, n, n2, collection, color);
    }

    public static Highlight createHighlight(final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document, final TreePath treePath, final Collection<ColoringAttributes> collection, final Color color) {
        final Highlight[] highlightArray = new Highlight[1];
        document.render(new Runnable(){

            public void run() {
                highlightArray[0] = Utilities.createHighlightImpl(compilationUnitTree, sourcePositions, document, treePath, collection, color);
            }
        });
        return highlightArray[0];
    }

    public static Highlight createHighlight(final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document, final int n, final int n2, final Collection<ColoringAttributes> collection, final Color color) {
        final Highlight[] highlightArray = new Highlight[1];
        document.render(new Runnable(){

            public void run() {
                highlightArray[0] = Utilities.createHighlightImpl(compilationUnitTree, sourcePositions, document, n, n2, collection, color);
            }
        });
        return highlightArray[0];
    }

    public static boolean isKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return keywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return keywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isPrivateElement(Element element) {
        if (element.getKind() == ElementKind.PARAMETER) {
            return true;
        }
        if (element.getKind() == ElementKind.LOCAL_VARIABLE) {
            return true;
        }
        if (element.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    static {
        for (Tree.Kind kind : Tree.Kind.values()) {
            Class<? extends Tree> clazz = kind.asInterface();
            List<Tree.Kind> list = class2Kind.get(clazz);
            if (list == null) {
                list = new ArrayList<Tree.Kind>();
                class2Kind.put(clazz, list);
            }
            list.add(kind);
        }
        keywords = new HashSet<String>();
        keywords.add("true");
        keywords.add("false");
        keywords.add("null");
        keywords.add("this");
        keywords.add("super");
        keywords.add("class");
    }
}

