/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.RecentOpener;
import ij.SocketListener;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.MacroInstaller;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener,
Runnable {
    public static final String VERSION = "1.38o";
    public static Color backgroundColor = new Color(220, 220, 220);
    public static final Font SansSerif12 = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_PORT = 57294;
    public static final int STANDALONE = 0;
    public static final int EMBEDDED = 1;
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static int port = 57294;
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuitting;
    private boolean quitting;
    private long keyPressedTime;
    private long actionPerformedTime;
    private boolean embedded;
    boolean hotkey;

    public ImageJ() {
        this(null, 0);
    }

    public ImageJ(Applet applet) {
        this(applet, 0);
    }

    public ImageJ(Applet applet, int mode) {
        super("ImageJ");
        this.embedded = applet == null && mode == 1;
        this.applet = applet;
        String err1 = Prefs.load(this, applet);
        if (IJ.isLinux()) {
            backgroundColor = new Color(240, 240, 240);
            this.setBackground(backgroundColor);
        }
        Menus m = new Menus(this, applet);
        String err2 = m.addMenuBar();
        m.installPopupMenu(this);
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.setFont(SansSerif12);
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(120, 20);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setFocusTraversalKeysEnabled(false);
        Point loc = this.getPreferredLocation();
        Dimension tbSize = this.toolbar.getPreferredSize();
        int ijWidth = tbSize.width + 10;
        int ijHeight = 100;
        this.setCursor(Cursor.getDefaultCursor());
        if (IJ.isWindows()) {
            try {
                this.setIcon();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.setBounds(loc.x, loc.y, ijWidth, ijHeight);
        this.setLocation(loc.x, loc.y);
        this.pack();
        this.setResizable(!IJ.isMacintosh() && !IJ.isWindows());
        this.show();
        if (err1 != null) {
            IJ.error(err1);
        }
        if (err2 != null) {
            IJ.error(err2);
        }
        if (IJ.isMacintosh() && applet == null) {
            Object qh = null;
            if (IJ.isJava14()) {
                qh = IJ.runPlugIn("MacAdapter", "");
            }
            if (qh == null) {
                IJ.runPlugIn("QuitHandler", "");
            }
        }
        if (IJ.isJava2() && applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", "");
        }
        m.installStartupMacroSet();
        String str = m.nMacros == 1 ? " macro)" : " macros)";
        IJ.showStatus("Version 1.38o (" + m.nPlugins + " commands, " + m.nMacros + str);
        if (applet == null && !this.embedded) {
            new SocketListener();
        }
    }

    void setIcon() throws Exception {
        URL url = this.getClass().getResource("/microscope.gif");
        if (url == null) {
            return;
        }
        Image img = this.createImage((ImageProducer)url.getContent());
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int ijWidth;
        if (!IJ.isJava14()) {
            return new Point(0, 0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        int ijX = Prefs.getInt(IJ_X, -99);
        int ijY = Prefs.getInt(IJ_Y, -99);
        if (ijX >= 0 && ijY > 0 && ijX < maxBounds.x + maxBounds.width - 75) {
            return new Point(ijX, ijY);
        }
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = maxBounds.width > 832 ? 0.8 : 0.9;
        ijX = (int)(percent * (double)(maxBounds.width - (ijWidth = tbsize.width + 10)));
        if (ijX < 10) {
            ijX = 10;
        }
        return new Point(ijX, maxBounds.y);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String name) {
        new Executer(name, null);
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        IJ.runFilterPlugIn(theFilter, cmd, arg);
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        return IJ.runUserPlugIn(commandName, className, arg, createNewLoader);
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            if (item.getParent() == Menus.openRecentMenu) {
                new RecentOpener(cmd);
                return;
            }
            this.hotkey = false;
            this.actionPerformedTime = System.currentTimeMillis();
            long ellapsedTime = this.actionPerformedTime - this.keyPressedTime;
            if (cmd != null && ellapsedTime >= 10L) {
                this.doCommand(cmd);
            }
            if (IJ.debugMode) {
                IJ.log("actionPerformed: " + ellapsedTime + " " + e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        IJ.showStatus("Memory: " + IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Hashtable macroShortcuts;
        Roi roi;
        boolean isStack;
        int keyCode;
        block44: {
            block43: {
                keyCode = e.getKeyCode();
                IJ.setKeyDown(keyCode);
                this.hotkey = false;
                if (keyCode == 17) break block43;
                if (keyCode != 16) break block44;
            }
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ") keyChar=\"" + keyChar + "\" (" + keyChar + ") " + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        boolean alt = (flags & 8) != 0;
        boolean meta = (flags & 4) != 0;
        String c = "";
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u00ff' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            if ((flags & 4) != 0 && IJ.isMacOSX()) {
                return;
            }
            if (alt) {
                switch (keyChar) {
                    case 'm': 
                    case 'u': {
                        keyChar = '\u00b5';
                        break;
                    }
                    case 'A': {
                        keyChar = '\u00c5';
                        break;
                    }
                }
            }
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        if (!control && !meta && (macroShortcuts = Menus.getMacroShortcuts()).size() > 0 && (c = shift ? (String)macroShortcuts.get(new Integer(keyCode + 200)) : (String)macroShortcuts.get(new Integer(keyCode))) != null) {
            MacroInstaller.runMacroShortcut(c);
            return;
        }
        if (!Prefs.requireControlKey || control || meta) {
            Hashtable shortcuts = Menus.getShortcuts();
            c = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        }
        if (c == null) {
            switch (keyChar) {
                case '<': {
                    c = "Previous Slice [<]";
                    break;
                }
                case '>': {
                    c = "Next Slice [>]";
                    break;
                }
                case '+': 
                case '=': {
                    c = "In";
                    break;
                }
                case '-': {
                    c = "Out";
                    break;
                }
                case '/': {
                    c = "Reslice [/]...";
                    break;
                }
            }
        }
        if (c == null) {
            switch (keyCode) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    c = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 92: {
                    c = "Start Animation";
                    break;
                }
                case 61: {
                    c = "In";
                    break;
                }
                case 45: {
                    c = "Out";
                    break;
                }
                case 47: 
                case 191: {
                    c = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    c = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    c = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    roi = null;
                    if (imp != null) {
                        roi = imp.getRoi();
                    }
                    if (roi == null) {
                        return;
                    }
                    if ((flags & 8) != 0) {
                        roi.nudgeCorner(keyCode);
                    } else {
                        roi.nudge(keyCode);
                    }
                    return;
                }
                case 27: {
                    this.abortPluginOrMacro(imp);
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (c != null && !c.equals("")) {
            if (c.equals("Fill")) {
                this.hotkey = true;
            }
            if (c.charAt(0) == '^') {
                MacroInstaller.runMacroCommand(c);
            } else {
                this.doCommand(c);
                this.keyPressedTime = System.currentTimeMillis();
            }
        }
    }

    void abortPluginOrMacro(ImagePlus imp) {
        ImageWindow win;
        if (imp != null && (win = imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
        Macro.abort();
        Interpreter.abort();
        if (Interpreter.getInstance() != null) {
            IJ.beep();
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.doCommand("Quit");
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh() && !this.quitting) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public void quit() {
        Thread thread = new Thread((Runnable)this, "Quit");
        thread.setPriority(5);
        thread.start();
    }

    public boolean quitting() {
        return this.quitting;
    }

    public void savePreferences(Properties prefs) {
        Point loc = this.getLocation();
        prefs.put(IJ_X, Integer.toString(loc.x));
        prefs.put(IJ_Y, Integer.toString(loc.y));
    }

    public static void main(String[] args) {
        if (System.getProperty("java.version").substring(0, 3).compareTo("1.4") < 0) {
            JOptionPane.showMessageDialog(null, "ImageJ 1.38o requires Java 1.4.1 or later.");
            System.exit(0);
        }
        boolean noGUI = false;
        int nArgs = args != null ? args.length : 0;
        for (int i = 0; i < nArgs; ++i) {
            int delta;
            String arg = args[i];
            if (arg == null || !args[i].startsWith("-")) continue;
            if (args[i].startsWith("-batch")) {
                noGUI = true;
                continue;
            }
            if (args[i].startsWith("-ijpath") && i + 1 < nArgs) {
                Prefs.setHomeDir(args[i + 1]);
                args[i + 1] = null;
                continue;
            }
            if (!args[i].startsWith("-port") || (delta = (int)Tools.parseDouble(args[i].substring(5, args[i].length()), 0.0)) <= 0 || 57294 + delta >= 65536) continue;
            port = 57294 + delta;
        }
        if (nArgs > 0 && !noGUI && ImageJ.isRunning(args)) {
            return;
        }
        ImageJ ij = IJ.getInstance();
        if (!noGUI && (ij == null || ij != null && !ij.isShowing())) {
            ij = new ImageJ(null);
            ij.exitWhenQuitting = true;
        }
        int macros = 0;
        for (int i = 0; i < nArgs; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.startsWith("-")) {
                if ((arg.startsWith("-macro") || arg.startsWith("-batch")) && i + 1 < nArgs) {
                    String arg2 = i + 2 < nArgs ? args[i + 2] : null;
                    IJ.runMacroFile(args[i + 1], arg2);
                    break;
                }
                if (arg.startsWith("-eval") && i + 1 < nArgs) {
                    String rtn = IJ.runMacro(args[i + 1]);
                    if (rtn != null) {
                        System.out.print(rtn);
                    }
                    args[i + 1] = null;
                    continue;
                }
                if (!arg.startsWith("-run") || i + 1 >= nArgs) continue;
                IJ.run(args[i + 1]);
                args[i + 1] = null;
                continue;
            }
            if (macros == 0 && (arg.endsWith(".ijm") || arg.endsWith(".txt"))) {
                IJ.runMacroFile(arg);
                ++macros;
                continue;
            }
            if (arg.indexOf("ij.ImageJ") != -1) continue;
            File file = new File(arg);
            IJ.open(file.getAbsolutePath());
        }
        if (noGUI) {
            System.exit(0);
        }
    }

    static boolean isRunning(String[] args) {
        int macros = 0;
        int nArgs = args.length;
        if (nArgs == 2 && args[0].startsWith("-ijpath")) {
            return false;
        }
        int nCommands = 0;
        try {
            ImageJ.sendArgument("user.dir " + System.getProperty("user.dir"));
            for (int i = 0; i < nArgs; ++i) {
                String arg = args[i];
                if (arg == null) continue;
                String cmd = null;
                if (macros == 0 && arg.endsWith(".ijm")) {
                    cmd = "macro " + arg;
                    ++macros;
                } else {
                    if (arg.startsWith("-macro") && i + 1 < nArgs) {
                        String macroArg = i + 2 < nArgs ? "(" + args[i + 2] + ")" : "";
                        cmd = "macro " + args[i + 1] + macroArg;
                        ImageJ.sendArgument(cmd);
                        ++nCommands;
                        break;
                    }
                    if (arg.startsWith("-eval") && i + 1 < nArgs) {
                        cmd = "eval " + args[i + 1];
                        args[i + 1] = null;
                    } else if (arg.startsWith("-run") && i + 1 < nArgs) {
                        cmd = "run " + args[i + 1];
                        args[i + 1] = null;
                    } else if (arg.indexOf("ij.ImageJ") == -1 && !arg.startsWith("-")) {
                        cmd = "open " + arg;
                    }
                }
                if (cmd == null) continue;
                ImageJ.sendArgument(cmd);
                ++nCommands;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static void sendArgument(String arg) throws IOException {
        Socket socket = new Socket("localhost", port);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        out.println(arg);
        out.close();
        socket.close();
    }

    public static int getPort() {
        return port;
    }

    public void exitWhenQuitting(boolean ewq) {
        this.exitWhenQuitting = ewq;
    }

    public void run() {
        this.quitting = true;
        boolean changes = false;
        int[] wList = WindowManager.getIDList();
        if (wList != null) {
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.changes) continue;
                changes = true;
                break;
            }
        }
        if (!changes && Menus.window.getItemCount() > 5) {
            GenericDialog gd = new GenericDialog("ImageJ", this);
            gd.addMessage("Are you sure you want to quit ImageJ?");
            gd.showDialog();
            boolean bl = this.quitting = !gd.wasCanceled();
        }
        if (!this.quitting) {
            return;
        }
        if (!WindowManager.closeAllWindows()) {
            this.quitting = false;
            return;
        }
        if (this.applet == null) {
            this.saveWindowLocations();
            Prefs.savePreferences();
        }
        this.setVisible(false);
        this.dispose();
        if (this.exitWhenQuitting) {
            System.exit(0);
        }
    }

    void saveWindowLocations() {
        Frame frame = WindowManager.getFrame("B&C");
        if (frame != null) {
            Prefs.saveLocation("b&c.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Threshold")) != null) {
            Prefs.saveLocation("threshold.loc", frame.getLocation());
        }
        if ((frame = WindowManager.getFrame("Results")) != null) {
            Prefs.saveLocation("results.loc", frame.getLocation());
            Dimension d = frame.getSize();
            Prefs.set("results.width", d.width);
            Prefs.set("results.height", d.height);
        }
    }
}

