/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.gui.ProgressBar;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;

    public FileOpener(FileInfo fi) {
        this.fi = fi;
        if (fi != null) {
            this.width = fi.width;
            this.height = fi.height;
        }
        if (IJ.debugMode) {
            IJ.log("FileOpener: " + fi);
        }
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean show) {
        ImagePlus imp = null;
        Object pb = null;
        ColorModel cm = this.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(cm, show);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 16: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ColorProcessor ip = new ColorProcessor(this.width, this.height, (int[])pixels);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 12: 
            case 17: {
                Object[] pixelArray = (Object[])this.readPixels(this.fi);
                if (pixelArray == null) {
                    return null;
                }
                ImageStack stack = new ImageStack(this.width, this.height);
                stack.addSlice("Red", pixelArray[0]);
                stack.addSlice("Green", pixelArray[1]);
                stack.addSlice("Blue", pixelArray[2]);
                imp = new ImagePlus(this.fi.fileName, stack);
                imp = new CompositeImage(imp, 3);
                imp.getProcessor().resetMinAndMax();
            }
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        if (this.fi.info != null) {
            imp.setProperty("Info", this.fi.info);
        }
        if (show) {
            imp.show();
        }
        IJ.showProgress(1.0);
        return imp;
    }

    ImagePlus openStack(ColorModel cm, boolean show) {
        ImageStack stack = new ImageStack(this.fi.width, this.fi.height, cm);
        long skip = this.fi.longOffset > 0L ? this.fi.longOffset : (long)this.fi.offset;
        try {
            ImageReader reader = new ImageReader(this.fi);
            InputStream is = this.createInputStream(this.fi);
            if (is == null) {
                return null;
            }
            for (int i = 1; i <= this.fi.nImages; ++i) {
                IJ.showStatus("Reading: " + i + "/" + this.fi.nImages);
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                stack.addSlice(null, pixels);
                skip = this.fi.gapBetweenImages;
                IJ.showProgress((double)i / (double)this.fi.nImages);
            }
            is.close();
        }
        catch (Exception e) {
            IJ.log("" + e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(this.fi.fileName);
            stack.trim();
        }
        IJ.showProgress(1.0);
        if (stack.getSize() == 0) {
            return null;
        }
        if (this.fi.sliceLabels != null && this.fi.sliceLabels.length <= stack.getSize()) {
            for (int i = 0; i < this.fi.sliceLabels.length; ++i) {
                stack.setSliceLabel(this.fi.sliceLabels[i], i + 1);
            }
        }
        ImagePlus imp = new ImagePlus(this.fi.fileName, stack);
        if (this.fi.info != null) {
            imp.setProperty("Info", this.fi.info);
        }
        if (show) {
            imp.show();
        }
        imp.setFileInfo(this.fi);
        this.setCalibration(imp);
        ImageProcessor ip = imp.getProcessor();
        if (ip.getMin() == ip.getMax()) {
            this.setStackDisplayRange(imp);
        }
        IJ.showProgress(1.0);
        return imp;
    }

    void setStackDisplayRange(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int n = stack.getSize();
        for (int i = 1; i <= n; ++i) {
            IJ.showStatus("Calculating stack min and max: " + i + "/" + n);
            ImageProcessor ip = stack.getProcessor(i);
            ip.resetMinAndMax();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (!(ip.getMax() > max)) continue;
            max = ip.getMax();
        }
        imp.getProcessor().setMinAndMax(min, max);
        imp.updateAndDraw();
    }

    public void revertToSaved(ImagePlus imp) {
        ProgressBar pb = IJ.getInstance().getProgressBar();
        String path = this.fi.directory + this.fi.fileName;
        if (this.fi.fileFormat == 3) {
            Image img = Toolkit.getDefaultToolkit().getImage(path);
            imp.setImage(img);
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            return;
        }
        if (this.fi.fileFormat == 6) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", path);
            if (imp2 != null) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 5) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", path);
            if (imp2 != null) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 8) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", path);
            if (imp2 != null) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.fileFormat == 7) {
            ImagePlus imp2 = (ImagePlus)IJ.runPlugIn("ij.plugin.Zip_Reader", path);
            if (imp2 != null && imp2.getWidth() != 0) {
                imp.setProcessor(null, imp2.getProcessor());
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + path);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object pixels = this.readPixels(this.fi);
        if (pixels == null) {
            return;
        }
        ColorModel cm = this.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: 
            case 8: {
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])pixels, 0, this.width));
                imp.setImage(img);
            }
        }
    }

    void setCalibration(ImagePlus imp) {
        int stackSize;
        int f;
        if (this.fi.fileType == 1) {
            if (IJ.debugMode) {
                IJ.log("16-bit signed");
            }
            double[] coeff = new double[]{-32768.0, 1.0};
            imp.getLocalCalibration().setFunction(0, coeff, "gray value");
        }
        Properties props = this.decodeDescriptionString();
        Calibration cal = imp.getCalibration();
        if (this.fi.pixelWidth > 0.0 && this.fi.unit != null) {
            cal.pixelWidth = this.fi.pixelWidth;
            cal.pixelHeight = this.fi.pixelHeight;
            cal.pixelDepth = this.fi.pixelDepth;
            cal.setUnit(this.fi.unit);
        }
        if (this.fi.valueUnit != null && ((f = this.fi.calibrationFunction) >= 0 && f <= 10 && this.fi.coefficients != null || f == 21)) {
            boolean zeroClip = props != null && props.getProperty("zeroclip", "false").equals("true");
            cal.setFunction(f, this.fi.coefficients, this.fi.valueUnit, zeroClip);
        }
        if (this.fi.frameInterval != 0.0) {
            cal.frameInterval = this.fi.frameInterval;
        }
        if (props == null) {
            return;
        }
        cal.xOrigin = this.getDouble(props, "xorigin");
        cal.yOrigin = this.getDouble(props, "yorigin");
        cal.zOrigin = this.getDouble(props, "zorigin");
        cal.info = props.getProperty("info");
        cal.fps = this.getDouble(props, "fps");
        cal.frameInterval = this.getDouble(props, "finterval");
        cal.setTimeUnit(props.getProperty("tunit", "sec"));
        double displayMin = this.getDouble(props, "min");
        double displayMax = this.getDouble(props, "max");
        if (displayMin != 0.0 || displayMax != 0.0) {
            int type = imp.getType();
            ImageProcessor ip = imp.getProcessor();
            if (type == 0 || type == 3) {
                ip.setMinAndMax(displayMin, displayMax);
            } else if (!(type != 1 && type != 2 || ip.getMin() == displayMin && ip.getMax() == displayMax)) {
                ip.setMinAndMax(displayMin, displayMax);
            }
        }
        if ((stackSize = imp.getStackSize()) > 1) {
            int channels = (int)this.getDouble(props, "channels");
            int slices = (int)this.getDouble(props, "slices");
            int frames = (int)this.getDouble(props, "frames");
            if (channels == 0) {
                channels = 1;
            }
            if (slices == 0) {
                slices = 1;
            }
            if (frames == 0) {
                frames = 1;
            }
            if (channels * slices * frames == stackSize) {
                imp.setDimensions(channels, slices, frames);
            }
        }
    }

    public ColorModel createColorModel(FileInfo fi) {
        if (fi.fileType == 5 && fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    public InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        File f;
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(fi.url + fi.fileName).openStream();
        }
        if (fi.directory.length() > 0 && !fi.directory.endsWith(Prefs.separator)) {
            fi.directory = fi.directory + Prefs.separator;
        }
        if ((f = new File(fi.directory + fi.fileName)) == null || f.isDirectory() || !FileOpener.validateFileInfo(f, fi)) {
            return null;
        }
        return new FileInputStream(f);
    }

    static boolean validateFileInfo(File f, FileInfo fi) {
        long offset = fi.longOffset > 0L ? fi.longOffset : (long)fi.offset;
        long length = 0L;
        if (fi.width <= 0 || fi.height < 0) {
            FileOpener.error("Width or height <= 0.", fi, offset, length);
            return false;
        }
        if (offset >= 0L && offset < 1000L) {
            return true;
        }
        if (offset < 0L) {
            FileOpener.error("Offset is negative.", fi, offset, length);
            return false;
        }
        if (fi.fileType == 8 || fi.compression != 1) {
            return true;
        }
        length = f.length();
        long size = fi.width * fi.height * fi.getBytesPerPixel();
        long l = size = fi.nImages > 1 ? size : size / 4L;
        if (fi.height == 1) {
            size = 0L;
        }
        if (offset + size > length) {
            FileOpener.error("Offset + image size > file length.", fi, offset, length);
            return false;
        }
        return true;
    }

    static void error(String msg, FileInfo fi, long offset, long length) {
        IJ.error("FileOpener", "FileInfo parameter error. \n" + msg + "\n \n" + "  Width: " + fi.width + "\n" + "  Height: " + fi.height + "\n" + "  Offset: " + offset + "\n" + "  Bytes/pixel: " + fi.getBytesPerPixel() + "\n" + (length > 0L ? "  File length: " + length + "\n" : ""));
    }

    Object readPixels(FileInfo fi) {
        Object pixels;
        block4: {
            pixels = null;
            try {
                InputStream is = this.createInputStream(fi);
                if (is == null) {
                    return null;
                }
                ImageReader reader = new ImageReader(fi);
                pixels = reader.readPixels(is);
                is.close();
            }
            catch (Exception e) {
                if ("Macro canceled".equals(e.getMessage())) break block4;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", s, 350, 250);
                }
                IJ.log(s);
            }
        }
        return pixels;
    }

    Properties decodeDescriptionString() {
        double spacing;
        int i;
        if (this.fi.description == null || this.fi.description.length() < 7) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("Image Description: " + new String(this.fi.description).replace('\n', ' '));
        }
        if (!this.fi.description.startsWith("ImageJ")) {
            return null;
        }
        Properties props = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(this.fi.description.getBytes());
        try {
            props.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return null;
        }
        this.fi.unit = props.getProperty("unit", "");
        Double n = this.getNumber(props, "cf");
        if (n != null) {
            this.fi.calibrationFunction = n.intValue();
        }
        double[] c = new double[5];
        int count = 0;
        for (i = 0; i < 5 && (n = this.getNumber(props, "c" + i)) != null; ++i) {
            c[i] = n;
            ++count;
        }
        if (count >= 2) {
            this.fi.coefficients = new double[count];
            for (i = 0; i < count; ++i) {
                this.fi.coefficients[i] = c[i];
            }
        }
        this.fi.valueUnit = props.getProperty("vunit");
        n = this.getNumber(props, "images");
        if (n != null && n > 1.0) {
            this.fi.nImages = (int)n.doubleValue();
        }
        if (this.fi.nImages > 1 && (spacing = this.getDouble(props, "spacing")) != 0.0) {
            this.fi.pixelDepth = spacing;
        }
        return props;
    }

    private Double getNumber(Properties props, String key) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    private double getDouble(Properties props, String key) {
        Double n = this.getNumber(props, key);
        return n != null ? n : 0.0;
    }
}

