/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.plugin.PlugIn;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class MacroInstaller
implements PlugIn,
MacroConstants,
ActionListener {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 75;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final char commandPrefix = '^';
    static final String commandPrefixS = "^";
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private int toolCount;
    private String text;
    private String anonymousName;
    private Menu macrosMenu;
    private int autoRunCount;
    private int autoRunAndHideCount;
    private boolean openingStartupMacrosInEditor;
    private static String defaultDir;
    private static String fileName;
    private static MacroInstaller instance;
    private static MacroInstaller listener;

    public void run(String path) {
        if (path == null || path.equals("")) {
            path = this.showDialog();
        }
        if (path == null) {
            return;
        }
        this.openingStartupMacrosInEditor = path.indexOf("StartupMacros") != -1;
        String text = this.open(path);
        if (text != null) {
            String functions = Interpreter.getAdditionalFunctions();
            if (functions != null) {
                text = !text.endsWith("\n") && !functions.startsWith("\n") ? text + "\n" + functions : text + functions;
            }
            this.install(text);
        }
    }

    void install() {
        int i;
        int baseCount;
        if (this.text != null) {
            Tokenizer tok = new Tokenizer();
            this.pgm = tok.tokenize(this.text);
        }
        IJ.showStatus("");
        int[] code = this.pgm.getCode();
        Symbol[] symbolTable = this.pgm.getSymbolTable();
        int count = 0;
        this.shortcutsInUse = null;
        this.inUseCount = 0;
        this.nShortcuts = 0;
        this.toolCount = 0;
        this.macroStarts = new int[75];
        this.macroNames = new String[75];
        int itemCount = this.macrosMenu.getItemCount();
        int n = baseCount = this.macrosMenu == Menus.getMacrosMenu() ? 5 : 5;
        if (itemCount > baseCount) {
            for (i = itemCount - 1; i >= baseCount; --i) {
                this.macrosMenu.remove(i);
            }
        }
        if (this.pgm.hasVars() && this.pgm.getGlobals() == null) {
            new Interpreter().saveGlobals(this.pgm);
        }
        for (i = 0; i < code.length; ++i) {
            int token = code[i] & 0xFFF;
            if (token == 200) {
                int nextToken = code[i + 1] & 0xFFF;
                if (nextToken != 133) continue;
                if (count == 75) {
                    if (this.macrosMenu != Menus.getMacrosMenu()) break;
                    IJ.error("Macro Installer", "Macro sets are limited to 75 macros.");
                    break;
                }
                int address = code[i + 1] >> 12;
                Symbol symbol = symbolTable[address];
                String name = symbol.str;
                this.macroStarts[count] = i + 2;
                this.macroNames[count] = name;
                if (name.indexOf(45) != -1 && (name.indexOf("Tool") != -1 || name.indexOf("tool") != -1)) {
                    Toolbar.getInstance().addMacroTool(name, this, this.toolCount);
                    ++this.toolCount;
                } else if (name.startsWith("AutoRun")) {
                    if (this.autoRunCount == 0 && !this.openingStartupMacrosInEditor) {
                        new MacroRunner(this.pgm, this.macroStarts[count], name, null);
                        if (name.equals("AutoRunAndHide")) {
                            ++this.autoRunAndHideCount;
                        }
                    }
                    ++this.autoRunCount;
                    --count;
                } else if (name.equals("Popup Menu")) {
                    this.installPopupMenu(name, this.pgm);
                } else if (!name.endsWith("Tool Selected")) {
                    this.addShortcut(name);
                    this.macrosMenu.add(new MenuItem(name));
                }
                ++count;
                continue;
            }
            if (token == 128) break;
        }
        this.nMacros = count;
        if (this.toolCount > 0) {
            Toolbar tb = Toolbar.getInstance();
            if (Toolbar.getToolId() >= 15) {
                tb.setTool(0);
            }
            tb.repaint();
        }
        instance = this;
        if (this.shortcutsInUse != null && this.text != null) {
            IJ.showMessage("Install Macros", (this.inUseCount == 1 ? "This keyboard shortcut is" : "These keyboard shortcuts are") + " already in use:" + this.shortcutsInUse);
        }
        if (this.nMacros == 0 && fileName != null) {
            int dotIndex = fileName.lastIndexOf(46);
            this.anonymousName = dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
            this.macrosMenu.add(new MenuItem(this.anonymousName));
            this.nMacros = 1;
        }
        String word = this.nMacros == 1 ? " macro" : " macros";
        IJ.showStatus(this.nMacros + word + " installed");
    }

    public int install(String text) {
        if (text == null && this.pgm == null) {
            return 0;
        }
        this.text = text;
        this.macrosMenu = Menus.getMacrosMenu();
        if (listener != null) {
            this.macrosMenu.removeActionListener(listener);
        }
        this.macrosMenu.addActionListener(this);
        listener = this;
        this.install();
        return this.nShortcuts;
    }

    public int install(String text, Menu menu) {
        this.text = text;
        this.macrosMenu = menu;
        this.install();
        return this.nShortcuts + this.toolCount;
    }

    public void installFile(String path) {
        String text;
        if (path != null && (text = this.open(path)) != null) {
            this.install(text);
        }
    }

    public void installLibrary(String path) {
        String text = this.open(path);
        if (text != null) {
            Interpreter.setAdditionalFunctions(text);
        }
    }

    public void installFromIJJar(String path) {
        String text = this.openFromIJJar(path);
        if (text != null) {
            this.install(text);
        }
    }

    void installPopupMenu(String name, Program pgm) {
        Hashtable h = pgm.getMenus();
        if (h == null) {
            return;
        }
        String[] commands = (String[])h.get(name);
        if (commands == null) {
            return;
        }
        PopupMenu popup = Menus.getPopupMenu();
        if (popup == null) {
            return;
        }
        popup.removeAll();
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("-")) {
                popup.addSeparator();
                continue;
            }
            MenuItem mi = new MenuItem(commands[i]);
            mi.addActionListener(this);
            popup.add(mi);
        }
    }

    void removeShortcuts() {
        Menus.getMacroShortcuts().clear();
        Hashtable shortcuts = Menus.getShortcuts();
        Enumeration en = shortcuts.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            String value = (String)shortcuts.get(key);
            if (value.charAt(0) != '^') continue;
            shortcuts.remove(key);
        }
    }

    void addShortcut(String name) {
        int index1 = name.indexOf(91);
        if (index1 == -1) {
            return;
        }
        int index2 = name.lastIndexOf(93);
        if (index2 <= index1 + 1) {
            return;
        }
        String shortcut = name.substring(index1 + 1, index2);
        int len = shortcut.length();
        if (len > 1) {
            shortcut = shortcut.toUpperCase(Locale.US);
        }
        if (len > 3 || len > 1 && shortcut.charAt(0) != 'F' && shortcut.charAt(0) != 'N') {
            return;
        }
        int code = Menus.convertShortcutToCode(shortcut);
        if (code == 0) {
            return;
        }
        if (this.nShortcuts == 0) {
            this.removeShortcuts();
        }
        if (len == 1) {
            Hashtable macroShortcuts = Menus.getMacroShortcuts();
            macroShortcuts.put(new Integer(code), '^' + name);
            ++this.nShortcuts;
            return;
        }
        Hashtable shortcuts = Menus.getShortcuts();
        if (shortcuts.get(new Integer(code)) != null) {
            if (this.shortcutsInUse == null) {
                this.shortcutsInUse = "\n \n";
            }
            this.shortcutsInUse = this.shortcutsInUse + "\t  " + name + "\n";
            ++this.inUseCount;
            return;
        }
        shortcuts.put(new Integer(code), '^' + name);
        ++this.nShortcuts;
    }

    String showDialog() {
        OpenDialog od;
        String name;
        if (defaultDir == null) {
            defaultDir = Menus.getMacrosPath();
        }
        if ((name = (od = new OpenDialog("Install Macros", defaultDir, fileName)).getFileName()) == null) {
            return null;
        }
        String dir = od.getDirectory();
        if (!name.endsWith(".txt") && !name.endsWith(".ijm")) {
            IJ.showMessage("Macro Installer", "File name must end with \".txt\" or \".ijm\" .");
            return null;
        }
        fileName = name;
        defaultDir = dir;
        return dir + name;
    }

    String open(String path) {
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(path));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            return new String(sb);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return null;
        }
    }

    public String openFromIJJar(String path) {
        String text = null;
        try {
            int n;
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            text = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    public boolean runMacroTool(String name) {
        for (int i = 0; i < this.nMacros; ++i) {
            if (!this.macroNames[i].startsWith(name)) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], name, null);
            return true;
        }
        return false;
    }

    public boolean runMenuTool(String name, String command) {
        for (int i = 0; i < this.nMacros; ++i) {
            if (!this.macroNames[i].startsWith(name)) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], name, command);
            return true;
        }
        return false;
    }

    public static boolean runMacroCommand(String name) {
        if (instance == null) {
            return false;
        }
        if (name.startsWith(commandPrefixS)) {
            name = name.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.nMacros; ++i) {
            if (!name.equals(MacroInstaller.instance.macroNames[i])) continue;
            new MacroRunner(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[i], name, null);
            return true;
        }
        return false;
    }

    public static void runMacroShortcut(String name) {
        if (instance == null) {
            return;
        }
        if (name.startsWith(commandPrefixS)) {
            name = name.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.nMacros; ++i) {
            if (!name.equals(MacroInstaller.instance.macroNames[i])) continue;
            new MacroRunner().runShortcut(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[i], name);
        }
    }

    public void runMacro(String name) {
        if (this.anonymousName != null && name.equals(this.anonymousName)) {
            new MacroRunner(this.pgm, 0, this.anonymousName, null);
            return;
        }
        for (int i = 0; i < this.nMacros; ++i) {
            if (!name.equals(this.macroNames[i])) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], name, null);
            return;
        }
    }

    public int getMacroCount() {
        return this.nMacros;
    }

    public Program getProgram() {
        return this.pgm;
    }

    public boolean isAutoRunAndHide() {
        return this.autoRunAndHideCount > 0;
    }

    public void setFileName(String fileName) {
        MacroInstaller.fileName = fileName;
        this.openingStartupMacrosInEditor = fileName.startsWith("StartupMacros");
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        MenuItem item = (MenuItem)evt.getSource();
        MenuContainer parent = item.getParent();
        if (parent instanceof PopupMenu) {
            for (int i = 0; i < this.nMacros; ++i) {
                if (!this.macroNames[i].equals("Popup Menu")) continue;
                new MacroRunner(this.pgm, this.macroStarts[i], "Popup Menu", cmd);
                return;
            }
        } else {
            this.runMacro(cmd);
        }
    }
}

