/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentModelUtils {
    public static DocumentElement findElement(DocumentModel documentModel, int n, String string, String string2) throws BadLocationException {
        List<DocumentElement> list = documentModel.getDocumentElements(n);
        for (DocumentElement documentElement : list) {
            if (!documentElement.getName().equals(string) || !documentElement.getType().equals(string2)) continue;
            return documentElement;
        }
        return null;
    }

    public static List<DocumentElement> getDescendants(DocumentElement documentElement) {
        ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
        for (DocumentElement documentElement2 : documentElement.getChildren()) {
            arrayList.add(documentElement2);
            arrayList.addAll(DocumentModelUtils.getDescendants(documentElement2));
        }
        return arrayList;
    }

    public static void dumpElementStructure(DocumentElement documentElement) {
        System.out.println("-------- ELEMENTS STRUCTURE --------");
        DocumentModelUtils.dumpElementStructure(documentElement, 0);
    }

    private static void dumpElementStructure(DocumentElement documentElement, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        String string = documentElement.toString();
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
        Iterator<DocumentElement> iterator = documentElement.getChildren().iterator();
        while (iterator.hasNext()) {
            DocumentModelUtils.dumpElementStructure(iterator.next(), n + 4);
        }
    }

    public static void dumpModelElements(DocumentModel documentModel) {
        documentModel.debugElements();
    }
}

