/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class J2SELibraryTypeProvider
implements LibraryTypeProvider {
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String[] VOLUME_TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private J2SELibraryTypeProvider() {
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)J2SELibraryTypeProvider.class, (String)"TXT_J2SELibraryType");
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public void libraryCreated(final LibraryImplementation libraryImplementation) {
        if (!$assertionsDisabled && libraryImplementation == null) {
            throw new AssertionError();
        }
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = J2SELibraryTypeProvider.addLibraryIntoBuild(libraryImplementation, editableProperties);
                    if (bl) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImplementation) {
        if (!$assertionsDisabled && libraryImplementation == null) {
            throw new AssertionError();
        }
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String string = J2SELibraryTypeProvider.LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
                        editableProperties.remove((Object)string);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public Customizer getCustomizer(String string) {
        if (VOLUME_TYPES[0].equals(string) || VOLUME_TYPES[1].equals(string) || VOLUME_TYPES[2].equals(string)) {
            return new J2SEVolumeCustomizer(string);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public static LibraryTypeProvider create() {
        return new J2SELibraryTypeProvider();
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation libraryImplementation, EditableProperties editableProperties) {
        boolean bl = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            Object object;
            String string = LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
            List list = libraryImplementation.getContent(VOLUME_TYPES[i]);
            if (list == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                URI uRI;
                object = (URL)object2.next();
                if ("jar".equals(((URL)object).getProtocol())) {
                    object = FileUtil.getArchiveFile((URL)object);
                }
                File file = null;
                FileObject fileObject = URLMapper.findFileObject((URL)object);
                if (fileObject != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                } else if ("file".equals(((URL)object).getProtocol()) && (uRI = URI.create(((URL)object).toExternalForm())) != null) {
                    file = new File(uRI);
                }
                if (file != null) {
                    if (!bl2) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    bl2 = false;
                    file = FileUtil.normalizeFile((File)file);
                    stringBuffer.append(file.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("J2SELibraryTypeProvider: Can not resolve URL: " + object);
            }
            object2 = editableProperties.getProperty(string);
            object = stringBuffer.toString();
            if (((String)object).equals(object2)) continue;
            editableProperties.setProperty(string, (String)object);
            bl = true;
        }
        return bl;
    }

    static {
        $assertionsDisabled = !J2SELibraryTypeProvider.class.desiredAssertionStatus();
        VOLUME_TYPES = new String[]{VOLUME_TYPE_CLASSPATH, VOLUME_TYPE_SRC, VOLUME_TYPE_JAVADOC};
    }
}

