/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    static final /* synthetic */ boolean $assertionsDisabled;

    private Util() {
    }

    static ClassPath createClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string2));
            URL uRL = Util.getRootURL(file);
            if (uRL == null) continue;
            arrayList.add(ClassPathSupport.createResource((URL)uRL));
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    static URL getRootURL(File file) {
        try {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            } else if (!file.exists()) {
                String string = uRL.toExternalForm();
                if (!string.endsWith("/")) {
                    uRL = new URL(string + "/");
                }
            } else if (file.isFile()) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    zipFile.close();
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                }
                catch (IOException iOException) {
                    uRL = null;
                }
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static String normalizeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform javaPlatform) {
        String string = (String)javaPlatform.getSystemProperties().get("java.specification.version");
        if (string == null) {
            string = "1.1";
        }
        return Util.makeSpec(string);
    }

    public static FileObject findTool(String string, Collection collection) {
        return Util.findTool(string, collection, null);
    }

    public static FileObject findTool(String string, Collection collection, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            FileObject fileObject2 = (FileObject)iterator.next();
            FileObject fileObject3 = fileObject2.getFileObject("bin");
            if (fileObject3 == null || string2 != null && (fileObject3 = fileObject3.getFileObject(string2)) == null || (fileObject = fileObject3.getFileObject(string, Utilities.isWindows() ? "exe" : null)) == null) continue;
            return fileObject;
        }
        return null;
    }

    public static String getExtensions(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken()));
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seplatform$platformdefinition$Util == null ? Util.class$("org.netbeans.modules.java.j2seplatform.platformdefinition.Util") : class$org$netbeans$modules$java$j2seplatform$platformdefinition$Util), (String)"MSG_BrokenExtension"), file2, file));
                    continue;
                }
                if (Utilities.isMac() && "._.DS_Store".equals(file2.getName())) continue;
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                if (!$assertionsDisabled && fileObject == null) {
                    throw new AssertionError((Object)("Must have defined a FileObject for existent file " + file2));
                }
                if (!FileUtil.isArchiveFile((FileObject)fileObject)) continue;
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(fileArray[i].getAbsolutePath());
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String string) {
        if (string != null) {
            try {
                return new SpecificationVersion(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid specification version: " + string);
                while (true) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        return new SpecificationVersion(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (string.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

