/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.DetectPanel;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

public class J2SEWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String[] SOLARIS_64_FOLDERS = new String[]{"sparcv9", "amd64"};
    DataFolder installFolder;
    DetectPanel.WizardPanel detectPanel;
    Collection listeners;
    NewJ2SEPlatform platform;
    NewJ2SEPlatform secondaryPlatform;
    WizardDescriptor wizard;
    int currentIndex;
    static /* synthetic */ Class class$org$netbeans$api$java$platform$JavaPlatform;

    public J2SEWizardIterator(FileObject fileObject) throws IOException {
        this.installFolder = DataFolder.findFolder((FileObject)fileObject);
        this.platform = NewJ2SEPlatform.create(fileObject);
        String string = null;
        for (int i = 0; i < SOLARIS_64_FOLDERS.length; ++i) {
            if (Util.findTool("java", Collections.singleton(fileObject), SOLARIS_64_FOLDERS[i]) == null) continue;
            string = SOLARIS_64_FOLDERS[i];
            break;
        }
        if (string != null) {
            this.secondaryPlatform = NewJ2SEPlatform.create(fileObject);
            this.secondaryPlatform.setArchFolder(string);
        }
    }

    FileObject getInstallFolder() {
        return this.installFolder.getPrimaryFile();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public WizardDescriptor.Panel current() {
        switch (this.currentIndex) {
            case 0: {
                return this.detectPanel;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.detectPanel = new DetectPanel.WizardPanel(this);
        this.currentIndex = 0;
    }

    public Set instantiate() throws IOException {
        this.detectPanel.storeSettings(this.wizard);
        HashSet<JavaPlatform> hashSet = new HashSet<JavaPlatform>();
        Iterator iterator = this.getPlatforms().iterator();
        while (iterator.hasNext()) {
            String string;
            NewJ2SEPlatform newJ2SEPlatform = (NewJ2SEPlatform)iterator.next();
            if (!newJ2SEPlatform.isValid()) continue;
            String string2 = newJ2SEPlatform.getAntName();
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Platforms/org-netbeans-api-java-Platform");
            if (fileObject.getFileObject(string2, "xml") != null) {
                string = NbBundle.getMessage((Class)J2SEWizardIterator.class, (String)"ERROR_InvalidName");
                throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string), 256, null, string, null, null);
            }
            string = PlatformConvertor.create(newJ2SEPlatform, DataFolder.findFolder((FileObject)fileObject), string2);
            hashSet.add((JavaPlatform)string.getNodeDelegate().getLookup().lookup(class$org$netbeans$api$java$platform$JavaPlatform == null ? J2SEWizardIterator.class$("org.netbeans.api.java.platform.JavaPlatform") : class$org$netbeans$api$java$platform$JavaPlatform));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String name() {
        return NbBundle.getMessage((Class)J2SEWizardIterator.class, (String)"TITLE_PlatformName");
    }

    public void nextPanel() {
        ++this.currentIndex;
    }

    public void previousPanel() {
        --this.currentIndex;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizard = null;
        this.detectPanel = null;
    }

    public NewJ2SEPlatform getPlatform() {
        return this.platform;
    }

    public NewJ2SEPlatform getSecondaryPlatform() {
        return this.secondaryPlatform;
    }

    private List getPlatforms() {
        ArrayList<NewJ2SEPlatform> arrayList = new ArrayList<NewJ2SEPlatform>();
        arrayList.add(this.platform);
        if (this.secondaryPlatform != null) {
            arrayList.add(this.secondaryPlatform);
        }
        return arrayList;
    }
}

