/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.awt.JMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public final class EnableAction
extends CallableSystemAction
implements Presenter.Menu {
    private static final long serialVersionUID = 1L;

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage((Class)EnableAction.class, (String)"EnableAction");
    }

    public JMenuItem getMenuPresenter() {
        JMenuPlus jMenuPlus = new JMenuPlus();
        Mnemonics.setLocalizedText((AbstractButton)jMenuPlus, (String)this.getName());
        jMenuPlus.addMenuListener(new MainItemListener());
        return jMenuPlus;
    }

    public JMenuItem getPopupPresenter() {
        JMenuPlus jMenuPlus = new JMenuPlus();
        Mnemonics.setLocalizedText((AbstractButton)jMenuPlus, (String)this.getName());
        jMenuPlus.addMenuListener(new MainItemListener());
        return jMenuPlus;
    }

    public void performAction() {
    }

    private static final class MainItemListener
    implements MenuListener,
    ActionListener {
        private static final String TYPE = "type";
        static final /* synthetic */ boolean $assertionsDisabled;

        private MainItemListener() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuSelected(MenuEvent menuEvent) {
            Object object;
            JMenu jMenu = (JMenu)menuEvent.getSource();
            int n = 0;
            SuggestionTypes suggestionTypes = SuggestionTypes.getDefault();
            Iterator iterator = suggestionTypes.getAllTypes().iterator();
            while (iterator.hasNext()) {
                object = (SuggestionType)iterator.next();
                if (ManagerSettings.getDefault().isEnabled(((SuggestionType)object).getName())) continue;
                String string = ((SuggestionType)object).getLocalizedName();
                jMenu.add(this.createMenuItem(string, (SuggestionType)object));
                ++n;
            }
            if (n == 0) {
                object = this.createMenuItem(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$EnableAction == null ? (class$org$netbeans$modules$tasklist$suggestions$EnableAction = EnableAction.class$("org.netbeans.modules.tasklist.suggestions.EnableAction")) : class$org$netbeans$modules$tasklist$suggestions$EnableAction), (String)"Empty"), null);
                ((JMenuItem)object).setEnabled(false);
                jMenu.add((JMenuItem)object);
            }
        }

        private JMenuItem createMenuItem(String string, SuggestionType suggestionType) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            if (suggestionType != null) {
                jMenuItem.putClientProperty(TYPE, suggestionType);
            }
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            SuggestionType suggestionType = (SuggestionType)jMenuItem.getClientProperty(TYPE);
            if (!$assertionsDisabled && suggestionType == null) {
                throw new AssertionError();
            }
            SuggestionManagerImpl suggestionManagerImpl = (SuggestionManagerImpl)SuggestionManager.getDefault();
            suggestionManagerImpl.setEnabled(suggestionType.getName(), true, false);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$suggestions$EnableAction == null ? (class$org$netbeans$modules$tasklist$suggestions$EnableAction = EnableAction.class$("org.netbeans.modules.tasklist.suggestions.EnableAction")) : class$org$netbeans$modules$tasklist$suggestions$EnableAction).desiredAssertionStatus();
        }
    }
}

