/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

class SuggestionCache
implements DocumentListener,
PropertyChangeListener {
    private HashMap map = null;

    SuggestionCache() {
    }

    public void add(Document document, DataObject dataObject, List list) {
        if (this.map == null) {
            this.map = new HashMap(60);
        }
        document.removeDocumentListener(this);
        document.addDocumentListener(this);
        EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
        if (observable != null) {
            observable.removePropertyChangeListener((PropertyChangeListener)this);
            observable.addPropertyChangeListener((PropertyChangeListener)this);
        }
        Entry entry = new Entry(document, list, observable);
        this.map.put(document, entry);
    }

    public List lookup(Document document) {
        if (this.map == null) {
            return null;
        }
        Entry entry = (Entry)this.map.get(document);
        if (entry == null) {
            return null;
        }
        return entry.list;
    }

    public void flush() {
        if (this.map == null) {
            return;
        }
        this.map.clear();
    }

    public void remove(Document document) {
        Entry entry = (Entry)this.map.remove(document);
        if (entry != null) {
            document.removeDocumentListener(this);
            if (entry.listener != null) {
                entry.listener.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("document")) {
            try {
                EditorCookie editorCookie = (EditorCookie)propertyChangeEvent.getSource();
                StyledDocument styledDocument = editorCookie.getDocument();
                this.invalidate(styledDocument);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log("ev.getSource().getClass() = " + propertyChangeEvent.getSource().getClass().getName());
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private void invalidate(Document document) {
        this.remove(document);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate(documentEvent.getDocument());
    }

    private static class Entry {
        List list;
        Document doc;
        EditorCookie.Observable listener;

        Entry(Document document, List list, EditorCookie.Observable observable) {
            this.list = list;
            this.doc = document;
            this.listener = observable;
        }
    }
}

