/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;

public class SuggestionList
extends TaskList {
    private static final int MAX_INLINE = 20;
    static final Object CATEGORY_NODE_SEED = new Object();
    private final int groupTreshold;
    private Map categoryTasks = null;

    public SuggestionList() {
        this(20);
    }

    public SuggestionList(int n) {
        this.groupTreshold = n;
    }

    synchronized SuggestionImpl getCategoryTask(SuggestionType suggestionType, boolean bl) {
        SuggestionImpl suggestionImpl = null;
        if (this.categoryTasks != null) {
            suggestionImpl = (SuggestionImpl)((Object)this.categoryTasks.get(suggestionType));
        }
        if (bl && suggestionImpl == null) {
            suggestionImpl = new SuggestionImpl(null, suggestionType.getLocalizedName(), suggestionType, null, CATEGORY_NODE_SEED);
            suggestionImpl.setType(suggestionType.getName());
            suggestionImpl.setIcon(suggestionType.getIconImage());
            suggestionImpl.setVisitable(false);
            SuggestionManagerImpl suggestionManagerImpl = (SuggestionManagerImpl)SuggestionManager.getDefault();
            if (suggestionManagerImpl.isExpandedType(suggestionType)) {
                // empty if block
            }
            if (this.categoryTasks == null) {
                this.categoryTasks = new HashMap(20);
            }
            this.categoryTasks.put(suggestionType, suggestionImpl);
            SuggestionImpl suggestionImpl2 = this.findAfter(suggestionType);
            if (suggestionImpl2 != null) {
                this.addCategory((Task)suggestionImpl, suggestionImpl2);
            } else {
                this.addCategory((Task)suggestionImpl, false);
            }
        }
        return suggestionImpl;
    }

    private void addCategory(Task task, Task task2) {
        if (task.getParent() == null) {
            this.appendTask(task);
        } else {
            Task task3 = task.getParent();
            task3.removeSubtask(task);
            task3.addSubtask(task, task2);
        }
    }

    private void addCategory(Task task, boolean bl) {
        if (task.getParent() == null) {
            this.appendTask(task);
        } else {
            Task task2 = task.getParent();
            task2.removeSubtask(task);
            task2.addSubtask(task, bl);
        }
    }

    SuggestionImpl findAfter(SuggestionType suggestionType) {
        SuggestionImpl suggestionImpl = null;
        int n = suggestionType.getPosition();
        Iterator iterator = this.getTasks().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            ++n2;
            SuggestionImpl suggestionImpl2 = (SuggestionImpl)((Object)iterator.next());
            int n3 = suggestionImpl2.getSType().getPosition();
            if (n3 > n) break;
            suggestionImpl = suggestionImpl2;
        }
        if (n2 == this.getTasks().size()) {
            return null;
        }
        return suggestionImpl;
    }

    synchronized void removeCategory(SuggestionImpl suggestionImpl, boolean bl) {
        if (suggestionImpl != null && (bl || !suggestionImpl.hasSubtasks())) {
            suggestionImpl.getParent().removeSubtask((Task)suggestionImpl);
            this.categoryTasks.remove(suggestionImpl.getSType());
        }
    }

    synchronized void removeCategory(SuggestionType suggestionType) {
        if (this.getTasks().size() == 0) {
            this.categoryTasks = null;
            return;
        }
        Iterator iterator = this.getTasks().iterator();
        ArrayList<SuggestionImpl> arrayList = new ArrayList<SuggestionImpl>(50);
        while (iterator.hasNext()) {
            SuggestionImpl suggestionImpl = (SuggestionImpl)((Object)iterator.next());
            if (suggestionImpl.getSType() != suggestionType) continue;
            arrayList.add(suggestionImpl);
        }
        this.addRemove(null, arrayList, false, null, null);
        if (this.categoryTasks != null) {
            this.categoryTasks.remove(suggestionType);
        }
    }

    public Collection getCategoryTasks() {
        if (this.categoryTasks != null) {
            return this.categoryTasks.values();
        }
        return null;
    }

    void clearCategoryTasks() {
        this.categoryTasks = null;
    }

    final int getGroupTreshold() {
        return this.groupTreshold;
    }
}

