/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.apihole.tasklist.SPIHole;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.DefaultSuggestionManager;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SPIMonitor;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionProviders;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.netbeans.modules.tasklist.suggestions.SuggestionView;
import org.netbeans.modules.tasklist.suggestions.SuggestionsBroker;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public final class SuggestionManagerImpl
extends DefaultSuggestionManager {
    private final boolean stats = System.getProperty("netbeans.tasklist.stats") != null;
    boolean running = false;
    boolean prepared = false;
    SuggestionProvider unfiltered = null;
    private SuggestionList list = null;
    private boolean switchingFiles = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isObserved(String string) {
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set set = registry.getOpened();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SuggestionView suggestionView;
            TopComponent topComponent = (TopComponent)iterator.next();
            if (!(topComponent instanceof SuggestionView) || !(suggestionView = (SuggestionView)topComponent).isObserved(string)) continue;
            return true;
        }
        return false;
    }

    public void dispatchPrepare() {
        if (!this.prepared) {
            List list = this.getProviders();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
                try {
                    suggestionProvider.notifyPrepare();
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Error error) {
                    ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)error);
                }
            }
            this.prepared = true;
        }
    }

    public void dispatchRun() {
        if (!this.running) {
            if (!this.prepared) {
                this.dispatchPrepare();
            }
            List list = this.getProviders();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
                if (this.unfiltered != null && this.unfiltered != suggestionProvider) continue;
                try {
                    suggestionProvider.notifyRun();
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Error error) {
                    ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)error);
                }
            }
            this.running = true;
        }
    }

    public void dispatchStop() {
        if (this.running) {
            List list = this.getProviders();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
                if (this.unfiltered != null && this.unfiltered != suggestionProvider) continue;
                try {
                    suggestionProvider.notifyStop();
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Error error) {
                    ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + suggestionProvider + ").");
                    ErrorManager.getDefault().notify(1, (Throwable)error);
                }
            }
            this.running = false;
        }
    }

    public void notifyViewClosed() {
        if (this.prepared) {
            if (this.running) {
                this.dispatchStop();
            }
            List list = this.getProviders();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
                suggestionProvider.notifyFinish();
            }
            this.prepared = false;
        }
    }

    public final SuggestionList getList() {
        if (this.list == null) {
            this.list = new SuggestionList();
        }
        return this.list;
    }

    public synchronized boolean isEnabled(String string) {
        ManagerSettings managerSettings = ManagerSettings.getDefault();
        return managerSettings != null ? managerSettings.isEnabled(string) : true;
    }

    public synchronized void setEnabled(String string, boolean bl, boolean bl2) {
        SuggestionType suggestionType = SuggestionTypes.getDefault().getType(string);
        ManagerSettings.getDefault().setEnabled(string, bl);
        this.toggleProvider(suggestionType, bl);
        if (!bl2) {
            this.writeTypeRegistry();
        }
    }

    private void toggleProvider(SuggestionType suggestionType, boolean bl) {
        SuggestionProvider suggestionProvider = this.getProvider(suggestionType);
        if (suggestionProvider == null) {
            return;
        }
        this.toggleProvider(suggestionProvider, suggestionType, bl, false);
    }

    private void toggleProvider(SuggestionProvider suggestionProvider, SuggestionType suggestionType, boolean bl, boolean bl2) {
        if (bl) {
            suggestionProvider.notifyPrepare();
            suggestionProvider.notifyRun();
        } else {
            String string;
            if (!bl2 && !(string = suggestionProvider.getType()).equals(suggestionType.getName()) && this.isEnabled(string)) {
                this.getList().removeCategory(suggestionType);
                return;
            }
            suggestionProvider.notifyStop();
            suggestionProvider.notifyFinish();
            string = suggestionProvider.getType();
            if (this.isEnabled(string)) {
                this.getList().removeCategory(suggestionType);
                return;
            }
        }
    }

    public synchronized boolean isConfirm(SuggestionType suggestionType) {
        return ManagerSettings.getDefault().isConfirm(suggestionType);
    }

    synchronized void setConfirm(SuggestionType suggestionType, boolean bl, boolean bl2) {
        ManagerSettings.getDefault().setConfirm(suggestionType, bl);
        if (bl2) {
            this.writeTypeRegistry();
        }
    }

    public void notifyFiltered(SuggestionList suggestionList, SuggestionType suggestionType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        List list;
        SuggestionType suggestionType2 = this.getUnfilteredType();
        this.setUnfilteredType(suggestionType);
        if (suggestionType != null) {
            list = suggestionList.getTasks();
            if (list != null) {
                object7 = new ArrayList(list.size());
                object7.addAll(list);
                suggestionList.clear();
                object6 = SuggestionTypes.getDefault().getAllTypes();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (SuggestionType)object5.next();
                    object3 = new ArrayList(100);
                    object2 = object7.iterator();
                    object = suggestionList.getCategoryTask((SuggestionType)object4, false);
                    suggestionList.removeCategory((SuggestionImpl)((Object)object), true);
                    while (object2.hasNext()) {
                        SuggestionImpl suggestionImpl = (SuggestionImpl)((Object)object2.next());
                        if (suggestionImpl.getSType() != object4) continue;
                        if (suggestionImpl == object && suggestionImpl.hasSubtasks()) {
                            ((ArrayList)object3).addAll(suggestionImpl.getSubtasks());
                            continue;
                        }
                        ((ArrayList)object3).add(suggestionImpl);
                    }
                    this.register(((SuggestionType)object4).getName(), (List)object3, null, suggestionList, true);
                }
            }
        } else {
            suggestionList.clearCategoryTasks();
            list = suggestionList.getTasks();
            object7 = new ArrayList();
            if (list != null) {
                object7.addAll(list);
            }
            suggestionList.clear();
            object6 = object7.iterator();
            object5 = null;
            object4 = null;
            while (object6.hasNext()) {
                object3 = (SuggestionImpl)((Object)object6.next());
                if (object3.getSType() != object4) {
                    if (object5 != null) {
                        this.register(((SuggestionType)object4).getName(), (List)object5, null, suggestionList, true);
                        object5.clear();
                    } else {
                        object5 = new ArrayList(50);
                    }
                    object4 = object3.getSType();
                }
                if (object5 == null) {
                    object5 = new ArrayList(50);
                }
                object5.add(object3);
            }
            if (object5 != null && object5.size() > 0) {
                this.register(((SuggestionType)object4).getName(), (List)object5, null, suggestionList, true);
            }
        }
        this.unfiltered = null;
        list = this.getProviders();
        object7 = SuggestionTypes.getDefault();
        object6 = list.listIterator();
        while (object6.hasNext()) {
            boolean bl;
            object5 = (SuggestionProvider)object6.next();
            object4 = object5.getType();
            if (suggestionType != null) {
                bl = false;
                object2 = ((SuggestionTypes)object7).getType((String)object4);
                if (object2 == suggestionType) {
                    bl = true;
                }
                if (bl) {
                    this.unfiltered = object5;
                    if (suggestionType2 == null) continue;
                    object = ((SuggestionTypes)object7).getType((String)object4);
                    this.toggleProvider((SuggestionProvider)object5, (SuggestionType)object, true, true);
                    continue;
                }
                object = ((SuggestionTypes)object7).getType((String)object4);
                this.toggleProvider((SuggestionProvider)object5, (SuggestionType)object, false, true);
                continue;
            }
            bl = false;
            object2 = ((SuggestionTypes)object7).getType((String)object4);
            if (suggestionType2 == object2) {
                bl = true;
                break;
            }
            if (bl) continue;
            object = ((SuggestionTypes)object7).getType((String)object4);
            this.toggleProvider((SuggestionProvider)object5, (SuggestionType)object, true, true);
        }
    }

    public boolean isExpandedType(SuggestionType suggestionType) {
        return ManagerSettings.getDefault().isExpandedType(suggestionType);
    }

    public void setExpandedType(SuggestionType suggestionType, boolean bl) {
        ManagerSettings.getDefault().setExpandedType(suggestionType, bl);
    }

    public void register(String string, List list, List list2, Object object) {
        SPIMonitor.log("  Response on " + object + " " + string + " add: " + (list != null ? "" + list.size() : "null") + " remove:" + (list2 != null ? "" + list2.size() : "null"));
        SuggestionList suggestionList = this.getList();
        if (suggestionList == null) {
            return;
        }
        if (string == null && list != null && list2 != null) {
            this.register(string, null, list2, suggestionList, !this.switchingFiles);
            this.register(string, list, null, suggestionList, !this.switchingFiles);
        } else {
            this.register(string, list, list2, suggestionList, !this.switchingFiles);
        }
    }

    private boolean scanOnShow(DocumentSuggestionProvider documentSuggestionProvider) {
        return ManagerSettings.getDefault().isScanOnShow();
    }

    private boolean scanOnSave(DocumentSuggestionProvider documentSuggestionProvider) {
        return ManagerSettings.getDefault().isScanOnSave();
    }

    private boolean scanOnEdit(DocumentSuggestionProvider documentSuggestionProvider) {
        return ManagerSettings.getDefault().isScanOnEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DELETE_dispatchRescan(Document document, DataObject dataObject, Object object, ProviderAcceptor providerAcceptor) {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError((Object)"Precondition for SuggestionsBroker.getCurrRequest()");
        }
        if (!dataObject.isValid()) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        List list = this.getDocProviders();
        Iterator iterator = list.iterator();
        SuggestionContext suggestionContext = SPIHole.createSuggestionContext((DataObject)dataObject);
        while (iterator.hasNext()) {
            if (SuggestionsBroker.getDefault().getCurrRequest() != object) {
                return;
            }
            DocumentSuggestionProvider documentSuggestionProvider = (DocumentSuggestionProvider)iterator.next();
            if (!providerAcceptor.accept((SuggestionProvider)documentSuggestionProvider) || this.unfiltered != null && documentSuggestionProvider != this.unfiltered) continue;
            if (this.stats) {
                l = System.currentTimeMillis();
            }
            try {
                SPIMonitor.log("Enter rescan " + object + " " + documentSuggestionProvider.getClass());
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + documentSuggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Error error) {
                ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + documentSuggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)error);
            }
            finally {
                SPIMonitor.log("Leave rescan " + object + " " + documentSuggestionProvider.getClass());
            }
            if (!this.stats) continue;
            l2 = System.currentTimeMillis();
            System.out.println("Scan time for provider " + documentSuggestionProvider.getClass().getName() + " = " + (l2 - l) + " ms");
            l3 += l2 - l;
        }
        if (this.stats) {
            System.out.println("TOTAL SCAN TIME = " + l3 + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List dispatchScan(DataObject dataObject, ProviderAcceptor providerAcceptor) {
        if (!dataObject.isValid()) {
            return Collections.EMPTY_LIST;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        List list = this.getDocProviders();
        Iterator iterator = list.iterator();
        LinkedList linkedList = new LinkedList();
        SuggestionContext suggestionContext = SPIHole.createSuggestionContext((DataObject)dataObject);
        while (iterator.hasNext()) {
            DocumentSuggestionProvider documentSuggestionProvider = (DocumentSuggestionProvider)iterator.next();
            if (!providerAcceptor.accept((SuggestionProvider)documentSuggestionProvider) || this.unfiltered != null && documentSuggestionProvider != this.unfiltered) continue;
            if (this.stats) {
                l = System.currentTimeMillis();
            }
            try {
                SPIMonitor.log("Enter scan " + documentSuggestionProvider.getClass());
                List list2 = documentSuggestionProvider.scan(suggestionContext);
                if (list2 != null) {
                    linkedList.addAll(list2);
                }
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + documentSuggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Error error) {
                ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + documentSuggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)error);
            }
            finally {
                SPIMonitor.log("Leave rescan " + documentSuggestionProvider.getClass());
            }
            if (!this.stats) continue;
            l2 = System.currentTimeMillis();
            System.out.println("Scan time for provider " + documentSuggestionProvider.getClass().getName() + " = " + (l2 - l) + " ms");
            l3 += l2 - l;
        }
        if (this.stats) {
            System.out.println("TOTAL SCAN TIME = " + l3 + "\n");
        }
        return linkedList;
    }

    void setFixing(boolean bl) {
        SuggestionsBroker.getDefault().setFixing(bl);
    }

    void editTypes(List list, List list2, List list3) {
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (SuggestionType)iterator.next();
            if (this.isEnabled(((SuggestionType)object).getName())) continue;
            this.setEnabled(((SuggestionType)object).getName(), true, true);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (SuggestionType)iterator.next();
            if (!this.isEnabled(((SuggestionType)object).getName())) continue;
            this.setEnabled(((SuggestionType)object).getName(), false, true);
        }
        object = SuggestionTypes.getDefault().getAllTypes().iterator();
        while (object.hasNext()) {
            SuggestionType suggestionType = (SuggestionType)object.next();
            iterator = list3.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                SuggestionType suggestionType2 = (SuggestionType)iterator.next();
                if (suggestionType2 != suggestionType) continue;
                bl = true;
                break;
            }
            this.setConfirm(suggestionType, !bl, false);
        }
        this.writeTypeRegistry();
    }

    private void writeTypeRegistry() {
        ManagerSettings.getDefault().store();
    }

    private List getProviders() {
        return SuggestionProviders.getDefault().getProviders();
    }

    private List getDocProviders() {
        return SuggestionProviders.getDefault().getDocProviders();
    }

    private SuggestionProvider getProvider(SuggestionType suggestionType) {
        return SuggestionProviders.getDefault().getProvider(suggestionType);
    }

    static {
        $assertionsDisabled = !SuggestionManagerImpl.class.desiredAssertionStatus();
    }
}

