/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionCache;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionsScanner;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SuggestionsBroker {
    private static SuggestionsBroker instance;
    private SuggestionList list;
    private int clientCount = 0;
    private SuggestionManagerImpl manager = (SuggestionManagerImpl)SuggestionManagerImpl.getDefault();
    Env env = new Env();
    private Map openedFilesSuggestionsMap = new HashMap();
    private int allOpenedClientsCount = 0;
    private Job allOpenedJob;
    private SuggestionList allOpenedList;
    private static final Logger LOGGER;
    private List acceptors = new ArrayList(5);
    private final ProviderAcceptor compound = new ProviderAcceptor(){

        public boolean accept(SuggestionProvider suggestionProvider) {
            Iterator iterator = SuggestionsBroker.this.acceptors.iterator();
            while (iterator.hasNext()) {
                ProviderAcceptor providerAcceptor = (ProviderAcceptor)iterator.next();
                if (!providerAcceptor.accept(suggestionProvider)) continue;
                return true;
            }
            return false;
        }
    };
    private volatile Long currRequest = new Long(0L);
    private volatile Comparable finishedRequest = null;
    private SuggestionCache cache = null;
    private List docSuggestions = null;
    private RequestProcessor rp = new RequestProcessor("Suggestions Broker");
    private TopComponent currentTC = null;
    private Document currentDocument = null;
    private DataObject currentDO = null;
    private JEditorPane[] editorsWithCaretListener = null;
    private boolean currentModified = false;
    boolean pendingScan = false;
    private volatile RequestProcessor.Task scheduledRescan;
    private boolean waitingEvent = false;
    private boolean wait = false;
    private WindowSystemMonitor windowSystemMonitor;
    private DataSystemMonitor dataSystemMonitor;
    private EditorMonitor editorMonitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuggestionsBroker() {
    }

    public static SuggestionsBroker getDefault() {
        if (instance == null) {
            instance = new SuggestionsBroker();
        }
        return instance;
    }

    public Job startBroker(ProviderAcceptor providerAcceptor) {
        ++this.clientCount;
        if (this.clientCount == 1) {
            this.manager.dispatchRun();
            this.startActiveSuggestionFetching();
        }
        return new Job(providerAcceptor);
    }

    public AllOpenedJob startAllOpenedBroker(ProviderAcceptor providerAcceptor) {
        ++this.allOpenedClientsCount;
        if (this.allOpenedClientsCount == 1) {
            this.acceptors.add(providerAcceptor);
            TopComponent[] topComponentArray = SuggestionsScanner.openedTopComponents();
            SuggestionsScanner suggestionsScanner = SuggestionsScanner.getDefault();
            LinkedList linkedList = new LinkedList();
            for (int i = 0; i < topComponentArray.length; ++i) {
                DataObject dataObject = SuggestionsBroker.extractDataObject(topComponentArray[i]);
                if (dataObject == null) continue;
                FileObject fileObject = dataObject.getPrimaryFile();
                if (this.openedFilesSuggestionsMap.keySet().contains(fileObject)) continue;
                List list = suggestionsScanner.scanTopComponent(topComponentArray[i], this.compound);
                this.openedFilesSuggestionsMap.put(fileObject, list);
                linkedList.addAll(list);
            }
            this.getAllOpenedSuggestionList().addRemove(linkedList, null, true, null, null);
            this.allOpenedJob = this.startBroker(providerAcceptor);
        }
        return new AllOpenedJob(providerAcceptor);
    }

    private SuggestionList getCurrentSuggestionsList() {
        if (this.list == null) {
            this.list = new SuggestionList();
        }
        return this.list;
    }

    private SuggestionList getAllOpenedSuggestionList() {
        if (this.allOpenedList == null) {
            this.allOpenedList = new SuggestionList();
        }
        return this.allOpenedList;
    }

    final Object getCurrRequest() {
        return this.currRequest;
    }

    private void startActiveSuggestionFetching() {
        LOGGER.info("Starting active suggestions fetching....");
        WindowSystemMonitor windowSystemMonitor = this.getWindowSystemMonitor();
        windowSystemMonitor.enableOpenCloseEvents();
        this.env.addTCRegistryListener(windowSystemMonitor);
        this.env.addDORegistryListener(this.getDataSystemMonitor());
        this.prepareRescanInAWT(false);
    }

    private boolean prepareCurrent() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"This method must be run in the AWT thread");
        }
        if (this.currentTC != null) {
            this.currentTC.removeComponentListener((ComponentListener)this.getWindowSystemMonitor());
            this.currentTC = null;
        }
        if (this.currentDocument != null) {
            this.currentDocument.removeDocumentListener(this.getEditorMonitor());
            this.handleDocHidden(this.currentDocument, this.currentDO);
        }
        this.removeCurrentCaretListeners();
        TopComponent topComponent = this.env.findActiveEditor();
        if (topComponent == null) {
            ArrayList arrayList = new ArrayList(this.getCurrentSuggestionsList().getTasks());
            this.getCurrentSuggestionsList().addRemove(null, arrayList, false, null, null);
            LOGGER.fine("Cannot find active source editor!");
            return false;
        }
        DataObject dataObject = SuggestionsBroker.extractDataObject(topComponent);
        if (dataObject == null) {
            LOGGER.warning("Suspicious editor without dataobject: " + topComponent);
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            LOGGER.fine("No document is loaded in editor!");
            return false;
        }
        this.currentDocument = styledDocument;
        this.currentDocument.addDocumentListener(this.getEditorMonitor());
        this.currentTC = topComponent;
        this.currentTC.addComponentListener((ComponentListener)this.getWindowSystemMonitor());
        this.currentDO = dataObject;
        this.currentModified = dataObject.isModified();
        this.addCurrentCaretListeners();
        return true;
    }

    private boolean serveByCache() {
        if (this.cache != null) {
            this.docSuggestions = this.cache.lookup(this.currentDocument);
            if (this.docSuggestions != null) {
                this.manager.register(null, this.docSuggestions, null, this.getCurrentSuggestionsList(), true);
                this.finishedRequest = this.currRequest;
                return true;
            }
        }
        return false;
    }

    private static DataObject extractDataObject(TopComponent topComponent) {
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dataObject != null && dataObject.isValid()) {
            return dataObject;
        }
        return null;
    }

    private RequestProcessor.Task performRescanInRP(final TopComponent topComponent, final DataObject dataObject, int n) {
        if (!$assertionsDisabled && this.currRequest == Long.MAX_VALUE) {
            throw new AssertionError((Object)"Wrap around logic needed!");
        }
        final Long l = this.currRequest = new Long(this.currRequest + 1L);
        return this.serializeOnBackground(new Runnable(){

            public void run() {
                Object object;
                SuggestionsBroker.this.scheduledRescan = null;
                if (SuggestionsBroker.this.wait) {
                    SuggestionsBroker.this.waitingEvent = true;
                    return;
                }
                if (!SuggestionsBroker.isTopComponentOpened(topComponent)) {
                    return;
                }
                LOGGER.fine("Dispatching rescan() request to providers...");
                SuggestionsBroker.this.setScanning(true);
                List list = SuggestionsBroker.this.manager.dispatchScan(dataObject, SuggestionsBroker.this.compound);
                if (!SuggestionsBroker.isTopComponentOpened(topComponent)) {
                    return;
                }
                if (SuggestionsBroker.this.allOpenedClientsCount > 0) {
                    object = dataObject.getPrimaryFile();
                    List list2 = (List)SuggestionsBroker.this.openedFilesSuggestionsMap.remove(object);
                    SuggestionsBroker.this.openedFilesSuggestionsMap.put(object, list);
                    if (list2 == null || list2.size() != list.size() || !list2.containsAll(list)) {
                        SuggestionsBroker.this.getAllOpenedSuggestionList().addRemove(list, list2, false, null, null);
                    }
                }
                if (!(SuggestionsBroker.this.clientCount <= 0 || (object = new ArrayList(SuggestionsBroker.this.getCurrentSuggestionsList().getTasks())) != null && object.size() == list.size() && object.containsAll(list))) {
                    SuggestionsBroker.this.getCurrentSuggestionsList().addRemove(list, (List)object, false, null, null);
                }
                if (SuggestionsBroker.this.finishedRequest == null || ((Comparable)l).compareTo(SuggestionsBroker.this.finishedRequest) > 0) {
                    SuggestionsBroker.this.finishedRequest = (Comparable)l;
                }
                if (SuggestionsBroker.this.currRequest == SuggestionsBroker.this.finishedRequest) {
                    SuggestionsBroker.this.setScanning(false);
                    LOGGER.fine("It was last pending request.");
                }
            }
        }, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTopComponentOpened(final TopComponent topComponent) {
        if (topComponent == null) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        int n = 0;
        while (n < 57) {
            ErrorManager errorManager;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        blArray[0] = topComponent.isOpened();
                    }
                });
                boolean bl = blArray[0];
                return bl;
            }
            catch (InterruptedException interruptedException) {
                errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)interruptedException, "[TODO] while get " + topComponent.getDisplayName() + " state, interrupted, ignoring...");
                errorManager.notify(1, (Throwable)interruptedException);
                ++n;
            }
            catch (InvocationTargetException invocationTargetException) {
                errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)invocationTargetException, "[TODO] cannot get " + topComponent.getDisplayName() + " state.");
                errorManager.notify((Throwable)invocationTargetException);
                boolean bl = false;
                return bl;
            }
            finally {
                if (n == 0) continue;
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private RequestProcessor.Task serializeOnBackground(Runnable runnable, int n) {
        return this.rp.post(runnable, n, 1);
    }

    private void stuffCache(Document document, DataObject dataObject, boolean bl) {
        boolean bl2 = false;
        if (!bl2) {
            return;
        }
        SuggestionList suggestionList = this.getCurrentSuggestionsList();
        if (suggestionList.getTasks().size() == 0) {
            return;
        }
        Iterator iterator = suggestionList.getTasks().iterator();
        ArrayList<SuggestionImpl> arrayList = new ArrayList<SuggestionImpl>(suggestionList.getTasks().size());
        while (iterator.hasNext()) {
            SuggestionImpl suggestionImpl = (SuggestionImpl)((Object)iterator.next());
            Object object = suggestionImpl.getSeed();
            if (object != SuggestionList.CATEGORY_NODE_SEED) {
                arrayList.add(suggestionImpl);
            }
            Iterator iterator2 = suggestionImpl.subtasksIterator();
            while (iterator2.hasNext()) {
                suggestionImpl = (SuggestionImpl)((Object)iterator2.next());
                object = suggestionImpl.getSeed();
                if (object == SuggestionList.CATEGORY_NODE_SEED) continue;
                arrayList.add(suggestionImpl);
            }
        }
        if (!bl) {
            if (this.cache == null) {
                this.cache = new SuggestionCache();
            }
            this.cache.add(document, dataObject, arrayList);
        }
        if (arrayList.size() > 0) {
            this.manager.register(null, null, arrayList, suggestionList, true);
        }
    }

    private void addCurrentCaretListeners() {
        JEditorPane[] jEditorPaneArray;
        if (!$assertionsDisabled && this.editorsWithCaretListener != null) {
            throw new AssertionError((Object)"addCaretListeners() must not be called twice without removeCaretListeners() => memory leak");
        }
        EditorCookie editorCookie = (EditorCookie)this.currentDO.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            this.editorsWithCaretListener = jEditorPaneArray;
            for (int i = 0; i < this.editorsWithCaretListener.length; ++i) {
                this.editorsWithCaretListener[i].addCaretListener(this.getEditorMonitor());
            }
        }
    }

    private void removeCurrentCaretListeners() {
        if (this.editorsWithCaretListener != null) {
            for (int i = 0; i < this.editorsWithCaretListener.length; ++i) {
                this.editorsWithCaretListener[i].removeCaretListener(this.getEditorMonitor());
            }
        }
        this.editorsWithCaretListener = null;
    }

    private void scheduleRescan(boolean bl, final int n) {
        if (bl && this.scheduledRescan == null) {
            return;
        }
        if (this.scheduledRescan != null) {
            this.scheduledRescan.cancel();
            this.scheduledRescan = null;
            LOGGER.fine("Scheduled rescan task delayed by " + n + " ms.");
        }
        Runnable runnable = new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                if (SuggestionsBroker.this.prepareCurrent()) {
                    if (!$assertionsDisabled && !SuggestionsBroker.this.currentDO.equals(SuggestionsBroker.extractDataObject(SuggestionsBroker.this.currentTC))) {
                        throw new AssertionError((Object)("DO=" + SuggestionsBroker.this.currentDO + "  TC=" + SuggestionsBroker.this.currentTC));
                    }
                    SuggestionsBroker.this.scheduledRescan = SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, n);
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker == null ? (class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker = SuggestionsBroker.class$("org.netbeans.modules.tasklist.suggestions.SuggestionsBroker")) : class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker).desiredAssertionStatus();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    final void setFixing(boolean bl) {
        boolean bl2 = this.wait;
        this.wait = bl;
        if (!bl && bl2 && this.waitingEvent) {
            this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            this.waitingEvent = false;
        }
    }

    private void componentsChanged() {
        this.prepareRescanInAWT(true);
    }

    private void prepareRescanInAWT(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (SuggestionsBroker.this.clientCount > 0) {
                    SuggestionsBroker.this.prepareCurrent();
                    if (!SuggestionsBroker.this.serveByCache() && ManagerSettings.getDefault().isScanOnShow()) {
                        if (bl) {
                            SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, ManagerSettings.getDefault().getShowScanDelay());
                        } else {
                            SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, 0);
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void stopActiveSuggestionFetching() {
        LOGGER.info("Stopping active suggestions fetching....");
        if (this.scheduledRescan != null) {
            this.scheduledRescan.cancel();
            this.scheduledRescan = null;
        }
        this.env.removeTCRegistryListener(this.getWindowSystemMonitor());
        this.env.removeDORegistryListener(this.getDataSystemMonitor());
        if (this.currentTC != null) {
            this.currentTC.removeComponentListener((ComponentListener)this.getWindowSystemMonitor());
            this.currentTC = null;
        }
        if (this.currentDocument != null) {
            this.currentDocument.removeDocumentListener(this.getEditorMonitor());
        }
        this.removeCurrentCaretListeners();
        this.handleDocHidden(this.currentDocument, this.currentDO);
        this.currentDocument = null;
    }

    private void setScanning(boolean bl) {
    }

    private void handleDocHidden(Document document, DataObject dataObject) {
        if (this.currRequest != this.finishedRequest) {
            if (this.cache != null) {
                this.cache.remove(document);
            }
            this.stuffCache(document, dataObject, true);
        } else {
            this.stuffCache(document, dataObject, false);
        }
        this.docSuggestions = null;
    }

    private void handleTopComponentClosed(TopComponent topComponent) {
        this.componentsChanged();
        DataObject dataObject = SuggestionsBroker.extractDataObject(topComponent);
        if (dataObject == null) {
            return;
        }
        List list = (List)this.openedFilesSuggestionsMap.remove(dataObject.getPrimaryFile());
        if (list != null) {
            this.getAllOpenedSuggestionList().addRemove(null, list, false, null, null);
        }
    }

    private void handleTopComponentOpened(TopComponent topComponent) {
        if (topComponent.isShowing()) {
            this.componentsChanged();
        } else {
            DataObject dataObject = SuggestionsBroker.extractDataObject(topComponent);
            if (dataObject == null) {
                return;
            }
            this.performRescanInRP(topComponent, dataObject, ManagerSettings.getDefault().getShowScanDelay());
        }
    }

    private WindowSystemMonitor getWindowSystemMonitor() {
        if (this.windowSystemMonitor == null) {
            this.windowSystemMonitor = new WindowSystemMonitor();
        }
        return this.windowSystemMonitor;
    }

    private DataSystemMonitor getDataSystemMonitor() {
        if (this.dataSystemMonitor == null) {
            this.dataSystemMonitor = new DataSystemMonitor();
        }
        return this.dataSystemMonitor;
    }

    private EditorMonitor getEditorMonitor() {
        if (this.editorMonitor == null) {
            this.editorMonitor = new EditorMonitor();
        }
        return this.editorMonitor;
    }

    static {
        $assertionsDisabled = !SuggestionsBroker.class.desiredAssertionStatus();
        LOGGER = TLUtils.getLogger((Class)SuggestionsBroker.class);
    }

    public class AllOpenedJob {
        private boolean stopped = false;
        private final ProviderAcceptor acceptor;

        private AllOpenedJob(ProviderAcceptor providerAcceptor) {
            this.acceptor = providerAcceptor;
            SuggestionsBroker.this.acceptors.add(providerAcceptor);
        }

        public SuggestionList getSuggestionList() {
            return SuggestionsBroker.this.getAllOpenedSuggestionList();
        }

        public void stopBroker() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            SuggestionsBroker.this.acceptors.remove(this.acceptor);
            SuggestionsBroker.this.allOpenedClientsCount--;
            if (SuggestionsBroker.this.allOpenedClientsCount == 0) {
                SuggestionsBroker.this.allOpenedJob.stopBroker();
                SuggestionsBroker.this.openedFilesSuggestionsMap.clear();
            }
        }
    }

    private class DataSystemMonitor
    implements ChangeListener {
        private DataSystemMonitor() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            LOGGER.fine("EVENT " + changeEvent.getSource() + " changed.");
            Set set = DataObject.getRegistry().getModifiedSet();
            boolean bl = SuggestionsBroker.this.currentModified;
            SuggestionsBroker.this.currentModified = set.contains(SuggestionsBroker.this.currentDO);
            if (SuggestionsBroker.this.currentModified != bl && !SuggestionsBroker.this.currentModified && ManagerSettings.getDefault().isScanOnSave()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getSaveScanDelay());
            }
        }
    }

    private class EditorMonitor
    implements DocumentListener,
    CaretListener {
        private int prevLineNo = -1;

        private EditorMonitor() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            LOGGER.fine("EVENT document changed");
            if (ManagerSettings.getDefault().isScanOnEdit()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            LOGGER.fine("EVENT document changed");
            if (ManagerSettings.getDefault().isScanOnEdit()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            LOGGER.fine("EVENT caret moved");
            SuggestionsBroker.this.scheduleRescan(true, ManagerSettings.getDefault().getEditScanDelay());
            if (SuggestionsBroker.this.currentDocument instanceof StyledDocument) {
                int n = caretEvent.getDot();
                int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)SuggestionsBroker.this.currentDocument), (int)n);
                if (n2 == this.prevLineNo) {
                    return;
                }
                this.prevLineNo = n2;
                Line line = TLUtils.getLineByNumber((DataObject)SuggestionsBroker.this.currentDO, (int)(n2 + 1));
                if (line != null) {
                    // empty if block
                }
            }
        }
    }

    static class Env {
        Env() {
        }

        void addTCRegistryListener(PropertyChangeListener propertyChangeListener) {
            TopComponent.getRegistry().addPropertyChangeListener(propertyChangeListener);
        }

        void removeTCRegistryListener(PropertyChangeListener propertyChangeListener) {
            TopComponent.getRegistry().removePropertyChangeListener(propertyChangeListener);
        }

        void addDORegistryListener(ChangeListener changeListener) {
            DataObject.getRegistry().addChangeListener(changeListener);
        }

        void removeDORegistryListener(ChangeListener changeListener) {
            DataObject.getRegistry().removeChangeListener(changeListener);
        }

        private TopComponent findActiveEditor() {
            Mode mode = WindowManager.getDefault().findMode("editor");
            if (mode == null) {
                return null;
            }
            TopComponent topComponent = mode.getSelectedTopComponent();
            if (topComponent instanceof CloneableEditorSupport.Pane) {
                return topComponent;
            }
            return null;
        }
    }

    public class Job {
        private boolean stopped = false;
        private final ProviderAcceptor acceptor;

        private Job(ProviderAcceptor providerAcceptor) {
            this.acceptor = providerAcceptor;
            SuggestionsBroker.this.acceptors.add(providerAcceptor);
        }

        public void stopBroker() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            SuggestionsBroker.this.acceptors.remove(this.acceptor);
            SuggestionsBroker.this.clientCount--;
            if (SuggestionsBroker.this.clientCount == 0) {
                SuggestionsBroker.this.stopActiveSuggestionFetching();
                if (SuggestionsBroker.this.cache != null) {
                    SuggestionsBroker.this.cache.flush();
                }
                SuggestionsBroker.this.list = null;
                instance = null;
            }
        }

        public SuggestionList getSuggestionsList() {
            return SuggestionsBroker.this.getCurrentSuggestionsList();
        }
    }

    private class WindowSystemMonitor
    implements PropertyChangeListener,
    ComponentListener {
        private Set openedSoFar = Collections.EMPTY_SET;

        private WindowSystemMonitor() {
        }

        private void enableOpenCloseEvents() {
            List<TopComponent> list = Arrays.asList(SuggestionsScanner.openedTopComponents());
            this.openedSoFar = new HashSet<TopComponent>(list);
            Iterator<TopComponent> iterator = list.iterator();
            while (iterator.hasNext()) {
                TopComponent topComponent = iterator.next();
                topComponent.addComponentListener((ComponentListener)new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        TopComponent topComponent = (TopComponent)componentEvent.getComponent();
                        topComponent.removeComponentListener((ComponentListener)this);
                        SuggestionsBroker.this.handleTopComponentOpened(topComponent);
                    }
                });
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("opened")) {
                LOGGER.fine("EVENT opened top-components changed");
                List<TopComponent> list = Arrays.asList(SuggestionsScanner.openedTopComponents());
                HashSet<TopComponent> hashSet = new HashSet<TopComponent>(list);
                if (this.openedSoFar != null) {
                    TopComponent topComponent;
                    Iterator iterator = this.openedSoFar.iterator();
                    while (iterator.hasNext()) {
                        topComponent = (TopComponent)iterator.next();
                        if (hashSet.contains(topComponent)) continue;
                        SuggestionsBroker.this.handleTopComponentClosed(topComponent);
                    }
                    topComponent = hashSet.iterator();
                    while (topComponent.hasNext()) {
                        TopComponent topComponent2 = (TopComponent)topComponent.next();
                        if (this.openedSoFar.contains(topComponent2)) continue;
                        topComponent2.addComponentListener((ComponentListener)new ComponentAdapter(){

                            public void componentShown(ComponentEvent componentEvent) {
                                TopComponent topComponent = (TopComponent)componentEvent.getComponent();
                                topComponent.removeComponentListener((ComponentListener)this);
                                SuggestionsBroker.this.handleTopComponentOpened(topComponent);
                            }
                        });
                    }
                }
                this.openedSoFar = hashSet;
            } else if ("activated".equals(string)) {
                LOGGER.fine("EVENT top-component activated");
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                if (SuggestionsBroker.this.clientCount > 0 && this.isSelectedEditor((Component)topComponent) && SuggestionsBroker.this.currentTC == null) {
                    SuggestionsBroker.this.prepareRescanInAWT(false);
                }
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            LOGGER.fine("EVENT " + componentEvent.getComponent() + " has been hidden");
            if (SuggestionsBroker.this.allOpenedClientsCount == 0) {
                SuggestionsBroker.this.componentsChanged();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        private boolean isSelectedEditor(Component component) {
            Mode mode = WindowManager.getDefault().findMode("editor");
            TopComponent topComponent = null;
            if (mode != null) {
                topComponent = mode.getSelectedTopComponent();
            }
            return topComponent == component;
        }
    }
}

