/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.io.IOException;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DiffElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;
    private ModificationResult.Difference diff;
    private ModificationResult modification;

    public DiffElement(ModificationResult.Difference difference, PositionBounds positionBounds, FileObject fileObject, ModificationResult modificationResult) {
        this.bounds = positionBounds;
        this.displayText = difference.getDescription();
        this.parentFile = fileObject;
        this.diff = difference;
        this.modification = modificationResult;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip elementGrip = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (elementGrip == null) {
            elementGrip = this.parentFile;
        }
        return Lookups.singleton((Object)elementGrip);
    }

    public void setEnabled(boolean bl) {
        this.diff.exclude(!bl);
        super.setEnabled(bl);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    protected String getNewFileContent() {
        try {
            return this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public static DiffElement create(ModificationResult.Difference difference, FileObject fileObject, ModificationResult modificationResult) {
        PositionRef positionRef = difference.getStartPosition();
        PositionRef positionRef2 = difference.getEndPosition();
        Object var5_5 = null;
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        return new DiffElement(difference, positionBounds, fileObject, modificationResult);
    }
}

