/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class PackageRenameHandlerImpl
implements PackageRenameHandler {
    public void handleRename(Node node, String string) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataObject.class);
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (node.isLeaf()) {
            try {
                if (!RetoucheUtils.isValidPackageName(string)) {
                    String string2 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{string});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 1));
                    return;
                }
                FileUtil.createFolder((FileObject)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject), (String)string.replace('.', '/'));
                while (dataFolder.getChildren().length == 0 && dataFolder.isDeleteAllowed()) {
                    DataFolder dataFolder2 = dataFolder.getFolder();
                    dataFolder.delete();
                    dataFolder = dataFolder2;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            return;
        }
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)node);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ((Dictionary)hashtable).put("name", string);
        instanceContent.add(hashtable);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        if (action.isEnabled()) {
            action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
        }
    }
}

