/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;

    public WhereUsedElement(PositionBounds positionBounds, String string, FileObject fileObject, TreePath treePath, CompilationInfo compilationInfo) {
        this.bounds = positionBounds;
        this.displayText = string;
        this.parentFile = fileObject;
        ElementGripFactory.getDefault().put(fileObject, treePath, compilationInfo);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip elementGrip = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (elementGrip == null) {
            elementGrip = this.parentFile;
        }
        return Lookups.singleton((Object)elementGrip);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(CompilationInfo compilationInfo, TreePath treePath) {
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        CharSequence charSequence = null;
        try {
            charSequence = compilationUnitTree.getSourceFile().getCharContent(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        Tree tree = treePath.getLeaf();
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
        if (n2 == -1) {
            ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Cannot get end position for " + tree.getClass().getName() + " " + tree + " file:" + compilationInfo.getFileObject().getPath()));
            n2 = n;
        }
        if (tree.getKind() == Tree.Kind.CLASS) {
            n2 = (n += tree.toString().trim().indexOf(((ClassTree)tree).getSimpleName().toString())) + ((ClassTree)tree).getSimpleName().toString().length();
        }
        if (tree.getKind() == Tree.Kind.METHOD) {
            n = n + tree.toString().indexOf(((MethodTree)tree).getName().toString()) + 1;
            n2 = n + ((MethodTree)tree).getName().toString().length();
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            n = (int)sourcePositions.getEndPosition(compilationUnitTree, ((MemberSelectTree)tree).getExpression());
        }
        LineMap lineMap = treePath.getCompilationUnit().getLineMap();
        long l = lineMap.getLineNumber(n);
        long l2 = lineMap.getLineNumber(n2);
        long l3 = lineMap.getStartPosition(l);
        long l4 = lineMap.getStartPosition(l2 + 1L) - 1L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RetoucheUtils.getHtml(((Object)charSequence.subSequence((int)l3, n)).toString().trim()));
        stringBuffer.append(" <b>");
        stringBuffer.append(charSequence.subSequence(n, n2));
        stringBuffer.append("</b> ");
        stringBuffer.append(RetoucheUtils.getHtml(((Object)charSequence.subSequence(n2, (int)l4)).toString().trim()));
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)compilationInfo.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        CloneableEditorSupport cloneableEditorSupport = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dataObject);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        TreePath treePath2 = WhereUsedElement.getEnclosingTree(treePath);
        return new WhereUsedElement(positionBounds, stringBuffer.toString().trim(), compilationInfo.getFileObject(), treePath2, compilationInfo);
    }

    private static TreePath getEnclosingTree(TreePath treePath) {
        while (treePath != null) {
            Tree tree = treePath.getLeaf();
            if (tree.getKind() == Tree.Kind.CLASS || tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.IMPORT) {
                return treePath;
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }
}

