/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected volatile boolean cancelRequest = false;
    private volatile CancellableTask currentTask;

    public void cancelRequest() {
        this.cancelRequest = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    protected static Problem isElementAvail(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        if (treePathHandle == null) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        Element element = treePathHandle.resolveElement(compilationInfo);
        if (element == null || element.asType().getKind() == TypeKind.ERROR) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"DSC_ElementNotResolved"));
        }
        return null;
    }

    private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> iterable) {
        HashMap<FileObject, LinkedList<FileObject>> hashMap = new HashMap<FileObject, LinkedList<FileObject>>();
        for (FileObject fileObject : iterable) {
            FileObject fileObject2;
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null) continue;
            LinkedList<FileObject> linkedList = (LinkedList<FileObject>)hashMap.get(fileObject2);
            if (linkedList == null) {
                linkedList = new LinkedList<FileObject>();
                hashMap.put(fileObject2, linkedList);
            }
            linkedList.add(fileObject);
        }
        return hashMap.values();
    }

    protected final Collection<ModificationResult> processFiles(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask) {
        this.currentTask = cancellableTask;
        Iterable<? extends List<FileObject>> iterable = this.groupByRoot(set);
        LinkedList<ModificationResult> linkedList = new LinkedList<ModificationResult>();
        for (List<FileObject> list : iterable) {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)list.get(0)), list);
            try {
                linkedList.add(javaSource.runModificationTask(cancellableTask));
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
        }
        return linkedList;
    }
}

