/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.plugins.CopyClassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SafeDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JavaRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        Lookup lookup = abstractRefactoring.getRefactoringSource();
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
        if (abstractRefactoring instanceof WhereUsedQuery) {
            if (treePathHandle != null) {
                return new JavaWhereUsedQueryPlugin((WhereUsedQuery)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof RenameRefactoring) {
            if (treePathHandle != null || fileObject != null && RetoucheUtils.isJavaFile(fileObject)) {
                return new RenameRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
            if (fileObject != null && RetoucheUtils.isOnSourceClasspath(fileObject) && fileObject.isFolder()) {
                return new MoveRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
            if (nonRecursiveFolder != null && RetoucheUtils.isOnSourceClasspath(nonRecursiveFolder.getFolder())) {
                return new MoveRefactoringPlugin((RenameRefactoring)abstractRefactoring);
            }
        } else if (abstractRefactoring instanceof SafeDeleteRefactoring) {
            if (this.checkSafeDelete(abstractRefactoring.getRefactoringSource())) {
                return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring)abstractRefactoring);
            }
        } else {
            if (abstractRefactoring instanceof MoveRefactoring) {
                return new MoveRefactoringPlugin((MoveRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof SingleCopyRefactoring) {
                return new CopyClassRefactoringPlugin((SingleCopyRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof ExtractInterfaceRefactoring) {
                return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof PullUpRefactoring) {
                return new PullUpRefactoringPlugin((PullUpRefactoring)abstractRefactoring);
            }
            if (abstractRefactoring instanceof PushDownRefactoring) {
                return new PushDownRefactoringPlugin((PushDownRefactoring)abstractRefactoring);
            }
        }
        return null;
    }

    private boolean checkSafeDelete(Lookup lookup) {
        boolean bl = false;
        for (FileObject fileObject : lookup.lookupAll(FileObject.class)) {
            bl = true;
            if (RetoucheUtils.isJavaFile(fileObject)) continue;
            return false;
        }
        if (lookup.lookup(TreePathHandle.class) != null) {
            return true;
        }
        return bl;
    }
}

