/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map packagePostfix = new HashMap();
    private AbstractRefactoring refactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;
    Map<FileObject, Set<FileObject>> whoReferences = new HashMap<FileObject, Set<FileObject>>();
    private FileObject[] origFilesToMove;

    public MoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
        this.setup(moveRefactoring.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public MoveRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        FileObject fileObject = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null) {
            this.setup(Collections.singletonList(fileObject), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (Map.Entry<FileObject, ElementHandle> entry : this.classes.entrySet()) {
            Set set = classIndex.getResources(entry.getValue(), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            hashSet.addAll(set);
            this.whoReferences.put(entry.getKey(), set);
        }
        hashSet.addAll(this.filesToMove);
        return hashSet;
    }

    private ClasspathInfo getClasspathInfo(CompilationInfo compilationInfo) {
        ClassPath classPath = RefactoringClassPathImplementation.getCustom(this.filesToMove);
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath, (ClassPath)classPath);
        return classpathInfo;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            final int n = i;
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
                        for (Tree tree : list) {
                            if (tree.getKind() != Tree.Kind.CLASS || !((ClassTree)tree).getSimpleName().toString().equals(MoveRefactoringPlugin.this.filesToMove.get(n).getName())) continue;
                            MoveRefactoringPlugin.this.classes.put(MoveRefactoringPlugin.this.filesToMove.get(n), ElementHandle.create((Element)compilationController.getTrees().getElement(TreePath.getPath(compilationController.getCompilationUnit(), tree))));
                            return;
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        CompilationInfo compilationInfo = (CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class);
        if (classpathInfo == null) {
            classpathInfo = this.getClasspathInfo(compilationInfo);
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.initClasses();
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            Collection<ModificationResult> collection = this.processFiles(set, new UpdateReferences());
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fileObject) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject fileObject2 = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
            FileObject fileObject3 = classPath.findOwnerRoot(fileObject2);
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent()).replace('/', '.');
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()).replace('/', '.');
            String string3 = this.concat(string, this.getNewPackageName(), string2);
            return string3;
        }
        if (this.packagePostfix != null) {
            String string = (String)this.packagePostfix.get(fileObject);
            String string4 = this.concat(null, this.getNewPackageName(), string);
            return string4;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection collection, String string, boolean bl) {
        for (FileObject fileObject : collection) {
            if (RetoucheUtils.isJavaFile(fileObject)) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                this.filesToMove.add(fileObject);
                continue;
            }
            if (!fileObject.isFolder()) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            boolean bl2 = !"".equals(string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                arrayList.add(fileObject2);
            }
            if (!bl) continue;
            this.setup(arrayList, string + (bl2 ? "." : "") + fileObject.getName(), true);
        }
    }

    private String concat(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && !"".equals(string)) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2;
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + ("".equals(string4) ? "" : ".") + string3;
        }
        return string4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateReferences
    implements CancellableTask<WorkingCopy> {
        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            MoveTransformer moveTransformer = new MoveTransformer(workingCopy, MoveRefactoringPlugin.this);
            moveTransformer.scan(workingCopy.getCompilationUnit(), null);
            for (TreePath treePath : moveTransformer.getUsages()) {
                ElementGripFactory.getDefault().put(workingCopy.getFileObject(), treePath, (CompilationInfo)workingCopy);
            }
            MoveRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

