/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;
import org.openide.filesystems.FileObject;

public class MoveTransformer
extends SearchVisitor {
    private FileObject originalFolder;
    private MoveRefactoringPlugin move;
    private Set<Element> elementsToImport = new HashSet<Element>();
    private boolean isThisFileMoving;
    private boolean isThisFileReferencingOldPackage = false;
    private int index;

    public MoveTransformer(WorkingCopy workingCopy, MoveRefactoringPlugin moveRefactoringPlugin) {
        super(workingCopy);
        this.originalFolder = workingCopy.getFileObject().getParent();
        this.move = moveRefactoringPlugin;
        this.isThisFileMoving = moveRefactoringPlugin.filesToMove.contains(workingCopy.getFileObject());
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isElementMoving(element2)) {
            MemberSelectTree memberSelectTree2 = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.move.getTargetPackageName(this.move.filesToMove.get(this.index))), element2);
            this.workingCopy.rewrite((Tree)memberSelectTree, (Tree)memberSelectTree2);
        }
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (!this.isThisFileMoving) {
                if (this.isElementMoving(element2)) {
                    this.elementsToImport.add(element2);
                }
            } else if (!this.isThisFileReferencingOldPackage && !this.isElementMoving(element2) && this.isTopLevelClass(element2) && this.getPackageOf(element2).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent()))) {
                this.isThisFileReferencingOldPackage = true;
            }
        }
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    private PackageElement getPackageOf(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private boolean isThisFileReferencedbyOldPackage() {
        HashSet hashSet = new HashSet(this.move.whoReferences.get(this.workingCopy.getFileObject()));
        hashSet.removeAll(this.move.filesToMove);
        for (FileObject fileObject : hashSet) {
            if (!fileObject.getParent().equals(this.originalFolder)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementMoving(Element element) {
        this.index = 0;
        for (ElementHandle elementHandle : this.move.classes.values()) {
            if (elementHandle.signatureEquals(element)) {
                return true;
            }
            ++this.index;
        }
        this.index = -1;
        return false;
    }

    private boolean isTopLevelClass(Element element) {
        return (element.getKind().isClass() || element.getKind().isInterface()) && element.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        Tree tree = (Tree)super.visitCompilationUnit(compilationUnitTree, element);
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return tree;
        }
        if (this.isThisFileMoving) {
            String string = this.move.getTargetPackageName(this.workingCopy.getFileObject());
            if (compilationUnitTree.getPackageName() != null && !"".equals(string)) {
                this.workingCopy.rewrite((Tree)compilationUnitTree.getPackageName(), (Tree)this.make.Identifier((CharSequence)this.move.getTargetPackageName(this.workingCopy.getFileObject())));
            } else {
                CompilationUnitTree object = this.make.CompilationUnit((ExpressionTree)("".equals(string) ? null : this.make.Identifier((CharSequence)string)), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
                this.workingCopy.rewrite((Tree)compilationUnitTree, (Tree)object);
            }
            if (this.isThisFileReferencingOldPackage) {
                compilationUnitTree = this.insertImport(compilationUnitTree, compilationUnitTree.getPackageName().toString() + ".*");
            }
        }
        for (Element element2 : this.elementsToImport) {
            FileObject fileObject = SourceUtils.getFile((Element)element2, (ClasspathInfo)this.workingCopy.getClasspathInfo());
            compilationUnitTree = this.insertImport(compilationUnitTree, this.move.getTargetPackageName(fileObject) + "." + element2.getSimpleName());
        }
        return tree;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree compilationUnitTree, String string) {
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            if (!importTree.getQualifiedIdentifier().toString().equals(string)) continue;
            return compilationUnitTree;
        }
        CompilationUnitTree compilationUnitTree2 = this.make.insertCompUnitImport(compilationUnitTree, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)string), false));
        this.workingCopy.rewrite((Tree)compilationUnitTree, (Tree)compilationUnitTree2);
        return compilationUnitTree2;
    }
}

