/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PackageRename
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        if (abstractRefactoring instanceof RenameRefactoring && abstractRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
            return new PackageRenamePlugin((RenameRefactoring)abstractRefactoring);
        }
        return null;
    }

    public class PackageRenamePlugin
    implements RefactoringPlugin {
        private RenameRefactoring refactoring;

        public PackageRenamePlugin(RenameRefactoring renameRefactoring) {
            this.refactoring = renameRefactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            refactoringElementsBag.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameNonRecursiveFolder((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class), refactoringElementsBag));
            return null;
        }

        public Problem fastCheckParameters() {
            String string = this.refactoring.getNewName();
            if (!RetoucheUtils.isValidPackageName(string)) {
                String string2 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{string});
                return new Problem(true, string2);
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder(), (String)"classpath/source");
            if (classPath.findResource(string.replace('.', '/')) != null) {
                String string3 = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{string});
                return new Problem(true, string3);
            }
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        private class RenameNonRecursiveFolder
        extends SimpleRefactoringElementImplementation {
            private FileObject folder;
            private RefactoringElementsBag session;
            private String oldName;
            private FileObject root;
            private DataFolder dataFolder;

            public RenameNonRecursiveFolder(NonRecursiveFolder nonRecursiveFolder, RefactoringElementsBag refactoringElementsBag) {
                this.folder = nonRecursiveFolder.getFolder();
                this.session = refactoringElementsBag;
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
                this.oldName = classPath.getResourceName(this.folder, '.', false);
                this.root = classPath.findOwnerRoot(this.folder);
                this.dataFolder = DataFolder.findFolder((FileObject)this.folder);
            }

            public String getText() {
                return "Rename file " + this.folder.getNameExt();
            }

            public String getDisplayText() {
                return this.getText();
            }

            public void performChange() {
                this.setName();
            }

            public void undoChange() {
                throw new UnsupportedOperationException("not implemented");
            }

            public Lookup getLookup() {
                return Lookups.singleton((Object)this.folder.getParent());
            }

            public FileObject getParentFile() {
                return this.folder.getParent();
            }

            public PositionBounds getPosition() {
                return null;
            }

            public void setName() {
                int n;
                int n2;
                String string = PackageRenamePlugin.this.refactoring.getNewName();
                if (this.oldName.equals(string)) {
                    return;
                }
                string = string.replace('.', '/') + '/';
                this.oldName = this.oldName.replace('.', '/') + '/';
                for (n2 = 0; n2 < this.oldName.length() && n2 < string.length() && this.oldName.charAt(n2) == string.charAt(n2); ++n2) {
                }
                String string2 = (n = this.oldName.lastIndexOf(47, --n2)) == -1 ? null : this.oldName.substring(0, n);
                String string3 = n + 1 == string.length() ? "" : string.substring(n + 1);
                try {
                    FileObject fileObject;
                    String string4;
                    FileObject fileObject2;
                    FileObject fileObject3 = fileObject2 = string2 == null ? this.root : this.root.getFileObject(string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                        fileObject = fileObject3.getFileObject(string4);
                        if (fileObject == null) {
                            fileObject = fileObject3.createFolder(string4);
                        }
                        fileObject3 = fileObject;
                    }
                    string4 = this.dataFolder.getPrimaryFile();
                    fileObject = DataFolder.findFolder((FileObject)string4);
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject3);
                    DataObject[] dataObjectArray = fileObject.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        if (!dataObjectArray[i].getPrimaryFile().isData()) continue;
                        dataObjectArray[i].move(dataFolder);
                    }
                    while (!fileObject2.equals(string4) && string4.getChildren().length == 0) {
                        String string5 = string4;
                        string4 = string4.getParent();
                        string5.delete();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

