/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;

public class RenameTransformer
extends SearchVisitor {
    private String newName;

    public RenameTransformer(String string, WorkingCopy workingCopy) {
        super(workingCopy);
        this.newName = string;
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), identifierTree, element);
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), memberSelectTree, element);
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    private void renameUsageIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (element2 == null) {
            return;
        }
        if (element2 != null && element != null && element.getKind() == ElementKind.METHOD && element2.getKind() == ElementKind.METHOD) {
            if (((Object)element2).equals(element) || this.workingCopy.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, (TypeElement)element.getEnclosingElement())) {
                Tree tree2 = this.make.setLabel(tree, (CharSequence)this.newName);
                this.workingCopy.rewrite(tree, tree2);
            }
        } else if (((Object)element2).equals(element)) {
            Tree tree3 = this.make.setLabel(tree, (CharSequence)this.newName);
            this.workingCopy.rewrite(tree, tree3);
        }
    }

    public Tree visitMethod(MethodTree methodTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), methodTree, element);
        return (Tree)super.visitMethod(methodTree, element);
    }

    public Tree visitClass(ClassTree classTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), classTree, element);
        return (Tree)super.visitClass(classTree, element);
    }

    public Tree visitVariable(VariableTree variableTree, Element element) {
        this.renameDeclIfMatch(this.getCurrentPath(), variableTree, element);
        return (Tree)super.visitVariable(variableTree, element);
    }

    private void renameDeclIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (((Object)element).equals(element2)) {
            Tree tree2 = this.make.setLabel(tree, (CharSequence)this.newName);
            this.workingCopy.rewrite(tree, tree2);
        }
    }
}

