/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public void doRename(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    if (element == null) {
                        return null;
                    }
                    if (element.getKind() == ElementKind.CONSTRUCTOR) {
                        element = element.getEnclosingElement();
                    }
                    if (element.getKind() == ElementKind.PACKAGE || element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                        FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
                        return new RenameRefactoringUI(fileObject == null ? compilationInfo.getFileObject() : fileObject);
                    }
                    return new RenameRefactoringUI(treePathHandle, compilationInfo);
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    String string = RefactoringActionsProvider.getName(dictionary);
                    if (string != null) {
                        if (this.pkg[0] != null) {
                            return new RenameRefactoringUI(this.pkg[0], string);
                        }
                        return new RenameRefactoringUI(fileObjectArray[0], string);
                    }
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0]);
                    }
                    return new RenameRefactoringUI(fileObjectArray[0]);
                }
            }.run();
        }
    }

    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fileObject)) {
            return true;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    public void doCopy(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        new NodeToFileObject(lookup.lookupAll(Node.class)){

            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                return new CopyClassRefactoringUI(fileObjectArray[0], RefactoringActionsProvider.this.getTarget(dictionary), RefactoringActionsProvider.this.getPaste(dictionary));
            }
        }.run();
    }

    public boolean canCopy(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        FileObject fileObject = this.getTarget(dictionary);
        if (dictionary != null && dictionary.get("target") != null && fileObject == null) {
            return false;
        }
        if (fileObject != null) {
            if (!fileObject.isFolder()) {
                return false;
            }
            FileObject fileObject2 = dataObject.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fileObject2)) {
                return true;
            }
        } else {
            FileObject fileObject3 = dataObject.getPrimaryFile();
            if (RetoucheUtils.isRefactorable(fileObject3)) {
                return true;
            }
        }
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null && RetoucheUtils.isJavaFile(dataObject.getPrimaryFile());
    }

    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    return new WhereUsedQueryUI(treePathHandle, compilationInfo);
                }
            }.run();
        } else {
            new NodeToElement(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
                    return new WhereUsedQueryUI(treePathHandle, compilationInfo);
                }
            }.run();
        }
    }

    public boolean canDelete(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        for (Node node : collection) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (RetoucheUtils.isRefactorable(dataObject.getPrimaryFile())) continue;
            return false;
        }
        return !collection.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    if (element.getKind() == ElementKind.PACKAGE || element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                        return new SafeDeleteUI(new FileObject[]{compilationInfo.getFileObject()});
                    }
                    return new SafeDeleteUI(new TreePathHandle[]{treePathHandle}, compilationInfo);
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    return new SafeDeleteUI(fileObjectArray);
                }
            }.run();
        }
    }

    private FileObject getTarget(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        Node node = (Node)dictionary.get("target");
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        Transferable transferable = (Transferable)dictionary.get("transferable");
        if (transferable == null) {
            return null;
        }
        Node node = (Node)dictionary.get("target");
        if (node == null) {
            return null;
        }
        PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
        return pasteTypeArray[1];
    }

    static String getName(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return (String)dictionary.get("name");
    }

    public boolean canMove(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        FileObject fileObject = this.getTarget(dictionary);
        if (fileObject != null) {
            Object object;
            if (!fileObject.isFolder()) {
                return false;
            }
            HashSet<DataFolder> hashSet = new HashSet<DataFolder>();
            boolean bl = false;
            for (Node node : collection) {
                object = (DataObject)node.getCookie(DataObject.class);
                if (object == null) {
                    return false;
                }
                if (!RetoucheUtils.isOnSourceClasspath(object.getPrimaryFile())) {
                    return false;
                }
                if (object instanceof DataFolder) {
                    hashSet.add((DataFolder)object);
                    continue;
                }
                if (!RetoucheUtils.isJavaFile(object.getPrimaryFile())) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
            for (DataFolder dataFolder : hashSet) {
                object = dataFolder.children(true);
                while (object.hasMoreElements()) {
                    if (!RetoucheUtils.isJavaFile(((DataObject)object.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean bl = false;
        for (Node node : collection) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (dataObject instanceof DataFolder) {
                return false;
            }
            if (!RetoucheUtils.isOnSourceClasspath(dataObject.getPrimaryFile())) {
                return false;
            }
            if (!RetoucheUtils.isJavaFile(dataObject.getPrimaryFile())) continue;
            bl = true;
        }
        return bl;
    }

    public void doMove(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    if (treePathHandle.resolve(compilationInfo).getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        try {
                            return new MoveClassUI(DataObject.find((FileObject)compilationInfo.getFileObject()));
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                        }
                    }
                    try {
                        return new MoveClassUI(DataObject.find((FileObject)compilationInfo.getFileObject()));
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                    }
                }
            }.run();
        } else {
            new NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    PasteType pasteType = RefactoringActionsProvider.this.getPaste(dictionary);
                    FileObject fileObject = RefactoringActionsProvider.this.getTarget(dictionary);
                    if (fileObjectArray.length == 1) {
                        try {
                            return new MoveClassUI(DataObject.find((FileObject)fileObjectArray[0]), fileObject, pasteType);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
                        }
                    }
                    HashSet<FileObject> hashSet = new HashSet<FileObject>();
                    hashSet.addAll(Arrays.asList(fileObjectArray));
                    return new MoveClassesUI(hashSet, fileObject, pasteType);
                }
            }.run();
        }
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        TopComponent topComponent;
        return editorCookie != null && editorCookie.getOpenedPanes() != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElement
    implements Runnable {
        private Node node;
        private RefactoringUI ui;

        public NodeToElement(Collection<? extends Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        @Override
        public final void run() {
            DataObject dataObject = (DataObject)this.node.getCookie(DataObject.class);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            assert (javaSource != null);
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        TreePathHandle treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                        NodeToElement.this.ui = NodeToElement.this.createRefactoringUI(treePathHandle, (CompilationInfo)compilationController);
                    }
                }, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, CompilationInfo var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObject
    implements Runnable {
        private Collection<? extends Node> nodes;
        private RefactoringUI ui;
        public NonRecursiveFolder[] pkg;

        public NodeToFileObject(Collection<? extends Node> collection) {
            this.nodes = collection;
        }

        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fileObjectArray.length];
            int n = 0;
            for (Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjectArray));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1);
    }

    public static abstract class TextComponentRunnable
    implements Runnable {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;

        public TextComponentRunnable(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public final void run() {
            JavaSource javaSource;
            try {
                javaSource = JavaSource.forDocument((Document)this.textC.getDocument());
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        List<? extends Tree> list;
                        TreePath treePath = null;
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        treePath = compilationController.getTreeUtilities().pathFor(TextComponentRunnable.this.caret);
                        if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT && !(list = compilationController.getCompilationUnit().getTypeDecls()).isEmpty()) {
                            treePath = TreePath.getPath(compilationController.getCompilationUnit(), list.get(0));
                        }
                        TextComponentRunnable.this.ui = TextComponentRunnable.this.createRefactoringUI(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationController), TextComponentRunnable.this.start, TextComponentRunnable.this.end, (CompilationInfo)compilationController);
                    }
                }, false);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
            javaSource = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)javaSource);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(TreePathHandle var1, int var2, int var3, CompilationInfo var4);
    }
}

