/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.util.Locale;
import java.util.Vector;
import javax.help.event.EventListenerList;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;

public abstract class SearchQuery {
    protected EventListenerList listenerList = new EventListenerList();
    protected SearchEngine hs;
    protected String searchparams;
    protected Locale l;
    private static final boolean debug = false;

    public SearchQuery(SearchEngine searchEngine) {
        this.hs = searchEngine;
    }

    public void addSearchListener(SearchListener searchListener) {
        this.listenerList.add(SearchListener.class, searchListener);
    }

    public void removeSearchListener(SearchListener searchListener) {
        this.listenerList.remove(SearchListener.class, searchListener);
    }

    public void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
        this.searchparams = string;
        this.l = locale;
        this.fireSearchStarted();
    }

    public void stop() throws IllegalStateException {
        this.fireSearchFinished();
    }

    public SearchEngine getSearchEngine() {
        return this.hs;
    }

    public abstract boolean isActive();

    public void itemsFound(boolean bl, Vector vector) {
        this.fireItemsFound(bl, vector);
    }

    protected void fireItemsFound(boolean bl, Vector vector) {
        SearchQuery.debug("fireItemsFound");
        SearchQuery.debug("  params: " + this.searchparams);
        SearchQuery.debug("  insearch: " + bl);
        SearchQuery.debug("  docs: " + vector);
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (searchEvent == null) {
                searchEvent = new SearchEvent(this, this.searchparams, bl, vector);
            }
            ((SearchListener)objectArray[i + 1]).itemsFound(searchEvent);
        }
    }

    protected void fireItemsFound(SearchEvent searchEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        Vector<SearchItem> vector = new Vector<SearchItem>();
        Object object = searchEvent.getSearchItems();
        while (object.hasMoreElements()) {
            vector.addElement((SearchItem)object.nextElement());
        }
        object = new SearchEvent(this, searchEvent.getParams(), searchEvent.isSearchCompleted(), vector);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            ((SearchListener)objectArray[i + 1]).itemsFound((SearchEvent)object);
        }
    }

    protected void fireSearchStarted() {
        SearchQuery.debug("fireSearchStarted");
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (searchEvent == null) {
                searchEvent = new SearchEvent(this, this.searchparams, true);
            }
            ((SearchListener)objectArray[i + 1]).searchStarted(searchEvent);
        }
    }

    protected void fireSearchFinished() {
        SearchQuery.debug("fireSearchFinished");
        Object[] objectArray = this.listenerList.getListenerList();
        SearchEvent searchEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (searchEvent == null) {
                searchEvent = new SearchEvent(this, this.searchparams, false);
            }
            ((SearchListener)objectArray[i + 1]).searchFinished(searchEvent);
        }
    }

    private static void debug(String string) {
    }
}

