/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.lib.URLEnvironment;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.netbeans.modules.xml.catalog.user.UserXMLCatalog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

final class CatalogEntryNode
extends BeanNode
implements EditCookie {
    private transient ViewCookie view;
    private boolean isCatalogWriter;
    private CatalogReader catalogReader;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl;

    public CatalogEntryNode(CatalogEntry catalogEntry) throws IntrospectionException {
        super((Object)catalogEntry);
        this.catalogReader = catalogEntry.getCatalog();
        if (this.catalogReader instanceof CatalogWriter) {
            this.isCatalogWriter = true;
        }
    }

    public Action getPreferredAction() {
        if (this.isCatalogWriter) {
            return SystemAction.get((Class)EditAction.class);
        }
        return SystemAction.get((Class)ViewAction.class);
    }

    public void edit() {
        UserXMLCatalog userXMLCatalog = (UserXMLCatalog)this.getCatalogReader();
        try {
            DataObject dataObject;
            EditCookie editCookie;
            URI uRI = new URI(this.getSystemID());
            File file = new File(uRI);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            boolean bl = false;
            if (fileObject != null && (editCookie = (EditCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(EditCookie.class)) != null) {
                bl = true;
                editCookie.edit();
            }
            if (!bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_CannotOpenURI", this.getSystemID()), 1));
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public Action[] getActions(boolean bl) {
        if (this.isCatalogWriter) {
            return new Action[]{SystemAction.get((Class)EditAction.class), SystemAction.get((Class)DeleteAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get((Class)ViewAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (ViewCookie.class.equals(clazz)) {
            try {
                String string = this.getSystemID();
                if (string == null) {
                    return null;
                }
                if (this.view == null) {
                    URL uRL = new URL(string);
                    ViewEnv viewEnv = new ViewEnv(uRL);
                    this.view = new ViewCookieImpl(viewEnv);
                }
                return this.view;
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify(1, (Throwable)malformedURLException);
                return null;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify(1, (Throwable)iOException);
                return null;
            }
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getPublicID() {
        return ((CatalogEntry)this.getBean()).getPublicID();
    }

    private String getSystemID() {
        return ((CatalogEntry)this.getBean()).getSystemID();
    }

    public String getShortDescription() {
        return this.getSystemID();
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.isCatalogWriter) {
            CatalogWriter catalogWriter = (CatalogWriter)((Object)((CatalogEntry)this.getBean()).getCatalog());
            catalogWriter.registerCatalogEntry(this.getPublicID(), null);
        }
    }

    private class ViewCookieImpl
    extends CloneableEditorSupport
    implements ViewCookie {
        ViewCookieImpl(CloneableEditorSupport.Env env) {
            super(env);
        }

        protected String messageName() {
            return Util.THIS.getString("MSG_opened_entity", CatalogEntryNode.this.getPublicID());
        }

        protected String messageSave() {
            return Util.THIS.getString("MSG_ENTITY_SAVE", CatalogEntryNode.this.getPublicID());
        }

        protected String messageToolTip() {
            return Util.THIS.getString("MSG_ENTITY_TOOLTIP", CatalogEntryNode.this.getSystemID());
        }

        protected String messageOpening() {
            return Util.THIS.getString("MSG_ENTITY_OPENING", CatalogEntryNode.this.getPublicID());
        }

        protected String messageOpened() {
            return Util.THIS.getString("MSG_ENTITY_OPENED", CatalogEntryNode.this.getPublicID());
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableEditor cloneableEditor = super.createCloneableEditor();
            cloneableEditor.setActivatedNodes(new Node[]{CatalogEntryNode.this});
            return cloneableEditor;
        }

        private Object writeReplace() {
            return null;
        }
    }

    private class ViewEnv
    extends URLEnvironment {
        private static final long serialVersionUID = -5031004511063404433L;

        ViewEnv(URL uRL) {
            super(uRL);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ViewCookieImpl)CatalogEntryNode.this.getCookie(class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl == null ? (class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl = CatalogEntryNode.class$("org.netbeans.modules.xml.catalog.CatalogEntryNode$ViewCookieImpl")) : class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl);
        }
    }
}

