/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.AddCatalogEntryAction;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.RefreshAction;
import org.netbeans.modules.xml.catalog.Refreshable;
import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

final class CatalogNode
extends BeanNode
implements Refreshable,
PropertyChangeListener,
Node.Cookie {
    private CatalogReader catalog;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode;

    public CatalogNode(CatalogReader catalogReader) throws IntrospectionException {
        super((Object)catalogReader, (Children)new CatalogChildren(catalogReader));
        this.catalog = catalogReader;
        this.getCookieSet().add((Node.Cookie)this);
        if (catalogReader instanceof CatalogDescriptor) {
            CatalogDescriptor catalogDescriptor = (CatalogDescriptor)((Object)catalogReader);
            this.setSynchronizeName(false);
            this.setName(catalogDescriptor.getDisplayName());
            String string = catalogReader instanceof CatalogWriter ? "LBL_catalogReadWrite" : "LBL_catalogReadOnly";
            this.setDisplayName(Util.THIS.getString(string, catalogDescriptor.getDisplayName()));
            this.setShortDescription(catalogDescriptor.getShortDescription());
            this.fireIconChange();
            catalogDescriptor.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)catalogDescriptor));
        }
    }

    CatalogReader getCatalogReader() {
        return this.catalog;
    }

    public Action[] getActions(boolean bl) {
        if (this.catalog instanceof CatalogWriter) {
            return new Action[]{SystemAction.get((Class)AddCatalogEntryAction.class), SystemAction.get((Class)RefreshAction.class), SystemAction.get((Class)UnmountAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get((Class)RefreshAction.class), SystemAction.get((Class)UnmountAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public Image getIcon(int n) {
        Image image;
        if (this.catalog instanceof CatalogDescriptor && (image = ((CatalogDescriptor)((Object)this.catalog)).getIcon(n)) != null) {
            return image;
        }
        return super.getIcon(n);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void refresh() {
        this.catalog.refresh();
        ((CatalogChildren)this.getChildren()).reload();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        CatalogSettings catalogSettings = CatalogSettings.getDefault();
        catalogSettings.removeCatalog(this.catalog);
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug(propertyChangeEvent.toString());
        }
        if ("ca-name".equals(propertyChangeEvent.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting name: " + (String)propertyChangeEvent.getNewValue());
            }
            this.setName((String)propertyChangeEvent.getNewValue());
            this.setDisplayName((String)propertyChangeEvent.getNewValue());
        } else if ("ca-desc".equals(propertyChangeEvent.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting desc: " + (String)propertyChangeEvent.getNewValue());
            }
            this.setShortDescription((String)propertyChangeEvent.getNewValue());
        } else if ("ca-icon".equals(propertyChangeEvent.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Updating icon");
            }
            this.fireIconChange();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Reading Catalog node " + this);
        }
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Writing " + this);
        }
        objectOutputStream.defaultWriteObject();
    }

    public static class CatalogChildren
    extends Children.Keys {
        private CatalogReader peer;
        private CatalogListener catalogListener;
        private final TreeSet keys = new TreeSet();

        public CatalogChildren(CatalogReader catalogReader) {
            this.peer = catalogReader;
        }

        public void addNotify() {
            this.catalogListener = new Lis();
            try {
                this.peer.addCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.reload();
        }

        public void removeNotify() {
            try {
                this.peer.removeCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.keys.clear();
            this.setKeys(this.keys);
        }

        public Node[] createNodes(Object object) {
            try {
                CatalogEntry catalogEntry = new CatalogEntry((String)object, this.peer);
                return new Node[]{new CatalogEntryNode(catalogEntry)};
            }
            catch (IntrospectionException introspectionException) {
                return null;
            }
        }

        public void reload() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Reloading kids of " + this.peer + "...");
            }
            HashSet hashSet = new HashSet(this.keys);
            this.keys.clear();
            Iterator iterator = this.peer.getPublicIDs();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.keys.add(string);
                    if (!hashSet.contains(string)) continue;
                    this.refreshKey(string);
                }
            }
            this.setKeys(this.keys);
        }

        private class Lis
        implements CatalogListener {
            private Lis() {
            }

            public void notifyNew(String string) {
                CatalogChildren.this.keys.add(string);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyRemoved(String string) {
                CatalogChildren.this.keys.remove(string);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyUpdate(String string) {
                CatalogChildren.this.refreshKey(string);
            }

            public void notifyInvalidate() {
                CatalogChildren.this.reload();
            }
        }
    }

    private static final class UnmountAction
    extends NodeAction {
        private static final long serialVersionUID = 3556006276357785484L;

        public String getName() {
            return Util.THIS.getString("LBL_unmount");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction == null ? (class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction = CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode$UnmountAction")) : class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction);
        }

        protected boolean enable(Node[] nodeArray) {
            if (nodeArray.length > 0) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node = nodeArray[i];
                    Node.Cookie cookie = node.getCookie(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode") : class$org$netbeans$modules$xml$catalog$CatalogNode);
                    if (!(cookie instanceof CatalogNode)) continue;
                    CatalogReader catalogReader = (CatalogReader)((CatalogNode)cookie).getBean();
                    if (!CatalogSettings.getDefault().isRemovable(catalogReader)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void performAction(Node[] nodeArray) {
            if (!this.enable(nodeArray)) {
                return;
            }
            for (int i = 0; i < nodeArray.length; ++i) {
                try {
                    Node node = nodeArray[i];
                    CatalogNode catalogNode = (CatalogNode)node.getCookie(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode") : class$org$netbeans$modules$xml$catalog$CatalogNode);
                    catalogNode.destroy();
                    continue;
                }
                catch (IOException iOException) {
                    Util.THIS.debug("Cannot unmount XML entity catalog!", iOException);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }
}

