/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.netbeans.modules.xml.catalog.impl.AbstractCatalog;
import org.netbeans.modules.xml.catalog.impl.Util;
import org.netbeans.modules.xml.catalog.lib.Categorizer;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XCatalog
extends AbstractCatalog
implements CatalogReader,
CatalogDescriptor,
Serializable,
EntityResolver {
    private static final long serialVersionUID = 1582081L;
    public static final String DTD_PUBLIC_ID_4 = "-//DTD XMLCatalog//EN";
    static final String DTD = "xcatalog.dtd";
    static final String PUBLICID_ATT_4 = "PublicId";
    static final String SYSTEMID_ATT_4 = "SystemID";
    public static final String DTD_PUBLIC_ID_2 = "-//DTD XCatalog//EN";
    static final String XCATALOG_2 = "XMLCatalog";
    static final String VERSION_2 = "Version";
    static final String PUBLICID_ATT_2 = "PublicID";
    static final String SYSTEMID_ATT_2 = "SystemID";
    static final String MAP = "Map";
    static final String EXTEND = "Extend";
    static final String BASE = "Base";
    static final String DELEGATE = "Delegate";
    static final String REMAP = "Remap";
    static final String HREF_ATT = "HRef";
    private String catalogSrc = null;
    private transient String shortDescription;
    private transient Image icon;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.loadCatalog(this.catalogSrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCatalog(String string) {
        try {
            this.clearAll();
            if (string == null) {
                return;
            }
            new CatalogParser(new InputSource(string));
            this.updateShortDescription(this.catalogSrc);
            this.updateIcon(this.getDefaultIcon(0));
        }
        catch (SAXException sAXException) {
            this.handleLoadError(sAXException);
        }
        catch (IOException iOException) {
            this.handleLoadError(iOException);
        }
        finally {
            this.notifyInvalidate();
        }
    }

    private void handleLoadError(Exception exception) {
        this.updateShortDescription(exception.getLocalizedMessage());
        this.updateIcon(this.getDefaultErrorIcon(0));
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Can not read: " + this.shortDescription);
        }
    }

    private void updateShortDescription(String string) {
        String string2 = this.shortDescription;
        this.shortDescription = string;
        this.firePropertyChange("ca-desc", string2, this.shortDescription);
    }

    private void updateIcon(Image image) {
        Image image2 = this.icon;
        this.icon = image;
        this.firePropertyChange("ca-icon", image2, this.icon);
    }

    public void setSource(String string) {
        this.catalogSrc = string;
        this.loadCatalog(string);
        this.firePropertyChange("ca-name", null, this.getDisplayName());
    }

    public String getSource() {
        return this.catalogSrc;
    }

    public void refresh() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Refreshing catalog...impl...");
        }
        this.loadCatalog(this.getSource());
    }

    public String getDisplayName() {
        String string = this.catalogSrc;
        if (string == null || "".equals(string.trim())) {
            return Util.THIS.getString("PROP_missing_location");
        }
        return Util.THIS.getString("PROP_display_name", this.catalogSrc);
    }

    public Image getIcon(int n) {
        return this.icon;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String toString() {
        return super.toString() + ":" + this.catalogSrc;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string3;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("resolveEntity(\"" + string + "\", \"" + string2 + "\")");
        }
        if (string != null) {
            string3 = this.getPublicMapping(string);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("  map: \"" + string + "\" -> \"" + string3 + "\"");
            }
            if (string3 != null) {
                InputSource inputSource = this.resolveEntity(null, string3);
                if (inputSource == null) {
                    inputSource = new InputSource(string3);
                }
                inputSource.setPublicId(string);
                return inputSource;
            }
            object3 = this.getDelegateCatalogKeys();
            while (object3.hasMoreElements()) {
                InputSource inputSource;
                object2 = (String)object3.nextElement();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("  delegate: \"" + (String)object2 + "\"");
                }
                if (!string.startsWith((String)object2) || (inputSource = ((AbstractCatalog)(object = this.getDelegateCatalog((String)object2))).resolveEntity(string, string2)) == null) continue;
                return inputSource;
            }
        }
        if ((string3 = this.getSystemMapping(string2)) != null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("  remap: \"" + string2 + "\" -> \"" + string3 + "\"");
            }
            object3 = new InputSource(string3);
            ((InputSource)object3).setPublicId(string);
            return object3;
        }
        object3 = this.extenders.iterator();
        while (object3.hasNext()) {
            object2 = (XCatalog)object3.next();
            object = ((XCatalog)object2).resolveEntity(string, string2);
            if (object == null) continue;
            return object;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("  returning null!");
        }
        return null;
    }

    private class CatalogParser
    extends DefaultHandler {
        private String base;

        public CatalogParser(InputSource inputSource) throws SAXException, IOException {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)true);
            xMLReader.setEntityResolver(new Resolver());
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            this.setBase(inputSource.getSystemId());
            xMLReader.parse(inputSource);
        }

        private void setBase(String string) throws SAXException {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = string.lastIndexOf(47)) != -1) {
                string = string.substring(0, n + 1);
            }
            this.base = string;
        }

        public void fatalError(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void error(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (string3.equals(XCatalog.MAP)) {
                    String string4 = attributes.getValue(XCatalog.PUBLICID_ATT_4);
                    if (string4 == null) {
                        string4 = attributes.getValue(XCatalog.PUBLICID_ATT_2);
                    }
                    String string5 = attributes.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("MAP \"" + string4 + "\" \"" + string5 + "\"");
                    }
                    if (!Categorizer.isURL(string5)) {
                        string5 = this.base + string5;
                    }
                    if (string4 != null) {
                        XCatalog.this.addPublicMapping(string4, string5);
                    }
                } else if (string3.equals(XCatalog.DELEGATE)) {
                    String string6 = attributes.getValue(XCatalog.PUBLICID_ATT_4);
                    if (string6 == null) {
                        string6 = attributes.getValue(XCatalog.PUBLICID_ATT_2);
                    }
                    String string7 = attributes.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("DELEGATE \"" + string6 + "\" \"" + string7 + "\"");
                    }
                    if (!Categorizer.isURL(string7)) {
                        string7 = this.base + string7;
                    }
                    String string8 = string7;
                    XCatalog xCatalog = new XCatalog();
                    xCatalog.loadCatalog(string8);
                    XCatalog.this.addDelegateCatalog(string6, xCatalog);
                } else if (string3.equals(XCatalog.EXTEND)) {
                    String string9 = attributes.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("EXTEND \"" + string9 + "\"");
                    }
                    if (!Categorizer.isURL(string9)) {
                        string9 = this.base + string9;
                    }
                    String string10 = string9;
                    XCatalog xCatalog = new XCatalog();
                    xCatalog.loadCatalog(string10);
                    XCatalog.this.extenders.add(xCatalog);
                } else if (string3.equals(XCatalog.BASE)) {
                    String string11 = attributes.getValue(XCatalog.HREF_ATT);
                    if (string11 != null) {
                        this.base = string11;
                    }
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("BASE \"" + string11 + "\" -> \"" + this.base + "\"");
                    }
                } else if (string3.equals(XCatalog.REMAP)) {
                    String string12 = attributes.getValue("SystemID");
                    if (string12 == null) {
                        string12 = attributes.getValue("SystemID");
                    }
                    String string13 = attributes.getValue(XCatalog.HREF_ATT);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("REMAP \"" + string12 + "\" \"" + string13 + "\"");
                    }
                    if (!Categorizer.isURL(string13)) {
                        string13 = this.base + string13;
                    }
                    XCatalog.this.addSystemMapping(string12, string13);
                }
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }

        private class Resolver
        implements EntityResolver {
            private Resolver() {
            }

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                if (XCatalog.DTD_PUBLIC_ID_2.equals(string) || XCatalog.DTD_PUBLIC_ID_4.equals(string)) {
                    InputSource inputSource = new InputSource();
                    inputSource.setPublicId(string);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                    inputSource.setByteStream(byteArrayInputStream);
                    inputSource.setCharacterStream(new InputStreamReader((InputStream)byteArrayInputStream, "UTF8"));
                    return inputSource;
                }
                return null;
            }
        }
    }
}

