/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.classpath;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    private static WeakHashMap superProjectsCache = null;

    private static WeakHashMap getSuperProjectsCache() {
        if (superProjectsCache == null) {
            superProjectsCache = new WeakHashMap();
        }
        return superProjectsCache;
    }

    public static Set getSuperprojects(Project project) {
        ClassPath classPath;
        int n;
        HashSet<ClassPath> hashSet = (HashSet<ClassPath>)Util.getSuperProjectsCache().get(project);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet<ClassPath>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (n = 0; n < sourceGroupArray.length; ++n) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[n].getRootFolder(), (String)"classpath/source");
            hashSet2.addAll(Arrays.asList(classPath.getRoots()));
        }
        for (n = 0; n < projectArray.length; ++n) {
            classPath = projectArray[n];
            Sources sources2 = ProjectUtils.getSources((Project)classPath);
            SourceGroup[] sourceGroupArray2 = sources2.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray2.length; ++i) {
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)sourceGroupArray2[i].getRootFolder(), (String)"classpath/compile");
                List list = classPath2.entries();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    URL uRL = ((ClassPath.Entry)iterator.next()).getURL();
                    FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                    for (int j = 0; j < fileObjectArray.length; ++j) {
                        if (!hashSet2.contains(fileObjectArray[j])) continue;
                        hashSet.add(classPath);
                    }
                }
            }
        }
        Util.getSuperProjectsCache().put(project, hashSet);
        return hashSet;
    }

    static void resetCache() {
        superProjectsCache = null;
    }

    public static boolean isUnderSourceRootOfOpenProjects(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

