/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin {
    private WhereUsedQuery refactoring;
    private ClasspathInfo classPathInfo = null;

    public JavaWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
    }

    private ClasspathInfo getClasspathInfo(ClasspathInfo classpathInfo) {
        if (this.classPathInfo == null) {
            ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            FileObject fileObject = this.getSearchHandle().getFileObject();
            ClassPath classPath2 = RefactoringClassPathImplementation.getCustom(Collections.singleton(fileObject));
            this.classPathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)classPath2);
        }
        return this.classPathInfo;
    }

    private TreePathHandle getSearchHandle() {
        return (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    public Problem preCheck() {
        return null;
    }

    private Set<FileObject> getRelevantFiles(final TreePathHandle treePathHandle) {
        final ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        final ClassIndex classIndex = classpathInfo.getClassIndex();
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{treePathHandle.getFileObject()});
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                Object object;
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                hashSet.add(treePathHandle.getFileObject());
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element.getKind().isField()) {
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (element.getKind().isClass() || element.getKind().isInterface()) {
                    if (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly()) {
                        if (JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly()) {
                            object = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element)), (Set)object, EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        } else {
                            hashSet.addAll(JavaWhereUsedQueryPlugin.this.getImplementorsRecursive(classIndex, classpathInfo, (TypeElement)element));
                        }
                    } else {
                        hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                } else if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                    object = (TypeElement)element.getEnclosingElement();
                    hashSet.addAll(JavaWhereUsedQueryPlugin.this.getImplementorsRecursive(classIndex, classpathInfo, (TypeElement)object));
                }
                if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                    object = classIndex.getElements(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ElementHandle elementHandle = (ElementHandle)iterator.next();
                        TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                        if (typeElement == null) continue;
                        for (Element element2 : typeElement.getEnclosedElements()) {
                            if (!(element2 instanceof ExecutableElement) || !compilationController.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, typeElement)) continue;
                            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        }
                    }
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (element.getKind() == ElementKind.CONSTRUCTOR) {
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                }
            }
        };
        try {
            javaSource.runUserActionTask((CancellableTask)cancellableTask, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return hashSet;
    }

    private Set<FileObject> getImplementorsRecursive(ClassIndex classIndex, ClasspathInfo classpathInfo, TypeElement typeElement) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        LinkedList linkedList = new LinkedList(classIndex.getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        HashSet<ElementHandle> hashSet2 = new HashSet<ElementHandle>();
        while (!linkedList.isEmpty()) {
            ElementHandle elementHandle = (ElementHandle)linkedList.removeFirst();
            hashSet2.add(elementHandle);
            linkedList.addAll(classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        for (ElementHandle elementHandle : hashSet2) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
            assert (fileObject != null) : "issue 90196, Cannot find file for " + elementHandle + ". cpInfo=" + classpathInfo;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        this.refactoring.getContext().add((Object)this.getClasspathInfo(classpathInfo));
        Set<FileObject> set = this.getRelevantFiles(this.getSearchHandle());
        this.fireProgressListenerStart(1, set.size());
        this.processFiles(set, new FindTask(refactoringElementsBag));
        this.fireProgressListenerStop();
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.getSearchHandle().getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2) {
        if (!bl2 && !bl) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private volatile boolean cancelled;

        public FindTask(RefactoringElementsBag refactoringElementsBag) {
            this.elements = refactoringElementsBag;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            Object object;
            if (this.cancelled) {
                return;
            }
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            Element element = JavaWhereUsedQueryPlugin.this.getSearchHandle().resolveElement((CompilationInfo)workingCopy);
            assert (element != null);
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                object = new FindUsagesVisitor(workingCopy);
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((SearchVisitor)object).getUsages());
            }
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                object = new FindOverridingVisitor(workingCopy);
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((SearchVisitor)object).getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                object = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), workingCopy);
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((SearchVisitor)object).getUsages());
            }
            for (TreePath treePath : arrayList) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)workingCopy, treePath));
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }
    }
}

