/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameTransformer;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends JavaRefactoringPlugin {
    private TreePathHandle treePathHandle = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private FileObject originalFolder = null;
    private Set varNames;
    private RenameRefactoring refactoring;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        TreePathHandle treePathHandle = (TreePathHandle)renameRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            this.treePathHandle = treePathHandle;
        } else {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)((FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class)));
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        RenameRefactoringPlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                        RenameRefactoringPlugin.this.refactoring.getContext().add((Object)compilationController);
                    }
                }, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        CompilationInfo compilationInfo = (CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class);
        Element element = this.treePathHandle.resolveElement(compilationInfo);
        this.fireProgressListenerStart(1, 4);
        try {
            Problem problem = RenameRefactoringPlugin.isElementAvail(this.treePathHandle, compilationInfo);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
            if (FileUtil.getArchiveFile((FileObject)fileObject) != null) {
                Problem problem3 = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getCannotRename(fileObject));
                return problem3;
            }
            if (!RetoucheUtils.isElementInOpenProject(fileObject)) {
                Problem problem4 = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem4;
            }
            switch (element.getKind()) {
                case METHOD: {
                    this.fireProgressListenerStep();
                    this.fireProgressListenerStep();
                    this.overriddenByMethods = RetoucheUtils.getOverridingMethods((ExecutableElement)element, compilationInfo);
                    this.fireProgressListenerStep();
                    if (!this.overriddenByMethods.isEmpty()) {
                        String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element).getSimpleName().toString()});
                        problem = RenameRefactoringPlugin.createProblem(problem, false, string);
                    }
                    this.overridesMethods = RetoucheUtils.getOverridingMethods((ExecutableElement)this.treePathHandle.resolveElement(compilationInfo), compilationInfo);
                    this.fireProgressListenerStep();
                    if (this.overridesMethods.isEmpty()) break;
                    boolean bl = false;
                    for (ExecutableElement executableElement : this.overridesMethods) {
                        if (!RetoucheUtils.isFromLibrary(executableElement, compilationInfo.getClasspathInfo())) continue;
                        bl = true;
                        break;
                    }
                    String string = bl ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                    problem = RenameRefactoringPlugin.createProblem(problem, bl, string);
                    break;
                }
                case FIELD: 
                case ENUM_CONSTANT: {
                    this.fireProgressListenerStep();
                    this.fireProgressListenerStep();
                    Element element2 = this.hides(element, element.getSimpleName().toString(), compilationInfo);
                    this.fireProgressListenerStep();
                    this.fireProgressListenerStep();
                    if (element2 == null) break;
                    String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element)});
                    problem = RenameRefactoringPlugin.createProblem(problem, false, string);
                    break;
                }
                case PACKAGE: {
                    break;
                }
                case LOCAL_VARIABLE: {
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ANNOTATION_TYPE: 
                case ENUM: {
                    break;
                }
            }
            Problem problem5 = problem;
            return problem5;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private static final String getCannotRename(FileObject fileObject) {
        return new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_CannotRenameFile")).format(new Object[]{fileObject.getNameExt()});
    }

    public Problem fastCheckParameters() {
        CompilationInfo compilationInfo = (CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class);
        Element element = this.treePathHandle.resolveElement(compilationInfo);
        ElementKind elementKind = element.getKind();
        String string = this.refactoring.getNewName();
        Problem problem = null;
        String string2 = element.getSimpleName().toString();
        if (string2.equals(string)) {
            boolean bl = true;
            if (element.getKind().isClass()) {
                // empty if block
            }
            if (bl) {
                return RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            }
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string3 = elementKind == ElementKind.PACKAGE ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        if (elementKind.isClass()) {
            Object object;
            String string5;
            if (this.doCheckName) {
                TypeElement typeElement = (TypeElement)element;
                string5 = typeElement.getQualifiedName().toString();
                object = string5.substring(0, string5.lastIndexOf(typeElement.getSimpleName().toString()));
                String string6 = typeElement.getQualifiedName().toString();
                int n = string6.indexOf(46);
                string6 = n >= 0 ? string6.substring(0, n) : "";
                String string7 = "".equals(string6) ? string : string6 + '.' + string;
                FileObject fileObject = this.treePathHandle.getFileObject();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (compilationInfo.getElements().getTypeElement((CharSequence)object) != null) {
                    String string8 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, string6});
                    return RenameRefactoringPlugin.createProblem(problem, true, string8);
                }
            }
            FileObject fileObject = this.treePathHandle.getFileObject();
            string5 = fileObject.getParent();
            object = string5.getChildren();
            for (int i = 0; i < ((FileObject[])object).length; ++i) {
                if (object[i] == fileObject || object[i].isVirtual() || !object[i].getName().equals(string) || !"java".equals(object[i].getExt())) continue;
                String string9 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, string5.getPath()});
                problem = RenameRefactoringPlugin.createProblem(problem, true, string9);
                break;
            }
            if (elementKind == ElementKind.LOCAL_VARIABLE || elementKind == ElementKind.PARAMETER) {
                // empty if block
            }
            if (!elementKind.isField()) {
                if (elementKind == ElementKind.METHOD) {
                    // empty if block
                }
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        int n = 0;
        if (this.overriddenByMethods != null) {
            n += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            n += this.overridesMethods.size();
        }
        CompilationInfo compilationInfo = (CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class);
        Element element = this.treePathHandle.resolveElement(compilationInfo);
        Element element2 = null;
        this.fireProgressListenerStart(2, 8 + 3 * n);
        try {
            Element element3;
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            if (element.getKind() == ElementKind.METHOD) {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
            } else if (element.getKind().isField()) {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                element3 = this.hides(element, this.refactoring.getNewName(), compilationInfo);
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (element3 != null) {
                    String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element).toString()});
                    element2 = RenameRefactoringPlugin.createProblem((Problem)element2, false, string);
                }
            }
            element3 = element2;
            return element3;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private Set<FileObject> getRelevantFiles(CompilationInfo compilationInfo, Element element) {
        ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.add(SourceUtils.getFile((Element)element, (ClasspathInfo)classpathInfo));
        if (element.getKind().isField()) {
            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        } else if (element instanceof TypeElement) {
            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        } else if (element.getKind() == ElementKind.METHOD) {
            Set set = classIndex.getElements(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle elementHandle : set) {
                TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationInfo);
                if (typeElement == null) continue;
                for (Element element2 : typeElement.getEnclosedElements()) {
                    if (!(element2 instanceof ExecutableElement) || !compilationInfo.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, typeElement)) continue;
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                }
            }
            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        return hashSet;
    }

    private ClasspathInfo getClasspathInfo(CompilationInfo compilationInfo) {
        ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
        FileObject fileObject = this.treePathHandle.getFileObject();
        ClassPath classPath2 = RefactoringClassPathImplementation.getCustom(Collections.singleton(fileObject));
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)classPath2);
        return classpathInfo;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        ClasspathInfo classpathInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        CompilationInfo compilationInfo = (CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class);
        Element element = this.treePathHandle.resolveElement(compilationInfo);
        if (classpathInfo == null) {
            classpathInfo = this.getClasspathInfo(compilationInfo);
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        Set<FileObject> set = this.getRelevantFiles(compilationInfo, element);
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            Collection<ModificationResult> collection = this.processFiles(set, new FindTask(refactoringElementsBag, element));
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        String string = difference.getOldText();
                        if (string == null) continue;
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    private Element hides(Element element, String string, CompilationInfo compilationInfo) {
        TypeElement typeElement = SourceUtils.getEnclosingTypeElement((Element)element);
        Types types = compilationInfo.getTypes();
        Elements elements = compilationInfo.getElements();
        typeElement = (TypeElement)types.asElement(typeElement.getSuperclass());
        while (typeElement != null) {
            for (Element element2 : compilationInfo.getElements().getAllMembers(typeElement)) {
                if (!elements.hides(element2, element)) continue;
                return element2;
            }
            typeElement = (TypeElement)types.asElement(typeElement.getSuperclass());
        }
        return null;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private Element element;

        public FindTask(RefactoringElementsBag refactoringElementsBag, Element element) {
            this.elements = refactoringElementsBag;
            this.element = element;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            Element element = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)workingCopy);
            assert (element != null);
            RenameTransformer renameTransformer = new RenameTransformer(RenameRefactoringPlugin.this.refactoring.getNewName(), workingCopy);
            renameTransformer.scan(workingCopy.getCompilationUnit(), element);
            for (TreePath treePath : renameTransformer.getUsages()) {
                ElementGripFactory.getDefault().put(workingCopy.getFileObject(), treePath, (CompilationInfo)workingCopy);
            }
            RenameRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

