/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.swing.Action;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.DeleteTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class SafeDeleteRefactoringPlugin
extends JavaRefactoringPlugin {
    private SafeDeleteRefactoring refactoring;
    private WhereUsedQuery[] whereUsedQueries;
    private ArrayList<TreePathHandle> grips = new ArrayList();

    public SafeDeleteRefactoringPlugin(SafeDeleteRefactoring safeDeleteRefactoring) {
        this.refactoring = safeDeleteRefactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        ElementGrip elementGrip2;
        Iterator iterator;
        RefactoringSession refactoringSession = RefactoringSession.create((String)"delete");
        HashSet hashSet = new HashSet();
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            iterator = this.whereUsedQueries[i].getRefactoringSource().lookup(Object.class);
            hashSet.add(iterator);
            this.whereUsedQueries[i].prepare(refactoringSession);
            elementGrip2 = JavaSource.forFileObject((FileObject)this.grips.get(i).getFileObject());
            try {
                ModificationResult modificationResult = elementGrip2.runModificationTask(new FindTask(refactoringElementsBag, this.grips.get(i)));
                refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(Collections.singleton(modificationResult)));
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.fireProgressListenerStep();
        }
        ArrayList arrayList = new ArrayList();
        iterator = refactoringSession.getRefactoringElements().iterator();
        while (iterator.hasNext()) {
            elementGrip2 = (ElementGrip)((DiffElement)((Object)iterator.next())).getLookup().lookup(ElementGrip.class);
            boolean bl = true;
            if (!bl) continue;
            this.fireProgressListenerStop();
            return new Problem(false, SafeDeleteRefactoringPlugin.getString("ERR_ReferencesFound"), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen(new WhereUsedQueryUI(elementGrip2.getHandle(), "!!!TODO!!!", (AbstractRefactoring)this.refactoring), refactoringSession)));
        }
        if (arrayList.size() > 0) {
            for (ElementGrip elementGrip2 : arrayList) {
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elementGrip2);
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        this.grips.clear();
        final ArrayList arrayList = new ArrayList();
        for (FileObject fileObject : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        for (Tree tree : compilationUnitTree.getTypeDecls()) {
                            SafeDeleteRefactoringPlugin.this.grips.add(TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, tree), (CompilationInfo)compilationController));
                        }
                        arrayList.add(compilationController.getClasspathInfo());
                    }
                }, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.grips.addAll(this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        this.whereUsedQueries = new WhereUsedQuery[this.grips.size()];
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            if (!arrayList.isEmpty()) {
                this.refactoring.getContext().add(arrayList.get(i));
            }
            this.whereUsedQueries[i] = this.createQuery(this.grips.get(i));
            this.whereUsedQueries[i].putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.refactoring.isCheckInComments());
            if (!Tree.Kind.METHOD.equals((Object)this.grips.get(i).getKind())) continue;
            this.whereUsedQueries[i].putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)true);
        }
        Problem problem = null;
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            problem = this.whereUsedQueries[i].checkParameters();
            if (problem == null) continue;
            return problem;
        }
        return null;
    }

    private WhereUsedQuery createQuery(TreePathHandle treePathHandle) {
        WhereUsedQuery whereUsedQuery = new WhereUsedQuery(Lookups.singleton((Object)treePathHandle));
        for (Object e : this.refactoring.getContext().lookupAll(Object.class)) {
            whereUsedQuery.getContext().add(e);
        }
        return whereUsedQuery;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)string);
    }

    private Problem getProblemMessage(Object object) {
        String string = NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDelProblem", (Object)object);
        return new Problem(true, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private TreePathHandle jmiObject;

        public FindTask(RefactoringElementsBag refactoringElementsBag, TreePathHandle treePathHandle) {
            this.elements = refactoringElementsBag;
            this.jmiObject = treePathHandle;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            Element element = this.jmiObject.resolveElement((CompilationInfo)workingCopy);
            assert (element != null);
            DeleteTransformer deleteTransformer = new DeleteTransformer(workingCopy);
            deleteTransformer.scan(workingCopy.getCompilationUnit(), element);
            for (TreePath treePath : deleteTransformer.getUsages()) {
                ElementGripFactory.getDefault().put(workingCopy.getFileObject(), treePath, (CompilationInfo)workingCopy);
            }
        }
    }

    private static class ImportRefDeleteElement
    extends SimpleRefactoringElementImplementation {
        private final String text = "todo";

        private ImportRefDeleteElement() {
        }

        public String getText() {
            return "todo";
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return null;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI refactoringUI, RefactoringSession refactoringSession) {
            this.ui = refactoringUI;
            this.rs = refactoringSession;
        }

        public void showDetails(Action action, Cancellable cancellable) {
            cancellable.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)action);
        }

        public String getDetailsHint() {
            return SafeDeleteRefactoringPlugin.getString("LBL_ShowUsages");
        }
    }
}

