/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.util.Collection;
import java.util.Dictionary;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.spi.ui.JavaActionsImplementationProvider;
import org.netbeans.modules.refactoring.java.ui.ExtractInterfaceRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.PullUpRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.PushDownRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class JavaRefactoringActionsProvider
extends JavaActionsImplementationProvider {
    public void doExtractInterface(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new RefactoringActionsProvider.TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    return new ExtractInterfaceRefactoringUI(treePathHandle, compilationInfo);
                }
            }.run();
        } else {
            new RefactoringActionsProvider.NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    throw new UnsupportedOperationException("Not supported yet!");
                }
            }.run();
        }
    }

    public boolean canExtractInterface(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fileObject)) {
            return true;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    public void doPushDown(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new RefactoringActionsProvider.TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    return new PushDownRefactoringUI(new TreePathHandle[]{treePathHandle}, compilationInfo);
                }
            }.run();
        } else {
            new RefactoringActionsProvider.NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    throw new UnsupportedOperationException("Not supported yet!");
                }
            }.run();
        }
    }

    public boolean canPushDown(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fileObject)) {
            return true;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }

    public void doPullUp(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        if (RefactoringActionsProvider.isFromEditor(editorCookie)) {
            new RefactoringActionsProvider.TextComponentRunnable(editorCookie){

                protected RefactoringUI createRefactoringUI(TreePathHandle treePathHandle, int n, int n2, CompilationInfo compilationInfo) {
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    return new PullUpRefactoringUI(new TreePathHandle[]{treePathHandle}, compilationInfo);
                }
            }.run();
        } else {
            new RefactoringActionsProvider.NodeToFileObject(lookup.lookupAll(Node.class)){

                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    throw new UnsupportedOperationException("Not supported yet!");
                }
            }.run();
        }
    }

    public boolean canPullUp(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isRefactorable(fileObject)) {
            return true;
        }
        return dataObject instanceof DataFolder && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject) && !RetoucheUtils.isClasspathRoot(fileObject);
    }
}

