/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.text.MessageFormat;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private TreePathHandle jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    public RenameRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        this.jmiObject = treePathHandle;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)treePathHandle));
        this.oldName = treePathHandle.resolveElement(compilationInfo).getSimpleName().toString();
        this.refactoring.getContext().add((Object)compilationInfo);
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(FileObject fileObject) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)fileObject));
        this.dispOldName = this.oldName = fileObject.getName();
    }

    public RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        this.dispOldName = this.oldName = RetoucheUtils.getPackageName(nonRecursiveFolder.getFolder());
        this.pkgRename = true;
    }

    RenameRefactoringUI(FileObject fileObject, String string) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)fileObject));
        this.oldName = string;
        this.dispOldName = string;
        this.fromListener = true;
    }

    RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder, String string) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        this.oldName = string;
        this.dispOldName = string;
        this.fromListener = true;
        this.pkgRename = true;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.oldName;
            String string2 = "";
            if (this.jmiObject != null) {
                Element element = this.jmiObject.resolveElement((CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class));
                if (element instanceof TypeElement) {
                    string2 = element.getKind().isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
                } else if (element.getKind() == ElementKind.METHOD) {
                    string2 = RenameRefactoringUI.getString("LBL_Method");
                } else if (element.getKind() == ElementKind.FIELD) {
                    string2 = RenameRefactoringUI.getString("LBL_Field");
                } else if (element.getKind() == ElementKind.LOCAL_VARIABLE) {
                    string2 = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (element.getKind() == ElementKind.PACKAGE || element == null && this.fromListener) {
                    string2 = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (element.getKind() == ElementKind.PARAMETER) {
                    string2 = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            string2 = string2 + " " + string;
            this.panel = new RenamePanel(string, changeListener, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + string2, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)string);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        ElementKind elementKind = this.jmiObject.resolveElement((CompilationInfo)this.refactoring.getContext().lookup(CompilationInfo.class)).getKind();
        String string = elementKind == ElementKind.PACKAGE ? ".JavaPackage" : (elementKind.isClass() || elementKind.isInterface() ? ".JavaClass" : (elementKind == ElementKind.METHOD ? ".Method" : (elementKind.isField() ? ".Field" : "")));
        return new HelpCtx(RenameRefactoringUI.class.getName() + string);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object object = null;
        object = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        object.rename(this.panel.getNameValue());
    }
}

