/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient Collection elements;
    private final transient SafeDeleteRefactoring refactoring;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel jPanel3;
    private JLabel label;
    private JCheckBox searchInComments;

    public SafeDeletePanel(SafeDeleteRefactoring safeDeleteRefactoring, Collection collection) {
        this.setName(NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel"));
        this.elements = collection;
        this.refactoring = safeDeleteRefactoring;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    public void initialize() {
        this.searchInComments.setEnabled(true);
        if (this.initialized) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : this.refactoring.getRefactoringSource().lookupAll(Object.class)) {
            if (e instanceof FileObject) {
                arrayList.add(((FileObject)e).getName());
                continue;
            }
            if (!(e instanceof TreePathHandle)) continue;
            final TreePathHandle treePathHandle = (TreePathHandle)e;
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            try {
                javaSource.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        arrayList.add(treePathHandle.resolveElement((CompilationInfo)compilationController).getSimpleName().toString());
                    }
                }, true);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (arrayList.size() == 1) {
                    SafeDeletePanel.this.label.setText(NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDelHeader", arrayList.get(0)));
                } else {
                    SafeDeletePanel.this.label.setText(NbBundle.getMessage(SafeDeletePanel.class, (String)"LBL_SafeDel_Elements", arrayList.get(0), arrayList.get(1)));
                }
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.label, "North");
        this.searchInComments.setSelected((Boolean)RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)resourceBundle.getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.jPanel3.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.jPanel3, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", bl);
        this.refactoring.setCheckInComments(bl.booleanValue());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 30, dimension.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

