/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FolderTreeElement
implements TreeElement {
    private FileObject fo;

    FolderTreeElement(FileObject fileObject) {
        this.fo = fileObject;
    }

    public TreeElement getParent(boolean bl) {
        if (bl) {
            SourceGroup sourceGroup = FolderTreeElement.getSourceGroup(this.fo);
            if (sourceGroup != null) {
                return TreeElementFactory.getTreeElement((Object)sourceGroup);
            }
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (project != null) {
            return TreeElementFactory.getTreeElement((Object)project);
        }
        return null;
    }

    public Icon getIcon() {
        return UiUtils.getElementIcon((ElementKind)ElementKind.PACKAGE, null);
    }

    public String getText(boolean bl) {
        return ClassPath.getClassPath((FileObject)this.fo, (String)"classpath/source").getResourceName(this.fo).replace('/', '.');
    }

    static SourceGroup getSourceGroup(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    public Object getUserObject() {
        return this.fo;
    }
}

