/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

public final class CharSequenceUtilities {
    private CharSequenceUtilities() {
    }

    public static int stringLikeHashCode(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + charSequence.charAt(i);
        }
        return n2;
    }

    public static boolean equals(CharSequence charSequence, Object object) {
        if (charSequence == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence2 = (CharSequence)object;
            int n = charSequence.length();
            if (n == charSequence2.length()) {
                for (int i = n - 1; i >= 0; --i) {
                    if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean textEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        int n = charSequence.length();
        if (n == charSequence2.length()) {
            for (int i = n - 1; i >= 0; --i) {
                if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String toString(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        stringBuilder.append(charSequence);
        return stringBuilder.toString();
    }

    public static String toString(CharSequence charSequence, int n, int n2) {
        CharSequenceUtilities.checkIndexesValid(charSequence, n, n2);
        StringBuilder stringBuilder = new StringBuilder(n2 - n);
        stringBuilder.append(charSequence, n, n2);
        return stringBuilder.toString();
    }

    public static void append(StringBuffer stringBuffer, CharSequence charSequence) {
        stringBuffer.append(charSequence);
    }

    public static void append(StringBuffer stringBuffer, CharSequence charSequence, int n, int n2) {
        CharSequenceUtilities.checkIndexesValid(charSequence, n, n2);
        while (n < n2) {
            stringBuffer.append(charSequence.charAt(n++));
        }
    }

    public static int indexOf(CharSequence charSequence, int n) {
        return CharSequenceUtilities.indexOf(charSequence, n, 0);
    }

    public static int indexOf(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        while (n2 < n3) {
            if (charSequence.charAt(n2) == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequenceUtilities.indexOf(charSequence, charSequence2, 0);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 == 0) {
            return n;
        }
        char c = charSequence2.charAt(0);
        int n4 = n2 - n3;
        for (int i = n; i <= n4; ++i) {
            if (charSequence.charAt(i) != c) {
                while (++i <= n4 && charSequence.charAt(i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            while (n5 < n6 && charSequence.charAt(n5) == charSequence2.charAt(n7)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2) {
        return CharSequenceUtilities.lastIndexOf(charSequence, charSequence2, charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2;
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        int n5 = n3 - n4;
        if (n < 0) {
            return -1;
        }
        if (n > n5) {
            n = n5;
        }
        if (n4 == 0) {
            return n;
        }
        int n6 = n4 - 1;
        char c = charSequence2.charAt(n6);
        int n7 = n4 - 1;
        int n8 = n7 + n;
        block0: while (true) {
            if (n8 >= n7 && charSequence.charAt(n8) != c) {
                --n8;
                continue;
            }
            if (n8 < n7) {
                return -1;
            }
            int n9 = n8 - 1;
            n2 = n9 - (n4 - 1);
            int n10 = n6 - 1;
            while (n9 > n2) {
                if (charSequence.charAt(n9--) == charSequence2.charAt(n10--)) continue;
                --n8;
                continue block0;
            }
            break;
        }
        return n2 + 1;
    }

    public static int lastIndexOf(CharSequence charSequence, int n) {
        return CharSequenceUtilities.lastIndexOf(charSequence, n, charSequence.length() - 1);
    }

    public static int lastIndexOf(CharSequence charSequence, int n, int n2) {
        if (n2 > charSequence.length() - 1) {
            n2 = charSequence.length() - 1;
        }
        while (n2 >= 0) {
            if (charSequence.charAt(n2) == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence2.length();
        if (n > charSequence.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        int n2 = charSequence2.length();
        if (n2 > (n = charSequence.length())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (charSequence.charAt(n - n2 + i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = n2 - 1;
        for (n = 0; n < n2 && charSequence.charAt(n) <= ' '; ++n) {
        }
        if (n == n2) {
            return charSequence.subSequence(0, 0);
        }
        while (n3 > n && charSequence.charAt(n3) <= ' ') {
            --n3;
        }
        return charSequence.subSequence(n, n3 + 1);
    }

    public static void debugChar(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            default: {
                stringBuffer.append(c);
            }
        }
    }

    public static void debugChar(StringBuilder stringBuilder, char c) {
        switch (c) {
            case '\n': {
                stringBuilder.append("\\n");
                break;
            }
            case '\r': {
                stringBuilder.append("\\r");
                break;
            }
            case '\t': {
                stringBuilder.append("\\t");
                break;
            }
            case '\b': {
                stringBuilder.append("\\b");
                break;
            }
            case '\f': {
                stringBuilder.append("\\f");
                break;
            }
            case '\\': {
                stringBuilder.append("\\\\");
                break;
            }
            default: {
                stringBuilder.append(c);
            }
        }
    }

    public static String debugChar(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        CharSequenceUtilities.debugChar(stringBuilder, c);
        return stringBuilder.toString();
    }

    public static void debugText(StringBuffer stringBuffer, CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            CharSequenceUtilities.debugChar(stringBuffer, charSequence.charAt(i));
        }
    }

    public static void debugText(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            CharSequenceUtilities.debugChar(stringBuilder, charSequence.charAt(i));
        }
    }

    public static String debugText(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        CharSequenceUtilities.debugText(stringBuilder, charSequence);
        return stringBuilder.toString();
    }

    public static void checkIndexNonNegative(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index=" + n + " < 0");
        }
    }

    public static void checkIndexValid(int n, int n2) {
        CharSequenceUtilities.checkIndexNonNegative(n);
        if (n >= n2) {
            throw new IndexOutOfBoundsException("index=" + n + " >= length()=" + n2);
        }
    }

    public static void checkIndexesValid(CharSequence charSequence, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n + " < 0");
        }
        if (n2 < n) {
            throw new IndexOutOfBoundsException("end=" + n2 + " < start=" + n);
        }
        if (n2 > charSequence.length()) {
            throw new IndexOutOfBoundsException("end=" + n2 + " > text.length()=" + charSequence.length());
        }
    }
}

