/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.GuardedDocumentEvent;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;

public class GuardedDocument
extends BaseDocument
implements StyledDocument {
    public static final String GUARDED_ATTRIBUTE = "guarded";
    public static final SimpleAttributeSet guardedSet = new SimpleAttributeSet();
    public static final SimpleAttributeSet unguardedSet = new SimpleAttributeSet();
    private static final boolean debugAtomic = Boolean.getBoolean("netbeans.debug.editor.atomic");
    private static final boolean debugAtomicStack = Boolean.getBoolean("netbeans.debug.editor.atomic.stack");
    public static final String FMT_GUARDED_INSERT_LOCALE = "FMT_guarded_insert";
    public static final String FMT_GUARDED_REMOVE_LOCALE = "FMT_guarded_remove";
    MarkBlockChain guardedBlockChain;
    boolean breakGuarded;
    boolean atomicAsUser;
    protected StyleContext styles;
    protected Hashtable stylesToLayers;
    protected String normalStyleName;

    public GuardedDocument(Class clazz) {
        this(clazz, true, new StyleContext());
    }

    public GuardedDocument(Class clazz, boolean bl, StyleContext styleContext) {
        super(clazz, bl);
        this.styles = styleContext;
        this.stylesToLayers = new Hashtable(5);
        this.guardedBlockChain = new MarkBlockChain(this){

            protected Mark createBlockStartMark() {
                MarkFactory.ContextMark contextMark = new MarkFactory.ContextMark(Position.Bias.Forward, false);
                return contextMark;
            }

            protected Mark createBlockEndMark() {
                MarkFactory.ContextMark contextMark = new MarkFactory.ContextMark(Position.Bias.Backward, false);
                return contextMark;
            }
        };
    }

    public MarkBlockChain getGuardedBlockChain() {
        return this.guardedBlockChain;
    }

    public boolean isPosGuarded(int n) {
        int n2 = this.guardedBlockChain.compareBlock(n, n) & 0xFFFFFFF3;
        return n2 == 1057 || n2 == 4129;
    }

    protected void preInsertCheck(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.preInsertCheck(n, string, attributeSet);
        int n2 = this.guardedBlockChain.compareBlock(n, n) & 0xFFFFFFF3;
        if (debugAtomic) {
            System.err.println("GuardedDocument.beforeInsertUpdate() atomicAsUser=" + this.atomicAsUser + ", breakGuarded=" + this.breakGuarded + ", inserting text='" + EditorDebug.debugString(string) + "' at offset=" + Utilities.debugPosition(this, n));
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        if (!(string.length() <= 0 || (n2 & 1) == 0 || n2 == 2081 || string.charAt(string.length() - 1) == '\n' && n2 == 1057 || this.breakGuarded && !this.atomicAsUser)) {
            throw new GuardedException(MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString(FMT_GUARDED_INSERT_LOCALE), new Integer(n)), n);
        }
    }

    protected void preRemoveCheck(int n, int n2) throws BadLocationException {
        int n3 = this.guardedBlockChain.compareBlock(n, n + n2);
        if (debugAtomic) {
            System.err.println("GuardedDocument.beforeRemoveUpdate() atomicAsUser=" + this.atomicAsUser + ", breakGuarded=" + this.breakGuarded + ", removing text='" + EditorDebug.debugChars(this.getChars(n, n2)) + "'at offset=" + Utilities.debugPosition(this, n));
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        if (((n3 & 1) != 0 || n3 == 66 && n != 0 && this.getChars(n - 1, 1)[0] != '\n') && (!this.breakGuarded || this.atomicAsUser)) {
            throw new GuardedException(MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString(FMT_GUARDED_REMOVE_LOCALE), new Integer(n)), n);
        }
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (((Boolean)attributeSet.getAttribute(GUARDED_ATTRIBUTE)).booleanValue()) {
            this.guardedBlockChain.addBlock(n, n + n2, false);
            this.fireChangedUpdate(this.createDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE));
        }
        if (!((Boolean)attributeSet.getAttribute(GUARDED_ATTRIBUTE)).booleanValue()) {
            this.guardedBlockChain.removeBlock(n, n + n2);
            this.fireChangedUpdate(this.createDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(Runnable runnable) {
        if (debugAtomic) {
            System.out.println("GuardedDocument.runAtomic() called");
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        boolean bl = false;
        this.atomicLock();
        boolean bl2 = this.breakGuarded;
        try {
            this.breakGuarded = true;
            runnable.run();
            bl = true;
        }
        finally {
            this.breakGuarded = bl2;
            try {
                if (!bl) {
                    this.breakAtomicLock();
                }
            }
            finally {
                this.atomicUnlock();
            }
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomic() finished");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicAsUser(Runnable runnable) {
        if (debugAtomic) {
            System.out.println("GuardedDocument.runAtomicAsUser() called");
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        boolean bl = false;
        this.atomicLock();
        boolean bl2 = this.atomicAsUser;
        try {
            this.atomicAsUser = true;
            runnable.run();
            bl = true;
        }
        finally {
            this.atomicAsUser = bl2;
            try {
                if (!bl) {
                    this.breakAtomicLock();
                }
            }
            finally {
                this.atomicUnlock();
            }
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomicAsUser() finished");
            }
        }
    }

    protected BaseDocumentEvent createDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
        return new GuardedDocumentEvent(this, n, n2, eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style addStyle(String string, Style style) {
        String string2 = (String)this.stylesToLayers.get(string);
        if (string2 == null) {
            string2 = string;
            this.addStyleToLayerMapping(string, string2);
        }
        Style style2 = this.styles.addStyle(string, style);
        if (this.findLayer(string2) == null) {
            try {
                this.extWriteLock();
                this.addStyledLayer(string2, style2);
            }
            finally {
                this.extWriteUnlock();
            }
        }
        return style2;
    }

    public void addStyleToLayerMapping(String string, String string2) {
        this.stylesToLayers.put(string, string2);
    }

    public void removeStyle(String string) {
        this.styles.removeStyle(string);
    }

    public Style getStyle(String string) {
        return this.styles.getStyle(string);
    }

    public void setNormalStyleName(String string) {
        this.normalStyleName = string;
    }

    public Enumeration getStyleNames() {
        return this.styles.getStyleNames();
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalStyle(int n, Style style) {
        try {
            this.extWriteLock();
            n = Utilities.getRowStart(this, n);
            String string = (String)this.stylesToLayers.get(style.getName());
            DrawLayer[] drawLayerArray = this.getDrawLayerList().currentLayers();
            for (int i = 0; i < drawLayerArray.length; ++i) {
                if (!(drawLayerArray[i] instanceof DrawLayerFactory.StyleLayer)) continue;
                ((DrawLayerFactory.StyleLayer)drawLayerArray[i]).markChain.removeMark(n);
            }
            DrawLayerFactory.StyleLayer styleLayer = (DrawLayerFactory.StyleLayer)this.findLayer(string);
            if (styleLayer != null) {
                styleLayer.markChain.addMark(n);
            }
            this.fireChangedUpdate(this.createDocumentEvent(n, 0, DocumentEvent.EventType.CHANGE));
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.extWriteUnlock();
        }
    }

    public Style getLogicalStyle(int n) {
        try {
            n = Utilities.getRowStart(this, n);
            DrawLayer[] drawLayerArray = this.getDrawLayerList().currentLayers();
            for (int i = 0; i < drawLayerArray.length; ++i) {
                DrawLayer drawLayer = drawLayerArray[i];
                if (!(drawLayer instanceof DrawLayerFactory.StyleLayer) || !((DrawLayerFactory.StyleLayer)drawLayer).markChain.isMark(n)) continue;
                return ((DrawLayerFactory.StyleLayer)drawLayer).style;
            }
            return this.getStyle(this.normalStyleName);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public Element getCharacterElement(int n) {
        return this.getParagraphElement(n);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return null;
    }

    public Color getBackground(AttributeSet attributeSet) {
        return null;
    }

    public Font getFont(AttributeSet attributeSet) {
        return new Font("Default", 1, 12);
    }

    protected DrawLayer addStyledLayer(String string, Style style) {
        if (string != null) {
            try {
                int n = string.indexOf(58);
                int n2 = Integer.parseInt(string.substring(n + 1));
                DrawLayerFactory.StyleLayer styleLayer = new DrawLayerFactory.StyleLayer(string, this, style);
                this.addLayer(styleLayer, n2);
                return styleLayer;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toStringDetail() {
        return super.toStringDetail() + this.getDrawLayerList() + ",\nGUARDED blocks:\n" + this.guardedBlockChain;
    }

    static {
        guardedSet.addAttribute(GUARDED_ATTRIBUTE, Boolean.TRUE);
        unguardedSet.addAttribute(GUARDED_ATTRIBUTE, Boolean.FALSE);
    }
}

