/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;
import org.openide.util.RequestProcessor;

public class Settings {
    private static final Logger LOG = Logger.getLogger(Settings.class.getName());
    public static final int CORE_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    public static final int EXTENSION_LEVEL = 2;
    public static final int OPTION_LEVEL = 3;
    public static final int USER_LEVEL = 4;
    private static final ArrayList initializerLists = new ArrayList();
    private static long initializerListsVersion = 0L;
    private static List[] listsOfInitializers = null;
    private static long listsOfInitializersVersion = -1L;
    private static InitializerSorter currentInitializerSorter;
    private static final Filter[] NULL_FILTERS;
    private static final String FILTERS_LOCK;
    private static volatile Filter[] filters;
    private static final Map kit2Maps;
    private static final WeakEventListenerList listenerList;
    private static final Map NULL_MAP;
    private static volatile boolean firingEnabled;
    private static final HashMap emptyMaps;
    private static final RequestProcessor PROCESSOR;
    private static final RequestProcessor.Task RESET_TASK;

    private Settings() {
    }

    public static void addInitializer(Initializer initializer) {
        Settings.addInitializer(initializer, 1);
        Settings.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializer(Initializer initializer, int n) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            int n2;
            for (int i = n2 = initializerLists.size(); i <= n; ++i) {
                initializerLists.add(new ArrayList());
            }
            ((List)initializerLists.get(n)).add(initializer);
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitializer(String string) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            Iterator iterator = initializerLists.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    if (!string.equals(((Initializer)iterator2.next()).getName())) continue;
                    iterator2.remove();
                }
            }
            if (currentInitializerSorter != null) {
                currentInitializerSorter.sort(initializerLists);
            }
            ++initializerListsVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitializerSorter getInitializerSorter() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            return currentInitializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitializerSorter(InitializerSorter initializerSorter) {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            currentInitializerSorter = initializerSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List[] getListsOfInitializers() {
        ArrayList arrayList = initializerLists;
        synchronized (arrayList) {
            if (listsOfInitializersVersion != initializerListsVersion) {
                List[] listArray = initializerLists.toArray(new List[initializerLists.size()]);
                for (int i = 0; i < listArray.length; ++i) {
                    listArray[i] = Collections.unmodifiableList(new ArrayList(listArray[i]));
                }
                listsOfInitializers = listArray;
                listsOfInitializersVersion = initializerListsVersion;
            }
            return listsOfInitializers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                filters = new Filter[]{filter};
            } else {
                Filter[] filterArray = new Filter[filters.length + 1];
                System.arraycopy(filters, 0, filterArray, 0, filters.length);
                filterArray[Settings.filters.length] = filter;
                filters = filterArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilter(Filter filter) {
        String string = FILTERS_LOCK;
        synchronized (string) {
            if (filters.length == 0) {
                return;
            }
            if (filters.length == 1 && filters[0] == filter) {
                filters = NULL_FILTERS;
            } else {
                int n = -1;
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] != filter) continue;
                    n = i;
                    break;
                }
                if (n != -1) {
                    Filter[] filterArray = new Filter[filters.length - 1];
                    System.arraycopy(filters, 0, filterArray, 0, n);
                    if (n < filterArray.length) {
                        System.arraycopy(filters, n + 1, filterArray, n, filterArray.length - n);
                    }
                    filters = filterArray;
                }
            }
        }
    }

    public static Object getValue(Class clazz, String string) {
        return Settings.getValue(clazz, string, true);
    }

    public static synchronized Object getValue(Class clazz, String string, boolean bl) {
        Filter[] filterArray;
        Object object = null;
        Class clazz2 = clazz;
        while (true) {
            if ((filterArray = Settings.getKitMap(clazz2, false)) != null) {
                object = filterArray.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) break;
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        filterArray = filters;
        for (int i = 0; i < filterArray.length; ++i) {
            object = filterArray[i].filterValue(clazz, string, object);
        }
        return object;
    }

    public static KitAndValue[] getValueHierarchy(Class clazz, String string) {
        return Settings.getValueHierarchy(clazz, string, true);
    }

    public static synchronized KitAndValue[] getValueHierarchy(Class clazz, String string, boolean bl) {
        Object object;
        KitAndValue[] kitAndValueArray;
        ArrayList<KitAndValue> arrayList = new ArrayList<KitAndValue>();
        Class clazz2 = clazz;
        while (true) {
            if ((kitAndValueArray = Settings.getKitMap(clazz2, false)) != null) {
                object = kitAndValueArray.get(string);
                if (bl && object instanceof Evaluator) {
                    object = ((Evaluator)object).getValue(clazz, string);
                }
                if (object != null) {
                    arrayList.add(new KitAndValue(clazz2, object));
                }
            }
            if (clazz2 == null) break;
            clazz2 = clazz2.getSuperclass();
        }
        kitAndValueArray = arrayList.toArray(new KitAndValue[arrayList.size()]);
        object = filters;
        for (int i = 0; i < ((V)object).length; ++i) {
            kitAndValueArray = object[i].filterValueHierarchy(clazz, string, kitAndValueArray);
        }
        return kitAndValueArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(Class clazz, String string, Object object) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(clazz, true);
            Object v = map.get(string);
            if (v == null && object == null || v != null && v.equals(object)) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            Settings.fireSettingsChange(clazz, string, v, object);
            return;
        }
    }

    public static void touchValue(Class clazz, String string) {
        Settings.fireSettingsChange(clazz, string, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateValue(Class clazz, String string, Object object) {
        Class<Settings> clazz2 = Settings.class;
        synchronized (Settings.class) {
            Map map = Settings.getKitMap(clazz, true);
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            for (Map.Entry entry : kit2Maps.entrySet()) {
                Class clazz3 = (Class)entry.getKey();
                if (clazz == clazz3 || clazz != null && !clazz.isAssignableFrom(clazz3)) continue;
                ((Map)entry.getValue()).remove(string);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Settings.fireSettingsChange(null, string, null, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Runnable runnable) {
        boolean bl = false;
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            boolean bl2 = firingEnabled;
            firingEnabled = false;
            try {
                runnable.run();
            }
            finally {
                if (bl2) {
                    firingEnabled = true;
                    bl = true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                Settings.fireSettingsChange(null, null, null, null);
            }
            return;
        }
    }

    public static void reset() {
        RESET_TASK.schedule(1);
    }

    public static String initializersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        List[] listArray = Settings.getListsOfInitializers();
        for (int i = 0; i < listArray.length; ++i) {
            switch (i) {
                case 0: {
                    stringBuffer.append("CORE_LEVEL");
                    break;
                }
                case 1: {
                    stringBuffer.append("SYSTEM_LEVEL");
                    break;
                }
                case 2: {
                    stringBuffer.append("EXTENSION_LEVEL");
                    break;
                }
                case 3: {
                    stringBuffer.append("OPTION_LEVEL");
                    break;
                }
                case 4: {
                    stringBuffer.append("USER_LEVEL");
                    break;
                }
                default: {
                    stringBuffer.append("level " + i);
                }
            }
            stringBuffer.append(":\n");
            stringBuffer.append(EditorDebug.debugList(listArray[i]));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static void addSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.add(SettingsChangeListener.class, settingsChangeListener);
    }

    public static void removeSettingsChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(SettingsChangeListener.class, settingsChangeListener);
    }

    private static void fireSettingsChange(Class clazz, String string, Object object, Object object2) {
        if (firingEnabled) {
            SettingsChangeListener[] settingsChangeListenerArray = (SettingsChangeListener[])listenerList.getListeners(SettingsChangeListener.class);
            SettingsChangeEvent settingsChangeEvent = new SettingsChangeEvent(Settings.class, clazz, string, object, object2);
            for (int i = 0; i < settingsChangeListenerArray.length; ++i) {
                settingsChangeListenerArray[i].settingsChange(settingsChangeEvent);
            }
        }
    }

    private static Map getKitMap(Class clazz, boolean bl) {
        Map map = (LoggingMap)kit2Maps.get(clazz);
        if (map == null) {
            LoggingMap loggingMap = (LoggingMap)emptyMaps.get(clazz);
            if (loggingMap != null) {
                return loggingMap;
            }
            if (loggingMap == null) {
                loggingMap = LOG.isLoggable(Level.FINE) ? new LoggingMap(clazz, Level.FINE) : new HashMap();
                emptyMaps.put(clazz, loggingMap);
            }
            List[] listArray = Settings.getListsOfInitializers();
            for (int i = 0; i < listArray.length; ++i) {
                for (Initializer initializer : listArray[i]) {
                    try {
                        initializer.updateSettingsMap(clazz, loggingMap);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, null, throwable);
                    }
                }
            }
            if (loggingMap.size() > 0) {
                map = loggingMap;
            }
            if (map == null) {
                map = NULL_MAP;
            }
            kit2Maps.put(clazz, map);
            emptyMaps.remove(clazz);
        }
        if (map == NULL_MAP) {
            if (!bl) {
                return null;
            }
            map = LOG.isLoggable(Level.FINE) ? new LoggingMap(clazz, Level.FINE) : new HashMap();
            kit2Maps.put(clazz, map);
        }
        return map;
    }

    static {
        NULL_FILTERS = new Filter[0];
        FILTERS_LOCK = new String("Settings.FILTERS_LOCK");
        filters = NULL_FILTERS;
        kit2Maps = new HashMap();
        listenerList = new WeakEventListenerList();
        NULL_MAP = new HashMap(1);
        firingEnabled = true;
        emptyMaps = new HashMap();
        PROCESSOR = new RequestProcessor("org.netbeans.editor.Settings.PROCESSOR");
        RESET_TASK = PROCESSOR.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<Settings> clazz = Settings.class;
                synchronized (Settings.class) {
                    kit2Maps.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Settings.fireSettingsChange(null, null, null, null);
                    return;
                }
            }
        });
    }

    public static abstract class AbstractInitializer
    implements Initializer {
        private String name;

        public AbstractInitializer(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static interface Evaluator {
        public Object getValue(Class var1, String var2);
    }

    public static interface Filter {
        public Object filterValue(Class var1, String var2, Object var3);

        public KitAndValue[] filterValueHierarchy(Class var1, String var2, KitAndValue[] var3);
    }

    public static abstract class FilterInitializerSorter {
        private InitializerSorter delegate;

        public FilterInitializerSorter(InitializerSorter initializerSorter) {
            this.delegate = initializerSorter;
        }

        public void sort(List list) {
            if (this.delegate != null) {
                this.delegate.sort(list);
            }
        }
    }

    public static interface Initializer {
        public String getName();

        public void updateSettingsMap(Class var1, Map var2);
    }

    public static interface InitializerSorter {
        public void sort(List var1);
    }

    public static class KitAndValue {
        public Class kitClass;
        public Object value;

        public KitAndValue(Class clazz, Object object) {
            this.kitClass = clazz;
            this.value = object;
        }
    }

    private static final class LoggingMap
    extends HashMap {
        private Class kitClass;
        private Level logLevel;

        public LoggingMap(Class clazz, Level level) {
            this.kitClass = clazz;
            this.logLevel = level;
        }

        public Object put(Object object, Object object2) {
            if (object != null && (object.equals("rendering-hints") || object.equals("textAntialiasing"))) {
                String string = "Settings map: put('" + object + "' to '" + object2 + "') for kitClass=" + this.kitClass;
                LOG.log(this.logLevel, string, new Throwable());
            }
            return super.put(object, object2);
        }
    }
}

