/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.AutoscrollSupport;
import org.netbeans.modules.palette.ui.CategoryButton;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class CategoryList
extends JList
implements Autoscroll {
    private int rolloverIndex = -1;
    private boolean showNames;
    static final int BASIC_ICONSIZE = 1;
    private int iconSize = 1;
    private Category category;
    private PalettePanel palettePanel;
    private static WeakReference<ListCellRenderer> rendererRef;
    private Item draggingItem;
    private AutoscrollSupport support;
    Integer tempWidth;

    CategoryList(Category category, PalettePanel palettePanel) {
        this.category = category;
        this.palettePanel = palettePanel;
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setVisibleRowCount(0);
        this.setSelectionMode(0);
        this.setCellRenderer(CategoryList.getItemRenderer());
        this.setLayoutOrientation(2);
        this.getAccessibleContext().setAccessibleName(category.getDisplayName());
        this.getAccessibleContext().setAccessibleDescription(category.getShortDescription());
        this.initActions();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "defaultAction");
        inputMap.put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("defaultAction", new DefaultAction(this));
        actionMap.put("popup", new PopupAction());
        actionMap.put("selectPreviousRow", new MoveFocusAction(actionMap.get("selectPreviousRow"), false));
        actionMap.put("selectNextRow", new MoveFocusAction(actionMap.get("selectNextRow"), true));
        actionMap.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectPreviousColumn"), false), false));
        actionMap.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectNextColumn"), true), true));
        Node node = (Node)this.category.getLookup().lookup(Node.class);
        if (null != node) {
            actionMap.put("paste", new Utils.PasteItemAction(node));
        } else {
            actionMap.remove("paste");
        }
        actionMap.put("copy", new CutCopyAction(true));
        actionMap.put("cut", new CutCopyAction(false));
    }

    Item getItemAt(int n) {
        if (n < 0 || n >= this.getModel().getSize()) {
            return null;
        }
        return (Item)this.getModel().getElementAt(n);
    }

    Category getCategory() {
        return this.category;
    }

    public void updateUI() {
        if (null != rendererRef) {
            rendererRef.clear();
        }
        this.setUI(new CategoryListUI());
        this.invalidate();
    }

    public int getWidth() {
        return this.tempWidth == null ? super.getWidth() : this.tempWidth.intValue();
    }

    boolean getShowNames() {
        return this.showNames;
    }

    void setShowNames(boolean bl) {
        if (bl != this.showNames) {
            this.showNames = bl;
            this.firePropertyChange("cellRenderer", null, null);
        }
    }

    int getIconSize() {
        return this.iconSize;
    }

    void setIconSize(int n) {
        if (n != this.iconSize) {
            this.iconSize = n;
            this.firePropertyChange("cellRenderer", null, null);
        }
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
            Rectangle rectangle2 = this.getCellBounds(n3, n3);
            if (rectangle2.y == rectangle.y && n3 != 0) {
                Point point = rectangle2.getLocation();
                --point.y;
                int n4 = this.locationToIndex(point);
                Rectangle rectangle3 = this.getCellBounds(n4, n4);
                if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                    return 0;
                }
                return rectangle3.height;
            }
        }
        return super.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public int getPreferredHeight(int n) {
        return ((CategoryListUI)this.getUI()).getPreferredHeight(n);
    }

    public void resetRollover() {
        this.rolloverIndex = -1;
        this.repaint();
    }

    int getColumnCount() {
        if (this.getModel().getSize() > 0) {
            int n;
            Insets insets = this.getInsets();
            int n2 = this.getWidth() - (insets.left + insets.right);
            if (n2 >= (n = this.getCellBounds((int)0, (int)0).width)) {
                return n2 / n;
            }
        }
        return 1;
    }

    private static ListCellRenderer getItemRenderer() {
        ListCellRenderer listCellRenderer;
        ListCellRenderer listCellRenderer2 = listCellRenderer = rendererRef == null ? null : (ListCellRenderer)rendererRef.get();
        if (listCellRenderer == null) {
            listCellRenderer = new ItemRenderer();
            rendererRef = new WeakReference<ListCellRenderer>(listCellRenderer);
        }
        return listCellRenderer;
    }

    public void autoscroll(Point point) {
        if (null != this.getParent() && null != this.getParent().getParent()) {
            Point point2 = SwingUtilities.convertPoint(this, point, this.getParent().getParent());
            this.getSupport().autoscroll(point2);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.getSupport().getAutoscrollInsets();
    }

    AutoscrollSupport getSupport() {
        if (null == this.support) {
            this.support = new AutoscrollSupport(this.getParent().getParent());
        }
        return this.support;
    }

    void takeFocusFrom(Component component) {
        int n = -1;
        if (component.getParent() != this.getParent()) {
            n = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() > 0) {
            n = 0;
        }
        this.requestFocus();
        this.setSelectedIndex(n);
        if (n >= 0) {
            this.ensureIndexIsVisible(n);
        }
    }

    static class CategoryListUI
    extends BasicListUI {
        CategoryListUI() {
        }

        protected void updateLayoutState() {
            super.updateLayoutState();
            if (this.list.getLayoutOrientation() == 2) {
                Insets insets = this.list.getInsets();
                int n = this.list.getWidth() - (insets.left + insets.right);
                if (n >= this.cellWidth) {
                    int n2 = n / this.cellWidth;
                    this.cellWidth = n2 == 0 ? 1 : n / n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPreferredHeight(int n) {
            int n2;
            ((CategoryList)this.list).tempWidth = n;
            try {
                n2 = (int)this.getPreferredSize(this.list).getHeight();
            }
            finally {
                ((CategoryList)this.list).tempWidth = null;
            }
            return n2;
        }

        protected MouseInputListener createMouseInputListener() {
            return new ListMouseInputHandler();
        }

        private int getValidIndex(Point point) {
            int n = this.locationToIndex(this.list, point);
            return n >= 0 && this.getCellBounds(this.list, n, n).contains(point) ? n : -1;
        }

        private class ListMouseInputHandler
        extends BasicListUI.MouseInputHandler {
            int selIndex;

            private ListMouseInputHandler() {
                super(CategoryListUI.this);
                this.selIndex = -1;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CategoryListUI.this.list.isEnabled()) {
                    return;
                }
                if (mouseEvent.getClickCount() > 1) {
                    this.selIndex = CategoryListUI.this.getValidIndex(mouseEvent.getPoint());
                    if (this.selIndex >= 0) {
                        CategoryListUI.this.list.setSelectedIndex(this.selIndex);
                        Item item = (Item)CategoryListUI.this.list.getModel().getElementAt(this.selIndex);
                        ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "doubleclick", mouseEvent.getWhen(), mouseEvent.getModifiers());
                        item.invokePreferredAction(actionEvent);
                        mouseEvent.consume();
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (CategoryListUI.this.getValidIndex(mouseEvent.getPoint()) >= 0) {
                    this.selIndex = CategoryListUI.this.list.getSelectedIndex();
                    super.mousePressed(mouseEvent);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.mouseEntered(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (CategoryListUI.this.list.isEnabled()) {
                    this.setRolloverIndex(CategoryListUI.this.getValidIndex(mouseEvent.getPoint()));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (CategoryListUI.this.list.isEnabled()) {
                    this.setRolloverIndex(-1);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (CategoryListUI.this.getValidIndex(mouseEvent.getPoint()) >= 0) {
                    super.mouseReleased(mouseEvent);
                    if (this.selIndex > -1 && CategoryListUI.this.list.getSelectedIndex() == this.selIndex) {
                        CategoryListUI.this.list.removeSelectionInterval(this.selIndex, this.selIndex);
                    }
                }
            }

            private void setRolloverIndex(int n) {
                int n2 = ((CategoryList)CategoryListUI.this.list).rolloverIndex;
                if (n != n2) {
                    Rectangle rectangle;
                    ((CategoryList)CategoryListUI.this.list).rolloverIndex = n;
                    if (n2 > -1 && (rectangle = CategoryListUI.this.getCellBounds(CategoryListUI.this.list, n2, n2)) != null) {
                        CategoryListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    if (n > -1 && (rectangle = CategoryListUI.this.getCellBounds(CategoryListUI.this.list, n, n)) != null) {
                        CategoryListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
            }
        }
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean selectNext;

        public ChangeColumnAction(Action action, boolean bl) {
            this.defaultAction = action;
            this.selectNext = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = CategoryList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(actionEvent);
            int n2 = CategoryList.this.getSelectedIndex();
            if (this.selectNext && n < n2 || !this.selectNext && n > n2) {
                return;
            }
            if (this.selectNext) {
                if (n2 == n + 1) {
                    ++n2;
                }
                if (n2 < CategoryList.this.getModel().getSize() - 1) {
                    CategoryList.this.setSelectedIndex(n2 + 1);
                    CategoryList.this.scrollRectToVisible(CategoryList.this.getCellBounds(n2 + 1, n2 + 1));
                }
            } else if (n2 > 0) {
                CategoryList.this.setSelectedIndex(n2 - 1);
                CategoryList.this.scrollRectToVisible(CategoryList.this.getCellBounds(n2 - 1, n2 - 1));
            }
        }
    }

    private class CutCopyAction
    extends AbstractAction {
        private boolean doCopy;

        public CutCopyAction(boolean bl) {
            this.doCopy = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Item item = CategoryList.this.getItemAt(CategoryList.this.getSelectedIndex());
            if (null == item) {
                return;
            }
            Node node = (Node)item.getLookup().lookup(Node.class);
            if (null == node) {
                return;
            }
            AbstractAction abstractAction = this.doCopy ? new Utils.CopyItemAction(node) : new Utils.CutItemAction(node);
            if (abstractAction.isEnabled()) {
                abstractAction.actionPerformed(actionEvent);
            }
        }

        public boolean isEnabled() {
            return CategoryList.this.getSelectedIndex() >= 0;
        }
    }

    private static class DefaultAction
    extends AbstractAction {
        private CategoryList list;

        public DefaultAction(CategoryList categoryList) {
            this.list = categoryList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Item item = this.list.getItemAt(this.list.getSelectedIndex());
            item.invokePreferredAction(actionEvent);
        }

        public boolean isEnabled() {
            return this.list.isEnabled() && this.list.getSelectedIndex() >= 0;
        }
    }

    static class ItemRenderer
    implements ListCellRenderer {
        private JToolBar toolbar;
        private JToggleButton button;

        ItemRenderer() {
            if (this.button == null) {
                this.button = new JToggleButton();
                this.button.setMargin(new Insets(1, 1, 1, 0));
                if (!CategoryButton.isGTK) {
                    this.toolbar = new JToolBar();
                    this.toolbar.setRollover(true);
                    this.toolbar.setFloatable(false);
                    this.toolbar.setLayout(new BorderLayout(0, 0));
                    this.toolbar.setBorder(BorderFactory.createEmptyBorder());
                    this.toolbar.add(this.button);
                }
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CategoryList categoryList = (CategoryList)jList;
            boolean bl3 = categoryList.getShowNames();
            int n2 = categoryList.getIconSize();
            JComponent jComponent = this.toolbar != null ? this.toolbar : this.button;
            Item item = (Item)object;
            Image image = item.getIcon(n2);
            if (image != null) {
                this.button.setIcon(new ImageIcon(image));
            }
            this.button.setText(bl3 ? item.getDisplayName() : null);
            jComponent.setToolTipText(item.getShortDescription());
            this.button.setSelected(bl);
            this.button.getModel().setRollover(n == categoryList.rolloverIndex && !bl);
            this.button.setBorderPainted(n == categoryList.rolloverIndex || bl);
            this.button.setHorizontalAlignment(bl3 ? 2 : 0);
            this.button.setHorizontalTextPosition(4);
            this.button.setVerticalTextPosition(0);
            return jComponent;
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private Action defaultAction;
        private boolean focusNext;

        public MoveFocusAction(Action action, boolean bl) {
            this.defaultAction = action;
            this.focusNext = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            int n = CategoryList.this.getSelectedIndex();
            this.defaultAction.actionPerformed(actionEvent);
            int n2 = CategoryList.this.getSelectedIndex();
            if (n != n2) {
                return;
            }
            if (this.focusNext && 0 == n2) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (null == focusTraversalPolicy) {
                focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
            }
            Component component2 = component = this.focusNext ? focusTraversalPolicy.getComponentAfter(container, CategoryList.this) : focusTraversalPolicy.getComponentBefore(container, CategoryList.this);
            if (null != component && component instanceof CategoryButton) {
                CategoryList.this.clearSelection();
                component.requestFocus();
            }
        }
    }

    private class PopupAction
    extends AbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n = 0;
            int n2 = 0;
            Item item = CategoryList.this.getItemAt(CategoryList.this.getSelectedIndex());
            if (null != item) {
                object = CategoryList.this.getCellBounds(CategoryList.this.getSelectedIndex(), CategoryList.this.getSelectedIndex());
                n = object.x;
                n2 = object.y + object.height;
            }
            object = null == item ? CategoryList.this.category.getActions() : item.getActions();
            JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])object, (Component)CategoryList.this);
            Utils.addCustomizationMenuItems(jPopupMenu, CategoryList.this.palettePanel.getController(), CategoryList.this.palettePanel.getSettings());
            jPopupMenu.show(CategoryList.this.getParent(), n, n2);
        }

        public boolean isEnabled() {
            return CategoryList.this.isEnabled();
        }
    }
}

