/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.DefaultSettings;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.RootNode;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFilter;
import org.netbeans.spi.palette.PaletteSwitch;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

public final class PaletteFactory {
    private PaletteFactory() {
    }

    public static PaletteController createPalette(String string, PaletteActions paletteActions) throws IOException {
        return PaletteFactory.createPalette(string, paletteActions, null, DragAndDropHandler.getDefault());
    }

    public static PaletteController createPalette(String string, PaletteActions paletteActions, PaletteFilter paletteFilter, DragAndDropHandler dragAndDropHandler) throws IOException {
        if (null == string) {
            throw new IllegalArgumentException("Folder name cannot be null.");
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)PaletteFactory.getPaletteFolder(string));
        return PaletteFactory.createPalette(dataFolder.getNodeDelegate(), paletteActions, paletteFilter, dragAndDropHandler);
    }

    public static PaletteController createPalette(Node node, PaletteActions paletteActions) {
        return PaletteFactory.createPalette(node, paletteActions, null, DragAndDropHandler.getDefault());
    }

    public static PaletteController createPalette(Node node, PaletteActions paletteActions, PaletteFilter paletteFilter, DragAndDropHandler dragAndDropHandler) {
        if (null == node) {
            throw new IllegalArgumentException("Palette root Node cannot be null.");
        }
        if (null == paletteActions) {
            throw new IllegalArgumentException("Palette custom actions must be provided.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(paletteActions);
        if (null != paletteFilter) {
            arrayList.add(paletteFilter);
        }
        if (null == dragAndDropHandler) {
            dragAndDropHandler = DragAndDropHandler.getDefault();
        }
        arrayList.add(dragAndDropHandler);
        RootNode rootNode = new RootNode(node, Lookups.fixed((Object[])arrayList.toArray()));
        Model model = PaletteFactory.createModel(rootNode);
        DefaultSettings defaultSettings = new DefaultSettings(model);
        PaletteSwitch.getDefault().startListening();
        return new PaletteController(model, defaultSettings);
    }

    private static Model createModel(RootNode rootNode) {
        return new DefaultModel(rootNode);
    }

    private static FileObject getPaletteFolder(String string) throws IOException {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            throw new FileNotFoundException(string);
        }
        return fileObject;
    }
}

