/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.highlights.spi.DefaultHighlight;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHolder
implements ChangeListener,
PropertyChangeListener {
    static final Map<Severity, Coloring> COLORINGS = new EnumMap<Severity, Coloring>(Severity.class);
    private Map<ErrorDescription, List<Integer>> errors2Lines;
    private Map<Integer, List<ErrorDescription>> line2Errors;
    private Map<Integer, List<Highlight>> line2Highlights;
    private Map<Integer, ParseErrorAnnotation> line2Annotations;
    private Map<String, List<ErrorDescription>> layer2Errors;
    private Set<JEditorPane> openedComponents;
    private EditorCookie.Observable editorCookie;
    private FileObject file;
    private DataObject od;
    private Document doc;
    private static Map<FileObject, AnnotationHolder> file2Holder;
    Attacher attacher = new NbDocumentAttacher();
    private static final RequestProcessor INSTANCE;

    public static synchronized AnnotationHolder getInstance(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        AnnotationHolder annotationHolder = file2Holder.get(fileObject);
        if (annotationHolder == null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
                if (observable == null) {
                    Logger.getLogger("global").log(Level.WARNING, "No EditorCookie.Observable for file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                } else {
                    StyledDocument styledDocument = observable.getDocument();
                    if (styledDocument != null) {
                        annotationHolder = new AnnotationHolder(fileObject, dataObject, styledDocument, observable);
                        file2Holder.put(fileObject, annotationHolder);
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return annotationHolder;
    }

    static synchronized Collection<FileObject> coveredFiles() {
        return new ArrayList<FileObject>(file2Holder.keySet());
    }

    private AnnotationHolder(FileObject fileObject, DataObject dataObject, Document document, EditorCookie.Observable observable) throws IOException {
        if (fileObject == null) {
            return;
        }
        this.init();
        this.file = fileObject;
        this.od = dataObject;
        this.doc = document;
        observable.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)observable));
        this.editorCookie = observable;
        this.propertyChange(null);
        TimesCollector.getDefault().reportReference(fileObject, "annotation-holder", "[M] Annotation Holder", (Object)this);
    }

    private synchronized void init() {
        this.errors2Lines = new HashMap<ErrorDescription, List<Integer>>();
        this.line2Errors = new HashMap<Integer, List<ErrorDescription>>();
        this.line2Highlights = new HashMap<Integer, List<Highlight>>();
        this.line2Annotations = new HashMap<Integer, ParseErrorAnnotation>();
        this.layer2Errors = new HashMap<String, List<ErrorDescription>>();
        this.openedComponents = new HashSet<JEditorPane>();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateVisibleRanges();
    }

    void attachAnnotation(int n, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
        this.attacher.attachAnnotation(n, parseErrorAnnotation);
    }

    void detachAnnotation(Annotation annotation) {
        this.attacher.detachAnnotation(annotation);
    }

    private synchronized void clearAll() {
        for (ParseErrorAnnotation parseErrorAnnotation : this.line2Annotations.values()) {
            this.detachAnnotation(parseErrorAnnotation);
        }
        file2Holder.remove(this.file);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditorPane[] jEditorPaneArray = AnnotationHolder.this.editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null) {
                    AnnotationHolder.this.clearAll();
                    return;
                }
                HashSet<JEditorPane> hashSet = new HashSet<JEditorPane>(Arrays.asList(jEditorPaneArray));
                HashSet hashSet2 = new HashSet(AnnotationHolder.this.openedComponents);
                hashSet2.removeAll(hashSet);
                hashSet.removeAll(AnnotationHolder.this.openedComponents);
                for (JEditorPane jEditorPane : hashSet) {
                    Container container = jEditorPane.getParent();
                    if (!(container instanceof JViewport)) continue;
                    JViewport jViewport = (JViewport)container;
                    jViewport.addChangeListener(WeakListeners.change((ChangeListener)AnnotationHolder.this, (Object)jViewport));
                }
                AnnotationHolder.this.openedComponents.removeAll(hashSet2);
                AnnotationHolder.this.openedComponents.addAll(hashSet);
                AnnotationHolder.this.updateVisibleRanges();
            }
        });
    }

    private void updateVisibleRanges() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final ArrayList<int[]> arrayList = new ArrayList<int[]>();
                AnnotationHolder annotationHolder = AnnotationHolder.this;
                synchronized (annotationHolder) {
                    for (JEditorPane jEditorPane : AnnotationHolder.this.openedComponents) {
                        Container container = jEditorPane.getParent();
                        if (!(container instanceof JViewport)) continue;
                        JViewport jViewport = (JViewport)container;
                        Point point = jViewport.getViewPosition();
                        Dimension dimension = jViewport.getExtentSize();
                        Point point2 = new Point(point.x + dimension.width, point.y + dimension.height);
                        int n = jEditorPane.viewToModel(point);
                        int n2 = jEditorPane.viewToModel(point2);
                        int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)jEditorPane.getDocument()), (int)n);
                        int n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)jEditorPane.getDocument()), (int)n2);
                        arrayList.add(new int[]{n3, n4});
                    }
                }
                INSTANCE.post(new Runnable(){

                    public void run() {
                        for (int[] nArray : arrayList) {
                            AnnotationHolder.this.updateAnnotations(nArray[0], nArray[1]);
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(int n, int n2) {
        Object object;
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        AnnotationHolder annotationHolder = this;
        synchronized (annotationHolder) {
            for (int i = n; i <= n2; ++i) {
                object = this.line2Errors.get(i);
                if (object == null) continue;
                arrayList.addAll((Collection<ErrorDescription>)object);
            }
        }
        for (ErrorDescription errorDescription : arrayList) {
            object = errorDescription.getFixes();
            if (!object.probablyContainsFixes() || object.isComputed()) continue;
            object.getFixes();
        }
    }

    private List<ErrorDescription> getErrorsForLayer(String string) {
        List<ErrorDescription> list = this.layer2Errors.get(string);
        if (list == null) {
            list = new ArrayList<ErrorDescription>();
            this.layer2Errors.put(string, list);
        }
        return list;
    }

    private List<ErrorDescription> getErrorsForLine(Integer n) {
        List<ErrorDescription> list = this.line2Errors.get(n);
        if (list == null) {
            list = new ArrayList<ErrorDescription>();
            this.line2Errors.put(n, list);
        }
        return list;
    }

    private List<ErrorDescription> filter(List<ErrorDescription> list, boolean bl) {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        for (ErrorDescription errorDescription : list) {
            if (errorDescription.getSeverity() == Severity.ERROR) {
                if (!bl) continue;
                arrayList.add(errorDescription);
                continue;
            }
            if (bl) continue;
            arrayList.add(errorDescription);
        }
        return arrayList;
    }

    private void concatDescription(List<ErrorDescription> list, StringBuffer stringBuffer) {
        boolean bl = true;
        for (ErrorDescription errorDescription : list) {
            if (!bl) {
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(errorDescription.getDescription());
            bl = false;
        }
    }

    private List<LazyFixList> computeFixes(List<ErrorDescription> list) {
        ArrayList<LazyFixList> arrayList = new ArrayList<LazyFixList>();
        for (ErrorDescription errorDescription : list) {
            arrayList.add(errorDescription.getFixes());
        }
        return arrayList;
    }

    private void updateAnnotationOnLine(Integer n) throws BadLocationException {
        Severity severity;
        List<ErrorDescription> list = this.getErrorsForLine(n);
        if (list.isEmpty()) {
            Annotation annotation = this.line2Annotations.remove(n);
            this.detachAnnotation(annotation);
            return;
        }
        List<ErrorDescription> list2 = this.filter(list, true);
        List<ErrorDescription> list3 = this.filter(list, false);
        boolean bl = !list2.isEmpty();
        StringBuffer stringBuffer = new StringBuffer();
        this.concatDescription(list2, stringBuffer);
        if (!list2.isEmpty() && !list3.isEmpty()) {
            stringBuffer.append("\n\n");
        }
        this.concatDescription(list3, stringBuffer);
        if (bl) {
            severity = Severity.ERROR;
        } else {
            severity = Severity.HINT;
            for (ErrorDescription object2 : list3) {
                if (severity.compareTo(object2.getSeverity()) <= 0) continue;
                severity = object2.getSeverity();
            }
        }
        LazyFixList lazyFixList = ErrorDescriptionFactory.lazyListForDelegates(this.computeFixes(bl ? list2 : list3));
        ParseErrorAnnotation parseErrorAnnotation = new ParseErrorAnnotation(severity, lazyFixList, stringBuffer.toString(), n, this);
        Annotation annotation = this.line2Annotations.put(n, parseErrorAnnotation);
        if (annotation != null) {
            this.detachAnnotation(annotation);
        }
        this.attachAnnotation(n, parseErrorAnnotation);
    }

    private void doUpdateHighlight(FileObject fileObject) {
        ArrayList<Highlight> arrayList = new ArrayList<Highlight>();
        for (List<Highlight> list : this.line2Highlights.values()) {
            arrayList.addAll(list);
        }
        Highlighter.getDefault().setHighlights(fileObject, AnnotationHolder.class.getName(), arrayList);
    }

    void updateHighlightsOnLine(Integer n) throws IOException {
        List<ErrorDescription> list = this.getErrorsForLine(n);
        if (list.isEmpty()) {
            this.line2Highlights.remove(n);
            return;
        }
        ArrayList<Highlight> arrayList = new ArrayList<Highlight>();
        try {
            AnnotationHolder.computeHighlights(this.doc, n, list, arrayList);
            this.line2Highlights.put(n, arrayList);
        }
        catch (BadLocationException badLocationException) {
            throw (IOException)new IOException().initCause(badLocationException);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static void computeHighlights(Document var0, Integer var1_1, List<ErrorDescription> var2_2, List<Highlight> var3_3) throws IOException, BadLocationException {
        for (Severity var5_5 : Arrays.asList(new Severity[]{Severity.ERROR, Severity.WARNING, Severity.VERIFIER})) {
            var6_6 = AnnotationHolder.COLORINGS.get((Object)var5_5);
            var7_7 = new ArrayList<Iterator<E>>();
            for (Object var9_9 : var2_2) {
                if (var9_9.getSeverity() != var5_5) continue;
                var7_7.add(var9_9);
            }
            var8_8 = new ArrayList<E>();
            var9_9 = var7_7.iterator();
            while (var9_9.hasNext()) {
                var10_10 /* !! */  = (ErrorDescription)var9_9.next();
                var11_11 = new DefaultHighlight(var6_6, var10_10 /* !! */ .getRange().getBegin().getPosition(), var10_10 /* !! */ .getRange().getEnd().getPosition());
                var12_12 = var8_8.iterator();
                block16: while (var12_12.hasNext() && var11_11 != null) {
                    var13_13 = (Highlight)var12_12.next();
                    switch (AnnotationHolder.detectCollisions(var13_13, (Highlight)var11_11)) {
                        case 0: {
                            ** GOTO lbl31
                        }
                        case 1: {
                            var12_12.remove();
                            ** GOTO lbl31
                        }
                        case 2: {
                            var11_11 = null;
                            break block16;
                        }
                        case 3: 
                        case 4: {
                            var14_15 = Math.min(var13_13.getStart(), var11_11.getStart());
                            var15_16 = Math.max(var13_13.getEnd(), var11_11.getEnd());
                            var11_11 = new DefaultHighlight(var6_6, var0.createPosition(var14_15), var0.createPosition(var15_16));
                            var12_12.remove();
                        }
lbl31:
                        // 4 sources

                        default: {
                            continue block16;
                        }
                    }
                }
                if (var11_11 == null) continue;
                var8_8.add(var11_11);
            }
            block17: while (!var8_8.isEmpty()) {
                var9_9 = var8_8.iterator();
                while (var9_9.hasNext()) {
                    var10_10 /* !! */  = (Highlight)var9_9.next();
                    var9_9.remove();
                    var11_11 = var3_3.iterator();
                    while (var11_11.hasNext() && var10_10 /* !! */  != null) {
                        var12_12 = (Highlight)var11_11.next();
                        switch (AnnotationHolder.detectCollisions(var12_12, (Highlight)var10_10 /* !! */ )) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                var13_14 = var12_12.getEnd() + 1;
                                var14_15 = var12_12.getStart() - 1;
                                if (var13_14 < var0.getLength() && var13_14 < var10_10 /* !! */ .getEnd()) {
                                    var8_8.add(new DefaultHighlight(var10_10 /* !! */ .getColoring(), var0.createPosition(var13_14), var0.createPosition(var10_10 /* !! */ .getEnd())));
                                }
                                if (var14_15 >= var0.getLength() || var10_10 /* !! */ .getStart() >= var14_15) continue block17;
                                var8_8.add(new DefaultHighlight(var10_10 /* !! */ .getColoring(), var0.createPosition(var10_10 /* !! */ .getStart()), var0.createPosition(var14_15)));
                                continue block17;
                            }
                            case 2: {
                                var10_10 /* !! */  = null;
                                break;
                            }
                            case 3: {
                                var13_14 = var12_12.getEnd() + 1;
                                if (var13_14 < var0.getLength() && var13_14 < var10_10 /* !! */ .getEnd()) {
                                    var10_10 /* !! */  = new DefaultHighlight(var10_10 /* !! */ .getColoring(), var0.createPosition(var13_14), var0.createPosition(var10_10 /* !! */ .getEnd()));
                                    break;
                                }
                                var10_10 /* !! */  = null;
                                break;
                            }
                            case 4: {
                                var14_15 = var12_12.getStart() - 1;
                                var10_10 /* !! */  = var14_15 < var0.getLength() && var10_10 /* !! */ .getStart() < var14_15 ? new DefaultHighlight(var10_10 /* !! */ .getColoring(), var0.createPosition(var10_10 /* !! */ .getStart()), var0.createPosition(var14_15)) : null;
                            }
                        }
                    }
                    if (var10_10 /* !! */  == null) continue;
                    var3_3.add((Highlight)var10_10 /* !! */ );
                }
            }
        }
    }

    private static int detectCollisions(Highlight highlight, Highlight highlight2) {
        if (highlight2.getEnd() < highlight.getStart()) {
            return 0;
        }
        if (highlight.getEnd() < highlight2.getStart()) {
            return 0;
        }
        if (highlight2.getStart() < highlight.getStart() && highlight2.getEnd() > highlight.getEnd()) {
            return 1;
        }
        if (highlight.getStart() < highlight2.getStart() && highlight.getEnd() > highlight2.getEnd()) {
            return 2;
        }
        if (highlight.getStart() < highlight2.getStart()) {
            return 3;
        }
        return 4;
    }

    public synchronized void setErrorDescriptions(final String string, final Collection<? extends ErrorDescription> collection) {
        this.doc.render(new Runnable(){

            public void run() {
                try {
                    AnnotationHolder.this.setErrorDescriptionsImpl(AnnotationHolder.this.file, string, collection);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.WARNING, iOException.getMessage(), iOException);
                }
            }
        });
    }

    private synchronized void setErrorDescriptionsImpl(FileObject fileObject, String string, Collection<? extends ErrorDescription> collection) throws IOException {
        long l = System.currentTimeMillis();
        try {
            if (fileObject == null) {
                return;
            }
            List<ErrorDescription> list = this.getErrorsForLayer(string);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            for (ErrorDescription iterator : list) {
                List<Integer> list2 = this.errors2Lines.remove(iterator);
                assert (list2 != null);
                boolean bl = true;
                for (Integer n : list2) {
                    this.getErrorsForLine(n).remove(iterator);
                    if (bl) {
                        hashSet.add(n);
                    }
                    hashSet2.add(n);
                    bl = false;
                }
            }
            ArrayList arrayList = new ArrayList();
            for (ErrorDescription errorDescription : collection) {
                int n;
                if (errorDescription.getRange() == null) continue;
                arrayList.add(errorDescription);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                int n2 = errorDescription.getRange().getBegin().getLine();
                int n3 = errorDescription.getRange().getEnd().getLine();
                for (n = n2; n <= n3; ++n) {
                    arrayList2.add(n);
                }
                this.errors2Lines.put(errorDescription, arrayList2);
                n = 1;
                for (Integer n4 : arrayList2) {
                    this.getErrorsForLine(n4).add(errorDescription);
                    if (n != 0) {
                        hashSet.add(n4);
                    }
                    hashSet2.add(n4);
                    n = 0;
                }
            }
            list.clear();
            list.addAll(arrayList);
            for (Integer n : hashSet) {
                this.updateAnnotationOnLine(n);
            }
            for (Integer n : hashSet2) {
                this.updateHighlightsOnLine(n);
            }
            this.doUpdateHighlight(fileObject);
            this.updateVisibleRanges();
        }
        catch (BadLocationException badLocationException) {
            throw (IOException)new IOException().initCause(badLocationException);
        }
        finally {
            long l2 = System.currentTimeMillis();
            TimesCollector.getDefault().reportTime(fileObject, "annotation-holder-" + string, "Errors update for " + string, l2 - l);
        }
    }

    public synchronized boolean hasErrors() {
        for (ErrorDescription errorDescription : this.errors2Lines.keySet()) {
            if (errorDescription.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public synchronized List<ErrorDescription> getErrors() {
        return new ArrayList<ErrorDescription>(this.errors2Lines.keySet());
    }

    public synchronized List<Annotation> getAnnotations() {
        return new ArrayList<Annotation>(this.line2Annotations.values());
    }

    static {
        COLORINGS.put(Severity.DISABLED, new Coloring());
        COLORINGS.put(Severity.ERROR, new Coloring(null, 0, null, null, null, null, new Color(255, 0, 0)));
        COLORINGS.put(Severity.WARNING, new Coloring(null, 0, null, null, null, null, new Color(192, 192, 0)));
        COLORINGS.put(Severity.VERIFIER, new Coloring(null, 0, null, null, null, null, new Color(255, 213, 85)));
        COLORINGS.put(Severity.HINT, new Coloring());
        COLORINGS.put(Severity.TODO, new Coloring(Font.decode(null).deriveFont(1), 2, Color.BLUE, null));
        file2Holder = new HashMap<FileObject, AnnotationHolder>();
        INSTANCE = new RequestProcessor("AnnotationHolder");
    }

    static interface Attacher {
        public void attachAnnotation(int var1, ParseErrorAnnotation var2) throws BadLocationException;

        public void detachAnnotation(Annotation var1);
    }

    final class LineAttacher
    implements Attacher {
        LineAttacher() {
        }

        public void attachAnnotation(int n, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
            LineCookie lineCookie = (LineCookie)AnnotationHolder.this.od.getCookie(LineCookie.class);
            Line line = lineCookie.getLineSet().getCurrent(n);
            parseErrorAnnotation.attach((Annotatable)line);
        }

        public void detachAnnotation(Annotation annotation) {
            annotation.detach();
        }
    }

    final class NbDocumentAttacher
    implements Attacher {
        NbDocumentAttacher() {
        }

        public void attachAnnotation(int n, ParseErrorAnnotation parseErrorAnnotation) throws BadLocationException {
            Position position = AnnotationHolder.this.doc.createPosition(NbDocument.findLineOffset((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (int)n));
            NbDocument.addAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Position)position, (int)-1, (Annotation)parseErrorAnnotation);
        }

        public void detachAnnotation(Annotation annotation) {
            if (AnnotationHolder.this.doc != null) {
                NbDocument.removeAnnotation((StyledDocument)((StyledDocument)AnnotationHolder.this.doc), (Annotation)annotation);
            }
        }
    }
}

